/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.rocketmq.message;

import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.MQProducer;
import org.apache.rocketmq.client.producer.MessageQueueSelector;
import org.apache.rocketmq.client.producer.SendCallback;
import org.apache.rocketmq.client.producer.SendResult;
import org.apache.rocketmq.client.producer.selector.SelectMessageQueueByHash;
import org.apache.rocketmq.common.message.Message;
import org.apache.rocketmq.remoting.exception.RemotingException;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.SendMessageService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQSendMessageService
implements SendMessageService {
    private static final Logger logger = LoggerFactory.getLogger(RocketMQSendMessageService.class);
    private final MQProducer producer;

    public RocketMQSendMessageService(MQProducer producer) {
        this.producer = producer;
    }

    public CompletableFuture<Boolean> sendMessageAsync(final QueueMessage queueMessage) {
        final CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Message message = this.covertToProducerRecord(queueMessage);
        try {
            this.producer.send(message, (MessageQueueSelector)new SelectMessageQueueByHash(), (Object)queueMessage.getRouteKey(), new SendCallback(){

                public void onSuccess(SendResult result) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Async send message success, sendResult: {}, message: {}", (Object)result, (Object)queueMessage);
                    }
                    future.complete(true);
                }

                public void onException(Throwable ex) {
                    future.completeExceptionally((Throwable)new IORuntimeException(ex));
                    logger.error("Async send message has exception, message: {}", (Object)queueMessage, (Object)ex);
                }
            });
        }
        catch (InterruptedException | MQClientException | RemotingException ex) {
            future.completeExceptionally((Throwable)new IORuntimeException(ex));
            logger.error("Async send message has exception, message: {}", (Object)queueMessage, (Object)ex);
        }
        return future;
    }

    private Message covertToProducerRecord(QueueMessage queueMessage) {
        Message message = new Message(queueMessage.getTopic(), queueMessage.getTag(), queueMessage.getKey(), queueMessage.getBodyAndType().getBytes(StandardCharsets.UTF_8));
        return message;
    }
}

