/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding;

import java.util.Date;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.IProcessingCommandHandler;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.utilities.SystemClock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\u0018\u0000 @2\u00020\u0001:\u0001@B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0003J\u001c\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00160*2\u0006\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-J\u0006\u0010.\u001a\u00020'J\u000e\u0010/\u001a\u00020'2\u0006\u0010+\u001a\u00020\"J\u0006\u00100\u001a\u00020'J\u0012\u00101\u001a\u0004\u0018\u00010\"2\u0006\u00102\u001a\u00020!H\u0002J\u0006\u00103\u001a\u00020!J\u000e\u00104\u001a\u00020\u00162\u0006\u00105\u001a\u00020\u0007J\u0006\u0010\u0019\u001a\u00020\u0016J\u0006\u00106\u001a\u00020'J\u0006\u00107\u001a\u00020'J\u0011\u00108\u001a\u00020'H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u00109J\u000e\u0010:\u001a\u00020'2\u0006\u0010\u000f\u001a\u00020!J\u0006\u0010;\u001a\u00020'J\b\u0010<\u001a\u00020'H\u0002J\b\u0010=\u001a\u00020'H\u0002J\u0006\u0010>\u001a\u00020'J\u0006\u0010?\u001a\u00020\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00140\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u0016@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0018R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020$X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010%\u001a\u00020!X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006A"}, d2={"Lorg/enodeframework/commanding/ProcessingCommandMailbox;", "", "aggregateRootId", "", "messageHandler", "Lorg/enodeframework/commanding/IProcessingCommandHandler;", "batchSize", "", "(Ljava/lang/String;Lorg/enodeframework/commanding/IProcessingCommandHandler;I)V", "getAggregateRootId", "()Ljava/lang/String;", "setAggregateRootId", "(Ljava/lang/String;)V", "<set-?>", "Ljava/util/concurrent/atomic/AtomicLong;", "consumingSequence", "getConsumingSequence", "()Ljava/util/concurrent/atomic/AtomicLong;", "duplicateCommandIdDict", "Ljava/util/concurrent/ConcurrentHashMap;", "", "isPauseRequested", "", "isPaused", "()Z", "isRemoved", "Ljava/util/concurrent/atomic/AtomicInteger;", "isRunning", "isUsing", "lastActiveTime", "Ljava/util/Date;", "lockObj", "messageDict", "", "Lorg/enodeframework/commanding/ProcessingCommand;", "mutex", "Lkotlinx/coroutines/sync/Mutex;", "nextSequence", "addDuplicateCommandId", "", "commandId", "completeMessage", "Ljava/util/concurrent/CompletableFuture;", "message", "result", "Lorg/enodeframework/commanding/CommandResult;", "completeRun", "enqueueMessage", "exitUsing", "getMessage", "sequence", "getTotalUnHandledMessageCount", "isInactive", "timeoutSeconds", "markAsRemoved", "pause", "processMessagesAwait", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "resetConsumingSequence", "resume", "setAsNotRunning", "setAsRunning", "tryRun", "tryUsing", "Companion", "enode"})
public final class ProcessingCommandMailbox {
    private final Object lockObj;
    private final Mutex mutex;
    private ConcurrentHashMap<Long, ProcessingCommand> messageDict;
    private ConcurrentHashMap<String, Byte> duplicateCommandIdDict;
    private final AtomicInteger isUsing;
    private final AtomicInteger isRemoved;
    private Date lastActiveTime;
    private boolean isRunning;
    private boolean isPauseRequested;
    private boolean isPaused;
    private long nextSequence;
    @NotNull
    private AtomicLong consumingSequence;
    @NotNull
    private String aggregateRootId;
    private final IProcessingCommandHandler messageHandler;
    private final int batchSize;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    @NotNull
    public final AtomicLong getConsumingSequence() {
        return this.consumingSequence;
    }

    public final long getTotalUnHandledMessageCount() {
        return this.nextSequence - this.consumingSequence.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueMessage(@NotNull ProcessingCommand message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = this.lockObj;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            message.setSequence(this.nextSequence);
            message.setMailBox(this);
            if (this.messageDict.putIfAbsent(message.getSequence(), message) == null) {
                long l = this.nextSequence;
                this.nextSequence = l + 1L;
                Logger logger = ProcessingCommandMailbox.logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                if (logger.isDebugEnabled()) {
                    ProcessingCommandMailbox.logger.debug("{} enqueued new message, aggregateRootId: {}, messageSequence: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, message.getSequence()});
                }
                this.lastActiveTime = new Date();
                this.tryRun();
            } else {
                logger.error("{} enqueue message failed, aggregateRootId: {}, messageId: {}, messageSequence: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, message.getMessage().getId(), message.getSequence()});
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryRun() {
        Object object = this.lockObj;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.isRunning || this.isPauseRequested || this.isPaused) {
                return;
            }
            this.setAsRunning();
            Logger logger = ProcessingCommandMailbox.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            if (logger.isDebugEnabled()) {
                ProcessingCommandMailbox.logger.debug("{} start run, aggregateRootId: {}, consumingSequence: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, this.consumingSequence.get()});
            }
            Job job = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, this){
                int label;
                final /* synthetic */ ProcessingCommandMailbox this$0;
                {
                    this.this$0 = processingCommandMailbox;
                    super(2, continuation);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.this$0.processMessagesAwait((Continuation<? super Unit>)this);
                            Object object4 = object3;
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object4 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void completeRun() {
        this.lastActiveTime = new Date();
        Logger logger = ProcessingCommandMailbox.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isDebugEnabled()) {
            ProcessingCommandMailbox.logger.debug("{} complete run, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
        }
        this.setAsNotRunning();
        if (this.getTotalUnHandledMessageCount() > 0L) {
            this.tryRun();
        }
    }

    public final void pause() {
        this.isPauseRequested = true;
        Logger logger = ProcessingCommandMailbox.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isDebugEnabled()) {
            ProcessingCommandMailbox.logger.debug("{} pause requested, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
        }
        long count = 0L;
        while (this.isRunning) {
            Task.sleep(10L);
            long l = count;
            if ((count = l + 1L) % (long)100 != 0L) continue;
            Logger logger2 = ProcessingCommandMailbox.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"logger");
            if (!logger2.isDebugEnabled()) continue;
            ProcessingCommandMailbox.logger.debug("{} pause requested, but wait for too long to stop the current mailbox, aggregateRootId: {}, waitCount: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, count});
        }
        this.lastActiveTime = new Date();
        this.isPaused = true;
    }

    public final void resume() {
        this.isPauseRequested = false;
        this.isPaused = false;
        this.lastActiveTime = new Date();
        Logger logger = ProcessingCommandMailbox.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isDebugEnabled()) {
            ProcessingCommandMailbox.logger.debug("{} resume requested, aggregateRootId: {}, consumingSequence: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, this.consumingSequence.get()});
        }
    }

    public final void addDuplicateCommandId(@NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        this.duplicateCommandIdDict.putIfAbsent(commandId, (byte)1);
    }

    public final void resetConsumingSequence(long consumingSequence) {
        this.consumingSequence.set(consumingSequence);
        this.lastActiveTime = new Date();
        Logger logger = ProcessingCommandMailbox.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isDebugEnabled()) {
            ProcessingCommandMailbox.logger.debug("{} reset consumingSequence, aggregateRootId: {}, consumingSequence: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, consumingSequence});
        }
    }

    @NotNull
    public final CompletableFuture<Boolean> completeMessage(@NotNull ProcessingCommand message, @NotNull CommandResult result) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        try {
            ProcessingCommand removed = this.messageDict.remove(message.getSequence());
            if (removed != null) {
                this.duplicateCommandIdDict.remove(message.getMessage().getId());
                this.lastActiveTime = new Date();
                return message.completeAsync(result);
            }
        }
        catch (Exception ex) {
            logger.error("{} complete message with result failed, aggregateRootId: {}, messageId: {}, messageSequence: {}, result: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, message.getMessage().getId(), message.getSequence(), result, ex});
        }
        return Task.completedTask;
    }

    public final boolean isInactive(int timeoutSeconds) {
        return SystemClock.now() - this.lastActiveTime.getTime() >= (long)timeoutSeconds;
    }

    /*
     * Exception decompiling
     */
    final /* synthetic */ Object processMessagesAwait(Continuation<? super Unit> var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 0[TRYBLOCK]], but top level block is 14[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private final ProcessingCommand getMessage(long sequence) {
        Map map = this.messageDict;
        Long l = sequence;
        Object v = null;
        boolean bl = false;
        Map map2 = map;
        if (map2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, V>");
        }
        return map2.getOrDefault(l, v);
    }

    private final void setAsRunning() {
        this.isRunning = true;
    }

    public final boolean tryUsing() {
        return this.isUsing.compareAndSet(0, 1);
    }

    public final void exitUsing() {
        this.isUsing.set(0);
    }

    public final void markAsRemoved() {
        this.isRemoved.set(1);
    }

    public final boolean isRemoved() {
        return this.isRemoved.get() == 1;
    }

    private final void setAsNotRunning() {
        this.isRunning = false;
    }

    @NotNull
    public final String getAggregateRootId() {
        return this.aggregateRootId;
    }

    public final void setAggregateRootId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.aggregateRootId = string;
    }

    public ProcessingCommandMailbox(@NotNull String aggregateRootId, @NotNull IProcessingCommandHandler messageHandler, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)messageHandler, (String)"messageHandler");
        this.aggregateRootId = aggregateRootId;
        this.messageHandler = messageHandler;
        this.batchSize = batchSize;
        this.lockObj = new Object();
        this.mutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
        this.messageDict = new ConcurrentHashMap();
        this.duplicateCommandIdDict = new ConcurrentHashMap();
        this.isUsing = new AtomicInteger(0);
        this.isRemoved = new AtomicInteger(0);
        this.consumingSequence = new AtomicLong(0L);
        this.lastActiveTime = new Date();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(ProcessingCommandMailbox.class);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/enodeframework/commanding/ProcessingCommandMailbox$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "enode"})
    public static final class Companion {
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

