/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.ICommandExecuteContext;
import org.enodeframework.common.exception.AggregateRootAlreadyExistException;
import org.enodeframework.common.exception.AggregateRootNotFoundException;
import org.enodeframework.common.io.ReplySocketAddress;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.utilities.Ensure;
import org.enodeframework.domain.IAggregateRoot;
import org.enodeframework.domain.IAggregateStorage;
import org.enodeframework.domain.IRepository;
import org.enodeframework.messaging.IApplicationMessage;
import org.enodeframework.queue.IMessageContext;
import org.enodeframework.queue.ISendReplyService;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.command.CommandMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u001dH\u0016J\u0016\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u0010$\u001a\u00020\u001dH\u0016J\b\u0010(\u001a\u00020#H\u0016J-\u0010)\u001a\u0002H*\"\b\b\u0000\u0010**\u00020\u001d2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H*0.H\u0016\u00a2\u0006\u0002\u0010/J5\u0010)\u001a\u0002H*\"\b\b\u0000\u0010**\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u00100\u001a\u00020'2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H*0.H\u0016\u00a2\u0006\u0002\u00101J.\u00102\u001a\b\u0012\u0004\u0012\u0002H*0&\"\b\b\u0000\u0010**\u00020\u001d2\u0006\u0010+\u001a\u00020,2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H*0.H\u0016J6\u00102\u001a\b\u0012\u0004\u0012\u0002H*0&\"\b\b\u0000\u0010**\u00020\u001d2\u0006\u0010+\u001a\u00020,2\u0006\u00100\u001a\u00020'2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H*0.H\u0016J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020'0&2\u0006\u00104\u001a\u000205H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u00020\u0016X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u001d0!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/enodeframework/commanding/impl/CommandExecuteContext;", "Lorg/enodeframework/commanding/ICommandExecuteContext;", "repository", "Lorg/enodeframework/domain/IRepository;", "aggregateRootStorage", "Lorg/enodeframework/domain/IAggregateStorage;", "queueMessage", "Lorg/enodeframework/queue/QueueMessage;", "messageContext", "Lorg/enodeframework/queue/IMessageContext;", "commandMessage", "Lorg/enodeframework/queue/command/CommandMessage;", "sendReplyService", "Lorg/enodeframework/queue/ISendReplyService;", "(Lorg/enodeframework/domain/IRepository;Lorg/enodeframework/domain/IAggregateStorage;Lorg/enodeframework/queue/QueueMessage;Lorg/enodeframework/queue/IMessageContext;Lorg/enodeframework/queue/command/CommandMessage;Lorg/enodeframework/queue/ISendReplyService;)V", "applicationMessage", "Lorg/enodeframework/messaging/IApplicationMessage;", "getApplicationMessage", "()Lorg/enodeframework/messaging/IApplicationMessage;", "setApplicationMessage", "(Lorg/enodeframework/messaging/IApplicationMessage;)V", "result", "", "getResult", "()Ljava/lang/String;", "setResult", "(Ljava/lang/String;)V", "trackedAggregateRoots", "", "Lorg/enodeframework/domain/IAggregateRoot;", "getTrackedAggregateRoots", "()Ljava/util/List;", "trackingAggregateRootDict", "Ljava/util/concurrent/ConcurrentMap;", "add", "", "aggregateRoot", "addAsync", "Ljava/util/concurrent/CompletableFuture;", "", "clear", "get", "T", "id", "", "aggregateRootType", "Ljava/lang/Class;", "(Ljava/lang/Object;Ljava/lang/Class;)Lorg/enodeframework/domain/IAggregateRoot;", "firstFromCache", "(Ljava/lang/Object;ZLjava/lang/Class;)Lorg/enodeframework/domain/IAggregateRoot;", "getAsync", "onCommandExecutedAsync", "commandResult", "Lorg/enodeframework/commanding/CommandResult;", "enode"})
public final class CommandExecuteContext
implements ICommandExecuteContext {
    private final ConcurrentMap<String, IAggregateRoot> trackingAggregateRootDict;
    private final IRepository repository;
    private final IAggregateStorage aggregateRootStorage;
    private final ISendReplyService sendReplyService;
    private final QueueMessage queueMessage;
    private final IMessageContext messageContext;
    private final CommandMessage commandMessage;
    @NotNull
    private String result;
    @Nullable
    private IApplicationMessage applicationMessage;

    @Override
    @NotNull
    public String getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.result = string;
    }

    @Override
    @Nullable
    public IApplicationMessage getApplicationMessage() {
        return this.applicationMessage;
    }

    @Override
    public void setApplicationMessage(@Nullable IApplicationMessage iApplicationMessage) {
        this.applicationMessage = iApplicationMessage;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> onCommandExecutedAsync(@NotNull CommandResult commandResult) {
        CompletableFuture<Boolean> completableFuture;
        Intrinsics.checkNotNullParameter((Object)commandResult, (String)"commandResult");
        this.messageContext.onMessageHandled(this.queueMessage);
        if (Objects.isNull(this.commandMessage.getReplyAddress())) {
            completableFuture = Task.completedTask;
        } else {
            ReplySocketAddress replySocketAddress = this.commandMessage.getReplyAddress();
            Intrinsics.checkNotNullExpressionValue((Object)replySocketAddress, (String)"commandMessage.replyAddress");
            completableFuture = this.sendReplyService.sendCommandReply(commandResult, replySocketAddress);
        }
        return completableFuture;
    }

    @Override
    public void add(@NotNull IAggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)aggregateRoot, (String)"aggregateRoot");
        Ensure.notNull(aggregateRoot, "aggregateRoot");
        if (this.trackingAggregateRootDict.containsKey(aggregateRoot.getUniqueId())) {
            throw (Throwable)new AggregateRootAlreadyExistException(aggregateRoot.getUniqueId(), aggregateRoot.getClass());
        }
        ((Map)this.trackingAggregateRootDict).put(aggregateRoot.getUniqueId(), aggregateRoot);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> addAsync(@NotNull IAggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)aggregateRoot, (String)"aggregateRoot");
        this.add(aggregateRoot);
        return Task.completedTask;
    }

    @Override
    @NotNull
    public <T extends IAggregateRoot> CompletableFuture<T> getAsync(@NotNull Object id, boolean firstFromCache, @NotNull Class<T> aggregateRootType) {
        CompletableFuture<T> completableFuture;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Ensure.notNull(id, "id");
        String aggregateRootId = id.toString();
        IAggregateRoot iAggregateRoot = (IAggregateRoot)this.trackingAggregateRootDict.get(aggregateRootId);
        CompletableFuture<IAggregateRoot> future = new CompletableFuture<IAggregateRoot>();
        if (iAggregateRoot != null) {
            future.complete(iAggregateRoot);
            return future;
        }
        if (firstFromCache) {
            CompletableFuture<T> completableFuture2 = this.repository.getAsync(aggregateRootType, id);
            completableFuture = completableFuture2;
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"repository.getAsync(aggregateRootType, id)");
        } else {
            completableFuture = this.aggregateRootStorage.getAsync(aggregateRootType, aggregateRootId);
        }
        future = completableFuture;
        CompletionStage completionStage = future.thenApply(new Function<T, T>(this, aggregateRootId, aggregateRootType){
            final /* synthetic */ CommandExecuteContext this$0;
            final /* synthetic */ String $aggregateRootId;
            final /* synthetic */ Class $aggregateRootType;

            public final T apply(@Nullable T aggregateRoot) {
                if (aggregateRoot == null) {
                    throw (Throwable)new AggregateRootNotFoundException(this.$aggregateRootId, this.$aggregateRootType);
                }
                ((Map)CommandExecuteContext.access$getTrackingAggregateRootDict$p(this.this$0)).put(aggregateRoot.getUniqueId(), aggregateRoot);
                CommandExecuteContext.access$getRepository$p(this.this$0).refreshAggregate(aggregateRoot);
                return aggregateRoot;
            }
            {
                this.this$0 = commandExecuteContext;
                this.$aggregateRootId = string;
                this.$aggregateRootType = clazz;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"future.thenApply { aggre\u2026  aggregateRoot\n        }");
        return completionStage;
    }

    @Override
    @NotNull
    public <T extends IAggregateRoot> CompletableFuture<T> getAsync(@NotNull Object id, @NotNull Class<T> aggregateRootType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        return this.getAsync(id, true, aggregateRootType);
    }

    @Override
    @NotNull
    public <T extends IAggregateRoot> T get(@NotNull Object id, boolean firstFromCache, @NotNull Class<T> aggregateRootType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        T t = this.getAsync(id, firstFromCache, aggregateRootType).join();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getAsync(id, firstFromCa\u2026aggregateRootType).join()");
        return (T)((IAggregateRoot)t);
    }

    @Override
    @NotNull
    public <T extends IAggregateRoot> T get(@NotNull Object id, @NotNull Class<T> aggregateRootType) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        T t = this.getAsync(id, aggregateRootType).join();
        Intrinsics.checkNotNullExpressionValue(t, (String)"getAsync(id, aggregateRootType).join()");
        return (T)((IAggregateRoot)t);
    }

    @Override
    @NotNull
    public List<IAggregateRoot> getTrackedAggregateRoots() {
        return new ArrayList(this.trackingAggregateRootDict.values());
    }

    @Override
    public void clear() {
        this.trackingAggregateRootDict.clear();
        this.setResult("");
    }

    public CommandExecuteContext(@NotNull IRepository repository, @NotNull IAggregateStorage aggregateRootStorage, @NotNull QueueMessage queueMessage, @NotNull IMessageContext messageContext, @NotNull CommandMessage commandMessage, @NotNull ISendReplyService sendReplyService) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)aggregateRootStorage, (String)"aggregateRootStorage");
        Intrinsics.checkNotNullParameter((Object)queueMessage, (String)"queueMessage");
        Intrinsics.checkNotNullParameter((Object)messageContext, (String)"messageContext");
        Intrinsics.checkNotNullParameter((Object)commandMessage, (String)"commandMessage");
        Intrinsics.checkNotNullParameter((Object)sendReplyService, (String)"sendReplyService");
        this.result = "";
        this.trackingAggregateRootDict = new ConcurrentHashMap();
        this.repository = repository;
        this.aggregateRootStorage = aggregateRootStorage;
        this.sendReplyService = sendReplyService;
        this.queueMessage = queueMessage;
        this.commandMessage = commandMessage;
        this.messageContext = messageContext;
    }

    public static final /* synthetic */ ConcurrentMap access$getTrackingAggregateRootDict$p(CommandExecuteContext $this) {
        return $this.trackingAggregateRootDict;
    }

    public static final /* synthetic */ IRepository access$getRepository$p(CommandExecuteContext $this) {
        return $this.repository;
    }
}

