/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding.impl;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandStatus;
import org.enodeframework.commanding.ICommand;
import org.enodeframework.commanding.ICommandExecuteContext;
import org.enodeframework.commanding.ICommandHandlerProvider;
import org.enodeframework.commanding.ICommandHandlerProxy;
import org.enodeframework.commanding.IProcessingCommandHandler;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.impl.DefaultProcessingCommandHandler;
import org.enodeframework.commanding.impl.DefaultProcessingCommandHandler$WhenMappings;
import org.enodeframework.commanding.impl.HandlerFindResult;
import org.enodeframework.commanding.impl.HandlerFindStatus;
import org.enodeframework.common.function.Action1;
import org.enodeframework.common.function.Action2;
import org.enodeframework.common.function.Func;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.domain.AggregateRootReferenceChangedException;
import org.enodeframework.domain.IAggregateRoot;
import org.enodeframework.domain.IDomainException;
import org.enodeframework.domain.IMemoryCache;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventCommittingContext;
import org.enodeframework.eventing.IDomainEvent;
import org.enodeframework.eventing.IEventCommittingService;
import org.enodeframework.eventing.IEventStore;
import org.enodeframework.infrastructure.ITypeNameProvider;
import org.enodeframework.messaging.IApplicationMessage;
import org.enodeframework.messaging.IMessage;
import org.enodeframework.messaging.IMessagePublisher;
import org.enodeframework.messaging.MessageHandlerData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u00017BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J0\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001d2\b\u0010\"\u001a\u0004\u0018\u00010\u001dH\u0002J4\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00182\"\u0010%\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030'\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0(0&H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020*2\u0006\u00101\u001a\u000202H\u0002J6\u00103\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020*2\u0006\u0010-\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00101\u001a\u000202H\u0002J&\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00102\u0006\u00101\u001a\u000202H\u0002J&\u00105\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0002J\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/enodeframework/commanding/impl/DefaultProcessingCommandHandler;", "Lorg/enodeframework/commanding/IProcessingCommandHandler;", "eventStore", "Lorg/enodeframework/eventing/IEventStore;", "commandHandlerProvider", "Lorg/enodeframework/commanding/ICommandHandlerProvider;", "typeNameProvider", "Lorg/enodeframework/infrastructure/ITypeNameProvider;", "eventCommittingService", "Lorg/enodeframework/eventing/IEventCommittingService;", "memoryCache", "Lorg/enodeframework/domain/IMemoryCache;", "applicationMessagePublisher", "Lorg/enodeframework/messaging/IMessagePublisher;", "Lorg/enodeframework/messaging/IApplicationMessage;", "exceptionPublisher", "Lorg/enodeframework/domain/IDomainException;", "serializeService", "Lorg/enodeframework/common/serializing/ISerializeService;", "(Lorg/enodeframework/eventing/IEventStore;Lorg/enodeframework/commanding/ICommandHandlerProvider;Lorg/enodeframework/infrastructure/ITypeNameProvider;Lorg/enodeframework/eventing/IEventCommittingService;Lorg/enodeframework/domain/IMemoryCache;Lorg/enodeframework/messaging/IMessagePublisher;Lorg/enodeframework/messaging/IMessagePublisher;Lorg/enodeframework/common/serializing/ISerializeService;)V", "commitAggregateChanges", "Ljava/util/concurrent/CompletableFuture;", "", "processingCommand", "Lorg/enodeframework/commanding/ProcessingCommand;", "commitChangesAsync", "success", "message", "errorMessage", "", "completeCommand", "commandStatus", "Lorg/enodeframework/commanding/CommandStatus;", "resultType", "result", "getCommandHandler", "Lorg/enodeframework/commanding/impl/HandlerFindResult;", "getHandlersFunc", "Ljava/util/function/Function;", "Ljava/lang/Class;", "", "Lorg/enodeframework/messaging/MessageHandlerData;", "Lorg/enodeframework/commanding/ICommandHandlerProxy;", "getRealException", "", "exception", "handleAsync", "handleCommandInternal", "commandHandler", "retryTimes", "", "handleExceptionAsync", "publishExceptionAsync", "publishMessageAsync", "republishCommandEvents", "Companion", "enode"})
public final class DefaultProcessingCommandHandler
implements IProcessingCommandHandler {
    private final IEventStore eventStore;
    private final ICommandHandlerProvider commandHandlerProvider;
    private final ITypeNameProvider typeNameProvider;
    private final IEventCommittingService eventCommittingService;
    private final IMemoryCache memoryCache;
    private final IMessagePublisher<IApplicationMessage> applicationMessagePublisher;
    private final IMessagePublisher<IDomainException> exceptionPublisher;
    private final ISerializeService serializeService;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    @Override
    @NotNull
    public CompletableFuture<Boolean> handleAsync(@NotNull ProcessingCommand processingCommand) {
        Intrinsics.checkNotNullParameter((Object)processingCommand, (String)"processingCommand");
        ICommand command = processingCommand.getMessage();
        if (Strings.isNullOrEmpty((String)command.getAggregateRootId())) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "The aggregateRootId of command cannot be null or empty. commandType:%s, commandId:%s";
            Object[] objectArray = new Object[]{command.getClass().getName(), command.getId()};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String errorMessage = string2;
            logger.error(errorMessage);
            String string3 = String.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
            return this.completeCommand(processingCommand, CommandStatus.Failed, string3, errorMessage);
        }
        HandlerFindResult findResult2 = this.getCommandHandler(processingCommand, new Function<Class<?>, List<? extends MessageHandlerData<ICommandHandlerProxy>>>(this){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;

            @NotNull
            public final List<MessageHandlerData<ICommandHandlerProxy>> apply(@NotNull Class<?> commandType) {
                Intrinsics.checkNotNullParameter(commandType, (String)"commandType");
                return DefaultProcessingCommandHandler.access$getCommandHandlerProvider$p(this.this$0).getHandlers(commandType);
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
            }
        });
        switch (DefaultProcessingCommandHandler$WhenMappings.$EnumSwitchMapping$0[findResult2.getFindStatus().ordinal()]) {
            case 1: {
                ICommandHandlerProxy iCommandHandlerProxy = findResult2.getFindHandler();
                if (iCommandHandlerProxy == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.enodeframework.commanding.ICommandHandlerProxy");
                }
                return this.handleCommandInternal(processingCommand, iCommandHandlerProxy, 0);
            }
            case 2: {
                logger.error("Found more than one command handler data, commandType:{}, commandId:{}", (Object)command.getClass().getName(), (Object)command.getId());
                String string = String.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
                return this.completeCommand(processingCommand, CommandStatus.Failed, string, "More than one command handler data found.");
            }
            case 3: {
                logger.error("Found more than one command handler, commandType:{}, commandId:{}", (Object)command.getClass().getName(), (Object)command.getId());
                String string = String.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
                return this.completeCommand(processingCommand, CommandStatus.Failed, string, "More than one command handler found.");
            }
            case 4: {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "No command handler found of command. commandType:%s, commandId:%s";
                Object[] objectArray = new Object[]{command.getClass().getName(), command.getId()};
                boolean bl = false;
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                String errorMessage = string4;
                logger.error(errorMessage);
                String string5 = String.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"String::class.java.name");
                return this.completeCommand(processingCommand, CommandStatus.Failed, string5, errorMessage);
            }
        }
        return Task.completedTask;
    }

    private final CompletableFuture<Boolean> handleCommandInternal(ProcessingCommand processingCommand, ICommandHandlerProxy commandHandler, int retryTimes) {
        ICommand command = processingCommand.getMessage();
        ICommandExecuteContext commandContext = processingCommand.getCommandExecuteContext();
        if (processingCommand.isDuplicated()) {
            return this.republishCommandEvents(processingCommand, 0);
        }
        CompletableFuture<Boolean> taskSource = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("HandleCommandAsync", (Func)new Func<CompletableFuture<Unit>>(commandContext, commandHandler, command){
            final /* synthetic */ ICommandExecuteContext $commandContext;
            final /* synthetic */ ICommandHandlerProxy $commandHandler;
            final /* synthetic */ ICommand $command;

            public final CompletableFuture<Unit> apply() {
                this.$commandContext.clear();
                return FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    final /* synthetic */ handleCommandInternal.1 this$0;

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.this$0.$commandHandler.handleAsync(this.this$0.$commandContext, this.this$0.$command, (Continuation<? super Unit>)this);
                                if (object3 != object2) return Unit.INSTANCE;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                    {
                        this.this$0 = var1_1;
                        super(2, continuation);
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                        Intrinsics.checkNotNullParameter(completion, (String)"completion");
                        Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                        return function2;
                    }

                    public final Object invoke(Object object, Object object2) {
                        return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null));
            }
            {
                this.$commandContext = iCommandExecuteContext;
                this.$commandHandler = iCommandHandlerProxy;
                this.$command = iCommand;
            }
        }, (Action1)new Action1<Unit>(this, commandHandler, command, commandContext, processingCommand, taskSource){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ ICommandHandlerProxy $commandHandler;
            final /* synthetic */ ICommand $command;
            final /* synthetic */ ICommandExecuteContext $commandContext;
            final /* synthetic */ ProcessingCommand $processingCommand;
            final /* synthetic */ CompletableFuture $taskSource;

            public final void apply(Unit it) {
                Logger logger = DefaultProcessingCommandHandler.access$getLogger$cp();
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                if (logger.isDebugEnabled()) {
                    DefaultProcessingCommandHandler.access$getLogger$cp().debug("Handle command success. handlerType:{}, commandType:{}, commandId:{}, aggregateRootId:{}", new Object[]{this.$commandHandler.getInnerObject().getClass().getName(), this.$command.getClass().getName(), this.$command.getId(), this.$command.getAggregateRootId()});
                }
                if (this.$commandContext.getApplicationMessage() != null) {
                    DefaultProcessingCommandHandler.access$commitChangesAsync(this.this$0, this.$processingCommand, true, this.$commandContext.getApplicationMessage(), "").whenComplete(new BiConsumer<Boolean, Throwable>(this){
                        final /* synthetic */ handleCommandInternal.2 this$0;

                        public final void accept(Boolean $noName_0, Throwable $noName_1) {
                            this.this$0.$taskSource.complete(true);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    try {
                        ((CompletableFuture)DefaultProcessingCommandHandler.access$commitAggregateChanges(this.this$0, this.$processingCommand).whenComplete(new BiConsumer<Boolean, Throwable>(this){
                            final /* synthetic */ handleCommandInternal.2 this$0;

                            public final void accept(Boolean $noName_0, Throwable $noName_1) {
                                this.this$0.$taskSource.complete(true);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        })).exceptionally(new Function<Throwable, Boolean>(this){
                            final /* synthetic */ handleCommandInternal.2 this$0;

                            public final Boolean apply(@NotNull Throwable ex) {
                                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                                DefaultProcessingCommandHandler.access$getLogger$cp().error("Commit aggregate changes has unknown exception, this should not be happen, and we just complete the command, handlerType:{}, commandType:{}, commandId:{}, aggregateRootId:{}", new Object[]{this.this$0.$commandHandler.getInnerObject().getClass().getName(), this.this$0.$command.getClass().getName(), this.this$0.$command.getId(), this.this$0.$command.getAggregateRootId(), ex});
                                DefaultProcessingCommandHandler defaultProcessingCommandHandler = this.this$0.this$0;
                                ProcessingCommand processingCommand = this.this$0.$processingCommand;
                                String string = ex.getClass().getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ex.javaClass.name");
                                DefaultProcessingCommandHandler.access$completeCommand(defaultProcessingCommandHandler, processingCommand, CommandStatus.Failed, string, "Unknown exception caught when committing changes of command.").whenComplete(new BiConsumer<Boolean, Throwable>(this){
                                    final /* synthetic */ handleCommandInternal.3 this$0;

                                    public final void accept(Boolean $noName_0, Throwable $noName_1) {
                                        this.this$0.this$0.$taskSource.complete(true);
                                    }
                                    {
                                        this.this$0 = var1_1;
                                    }
                                });
                                return null;
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    catch (AggregateRootReferenceChangedException aggregateRootReferenceChangedException) {
                        Logger logger2 = DefaultProcessingCommandHandler.access$getLogger$cp();
                        Object[] objectArray = new Object[5];
                        IAggregateRoot iAggregateRoot = aggregateRootReferenceChangedException.getAggregateRoot();
                        Intrinsics.checkNotNullExpressionValue((Object)iAggregateRoot, (String)"aggregateRootReferenceCh\u2026edException.aggregateRoot");
                        objectArray[0] = iAggregateRoot.getUniqueId();
                        objectArray[1] = aggregateRootReferenceChangedException.getAggregateRoot().getClass().getName();
                        objectArray[2] = this.$command.getId();
                        objectArray[3] = this.$command.getClass().getName();
                        objectArray[4] = this.$commandHandler.getInnerObject().getClass().getName();
                        logger2.info("Aggregate root reference changed when processing command, try to re-handle the command. aggregateRootId: {}, aggregateRootType: {}, commandId: {}, commandType: {}, handlerType: {}", objectArray);
                        DefaultProcessingCommandHandler.access$handleCommandInternal(this.this$0, this.$processingCommand, this.$commandHandler, 0).whenComplete(new BiConsumer<Boolean, Throwable>(this){
                            final /* synthetic */ handleCommandInternal.2 this$0;

                            public final void accept(Boolean $noName_0, Throwable $noName_1) {
                                this.this$0.$taskSource.complete(true);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    catch (Exception e) {
                        DefaultProcessingCommandHandler.access$getLogger$cp().error("Commit aggregate changes has unknown exception, this should not be happen, and we just complete the command, handlerType:{}, commandType:{}, commandId:{}, aggregateRootId:{}", new Object[]{this.$commandHandler.getInnerObject().getClass().getName(), this.$command.getClass().getName(), this.$command.getId(), this.$command.getAggregateRootId(), e});
                        String string = e.getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.javaClass.name");
                        DefaultProcessingCommandHandler.access$completeCommand(this.this$0, this.$processingCommand, CommandStatus.Failed, string, "Unknown exception caught when committing changes of command.").whenComplete(new BiConsumer<Boolean, Throwable>(this){
                            final /* synthetic */ handleCommandInternal.2 this$0;

                            public final void accept(Boolean $noName_0, Throwable $noName_1) {
                                this.this$0.$taskSource.complete(true);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$commandHandler = iCommandHandlerProxy;
                this.$command = iCommand;
                this.$commandContext = iCommandExecuteContext;
                this.$processingCommand = processingCommand;
                this.$taskSource = completableFuture;
            }
        }, new Func<String>(command, commandHandler){
            final /* synthetic */ ICommand $command;
            final /* synthetic */ ICommandHandlerProxy $commandHandler;

            @Nullable
            public final String apply() {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "[command:[id:%s,type:%s],handlerType:%s,aggregateRootId:%s]";
                Object[] objectArray = new Object[]{this.$command.getId(), this.$command.getClass().getName(), this.$commandHandler.getInnerObject().getClass().getName(), this.$command.getAggregateRootId()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                return string2;
            }
            {
                this.$command = iCommand;
                this.$commandHandler = iCommandHandlerProxy;
            }
        }, new Action2<Throwable, String>(this, processingCommand, commandHandler, taskSource){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ ProcessingCommand $processingCommand;
            final /* synthetic */ ICommandHandlerProxy $commandHandler;
            final /* synthetic */ CompletableFuture $taskSource;

            public final void apply(@NotNull Throwable ex, @NotNull String errorMessage) {
                Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                DefaultProcessingCommandHandler.access$handleExceptionAsync(this.this$0, this.$processingCommand, this.$commandHandler, ex, errorMessage, 0).whenComplete(new BiConsumer<Boolean, Throwable>(this){
                    final /* synthetic */ handleCommandInternal.4 this$0;

                    public final void accept(Boolean $noName_0, Throwable $noName_1) {
                        this.this$0.$taskSource.complete(true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$processingCommand = processingCommand;
                this.$commandHandler = iCommandHandlerProxy;
                this.$taskSource = completableFuture;
            }
        }, retryTimes, false);
        return taskSource;
    }

    private final CompletableFuture<Boolean> commitAggregateChanges(ProcessingCommand processingCommand) {
        ICommand command = processingCommand.getMessage();
        ICommandExecuteContext context = processingCommand.getCommandExecuteContext();
        List<IAggregateRoot> trackedAggregateRoots = context.getTrackedAggregateRoots();
        int dirtyAggregateRootCount = 0;
        IAggregateRoot dirtyAggregateRoot = null;
        List<IDomainEvent<?>> changedEvents = new ArrayList();
        for (IAggregateRoot aggregateRoot : trackedAggregateRoots) {
            List<IDomainEvent<?>> events = aggregateRoot.getChanges();
            if (events.size() <= 0) continue;
            if (++dirtyAggregateRootCount > 1) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "Detected more than one aggregate created or modified by command. commandType:%s, commandId:%s";
                Object[] objectArray = new Object[]{command.getClass().getName(), command.getId()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                String errorMessage = string2;
                logger.error(errorMessage);
                String string3 = String.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
                return this.completeCommand(processingCommand, CommandStatus.Failed, string3, errorMessage);
            }
            dirtyAggregateRoot = aggregateRoot;
            Intrinsics.checkNotNullExpressionValue(events, (String)"events");
        }
        if (dirtyAggregateRootCount == 0 || changedEvents.isEmpty()) {
            return this.republishCommandEvents(processingCommand, 0);
        }
        Intrinsics.checkNotNull((Object)dirtyAggregateRoot);
        DomainEventStream eventStream = new DomainEventStream(processingCommand.getMessage().getId(), dirtyAggregateRoot.getUniqueId(), this.typeNameProvider.getTypeName(dirtyAggregateRoot.getClass()), new Date(), changedEvents, command.getItems());
        this.memoryCache.acceptAggregateRootChanges(dirtyAggregateRoot);
        String commandResult = processingCommand.getCommandExecuteContext().getResult();
        processingCommand.getItems().put("COMMAND_RESULT", commandResult);
        this.eventCommittingService.commitDomainEventAsync(new EventCommittingContext(eventStream, processingCommand));
        return Task.completedTask;
    }

    private final CompletableFuture<Boolean> republishCommandEvents(ProcessingCommand processingCommand, int retryTimes) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        ICommand command = processingCommand.getMessage();
        IOHelper.tryAsyncActionRecursively("ProcessIfNoEventsOfCommand", (Func)new Func<CompletableFuture<DomainEventStream>>(this, command){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ ICommand $command;

            public final CompletableFuture<DomainEventStream> apply() {
                IEventStore iEventStore = DefaultProcessingCommandHandler.access$getEventStore$p(this.this$0);
                String string = this.$command.getAggregateRootId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command.aggregateRootId");
                String string2 = this.$command.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"command.id");
                return iEventStore.findAsync(string, string2);
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$command = iCommand;
            }
        }, (Action1)new Action1<DomainEventStream>(this, processingCommand, future){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ ProcessingCommand $processingCommand;
            final /* synthetic */ CompletableFuture $future;

            public final void apply(@Nullable DomainEventStream result) {
                if (result != null) {
                    DefaultProcessingCommandHandler.access$getEventCommittingService$p(this.this$0).publishDomainEventAsync(this.$processingCommand, result).whenComplete((BiConsumer)new BiConsumer<Boolean, Throwable>(this){
                        final /* synthetic */ republishCommandEvents.2 this$0;

                        public final void accept(Boolean $noName_0, Throwable $noName_1) {
                            this.this$0.$future.complete(true);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    String string = String.class.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
                    DefaultProcessingCommandHandler.access$completeCommand(this.this$0, this.$processingCommand, CommandStatus.NothingChanged, string, this.$processingCommand.getCommandExecuteContext().getResult()).whenComplete(new BiConsumer<Boolean, Throwable>(this){
                        final /* synthetic */ republishCommandEvents.2 this$0;

                        public final void accept(Boolean $noName_0, Throwable $noName_1) {
                            this.this$0.$future.complete(true);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$processingCommand = processingCommand;
                this.$future = completableFuture;
            }
        }, new Func<String>(command){
            final /* synthetic */ ICommand $command;

            @Nullable
            public final String apply() {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "[commandId:%s]";
                Object[] objectArray = new Object[]{this.$command.getId()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                return string2;
            }
            {
                this.$command = iCommand;
            }
        }, null, retryTimes, true);
        return future;
    }

    private final CompletableFuture<Boolean> handleExceptionAsync(ProcessingCommand processingCommand, ICommandHandlerProxy commandHandler, Throwable exception, String errorMessage, int retryTimes) {
        ICommand command = processingCommand.getMessage();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursively("FindEventByCommandIdAsync", (Func)new Func<CompletableFuture<DomainEventStream>>(this, command){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ ICommand $command;

            public final CompletableFuture<DomainEventStream> apply() {
                IEventStore iEventStore = DefaultProcessingCommandHandler.access$getEventStore$p(this.this$0);
                String string = this.$command.getAggregateRootId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command.aggregateRootId");
                String string2 = this.$command.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"command.id");
                return iEventStore.findAsync(string, string2);
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$command = iCommand;
            }
        }, (Action1)new Action1<DomainEventStream>(this, processingCommand, future, exception){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ ProcessingCommand $processingCommand;
            final /* synthetic */ CompletableFuture $future;
            final /* synthetic */ Throwable $exception;

            public final void apply(@Nullable DomainEventStream result) {
                if (result != null) {
                    DefaultProcessingCommandHandler.access$getEventCommittingService$p(this.this$0).publishDomainEventAsync(this.$processingCommand, result).whenComplete((BiConsumer)new BiConsumer<Boolean, Throwable>(this){
                        final /* synthetic */ handleExceptionAsync.2 this$0;

                        public final void accept(Boolean $noName_0, Throwable $noName_1) {
                            this.this$0.$future.complete(true);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                } else {
                    Throwable realException = DefaultProcessingCommandHandler.access$getRealException(this.this$0, this.$exception);
                    if (realException instanceof IDomainException) {
                        DefaultProcessingCommandHandler.access$publishExceptionAsync(this.this$0, this.$processingCommand, (IDomainException)((Object)realException), 0).whenComplete(new BiConsumer<Boolean, Throwable>(this){
                            final /* synthetic */ handleExceptionAsync.2 this$0;

                            public final void accept(Boolean $noName_0, Throwable $noName_1) {
                                this.this$0.$future.complete(true);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    } else {
                        String string = realException.getClass().getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"realException.javaClass.name");
                        DefaultProcessingCommandHandler.access$completeCommand(this.this$0, this.$processingCommand, CommandStatus.Failed, string, realException.getMessage()).whenComplete(new BiConsumer<Boolean, Throwable>(this){
                            final /* synthetic */ handleExceptionAsync.2 this$0;

                            public final void accept(Boolean $noName_0, Throwable $noName_1) {
                                this.this$0.$future.complete(true);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                }
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$processingCommand = processingCommand;
                this.$future = completableFuture;
                this.$exception = throwable;
            }
        }, new Func<String>(command, commandHandler){
            final /* synthetic */ ICommand $command;
            final /* synthetic */ ICommandHandlerProxy $commandHandler;

            @Nullable
            public final String apply() {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "[command:[id:%s,type:%s],handlerType:%s,aggregateRootId:%s]";
                Object[] objectArray = new Object[]{this.$command.getId(), this.$command.getClass().getName(), this.$commandHandler.getInnerObject().getClass().getName(), this.$command.getAggregateRootId()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                return string2;
            }
            {
                this.$command = iCommand;
                this.$commandHandler = iCommandHandlerProxy;
            }
        }, null, retryTimes, true);
        return future;
    }

    private final Throwable getRealException(Throwable exception) {
        if (exception instanceof CompletionException) {
            if (exception.getCause() instanceof IDomainException) {
                Throwable throwable = exception.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                return throwable;
            }
            Throwable throwable = Arrays.stream(((CompletionException)exception).getSuppressed()).filter(getRealException.1.INSTANCE).findFirst().orElse(exception);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"Arrays.stream(exception.\u2026       .orElse(exception)");
            return throwable;
        }
        return exception;
    }

    private final CompletableFuture<Boolean> publishExceptionAsync(ProcessingCommand processingCommand, IDomainException exception, int retryTimes) {
        exception.mergeItems(processingCommand.getMessage().getItems());
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("PublishExceptionAsync", (Func)new Func<CompletableFuture<Boolean>>(this, exception){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ IDomainException $exception;

            public final CompletableFuture<Boolean> apply() {
                return DefaultProcessingCommandHandler.access$getExceptionPublisher$p(this.this$0).publishAsync((IMessage)this.$exception);
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$exception = iDomainException;
            }
        }, (Action1)new Action1<Boolean>(this, processingCommand, exception, future){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ ProcessingCommand $processingCommand;
            final /* synthetic */ IDomainException $exception;
            final /* synthetic */ CompletableFuture $future;

            public final void apply(Boolean it) {
                String string = this.$exception.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exception.javaClass.name");
                IDomainException iDomainException = this.$exception;
                if (iDomainException == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                }
                DefaultProcessingCommandHandler.access$completeCommand(this.this$0, this.$processingCommand, CommandStatus.Failed, string, ((Exception)((Object)iDomainException)).getMessage()).whenComplete(new BiConsumer<Boolean, Throwable>(this){
                    final /* synthetic */ publishExceptionAsync.2 this$0;

                    public final void accept(Boolean $noName_0, Throwable $noName_1) {
                        this.this$0.$future.complete(true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$processingCommand = processingCommand;
                this.$exception = iDomainException;
                this.$future = completableFuture;
            }
        }, new Func<String>(exception, processingCommand){
            final /* synthetic */ IDomainException $exception;
            final /* synthetic */ ProcessingCommand $processingCommand;

            @Nullable
            public final String apply() {
                Map serializableInfo = new HashMap<K, V>();
                this.$exception.serializeTo(serializableInfo);
                String exceptionInfo2 = CollectionsKt.joinToString$default((Iterable)serializableInfo.entrySet(), (CharSequence)",", null, null, (int)0, null, (Function1)publishExceptionAsync.exceptionInfo.1.INSTANCE, (int)30, null);
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "[commandId: %s, exceptionInfo: %s]";
                Object[] objectArray = new Object[]{this.$processingCommand.getMessage().getId(), exceptionInfo2};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                return string2;
            }
            {
                this.$exception = iDomainException;
                this.$processingCommand = processingCommand;
            }
        }, null, retryTimes, true);
        return future;
    }

    private final CompletableFuture<Boolean> commitChangesAsync(ProcessingCommand processingCommand, boolean success, IApplicationMessage message, String errorMessage) {
        if (success) {
            if (message != null) {
                message.mergeItems(processingCommand.getMessage().getItems());
                return this.publishMessageAsync(processingCommand, message, 0);
            }
            return this.completeCommand(processingCommand, CommandStatus.Success, "", "");
        }
        String string = String.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
        return this.completeCommand(processingCommand, CommandStatus.Failed, string, errorMessage);
    }

    private final CompletableFuture<Boolean> publishMessageAsync(ProcessingCommand processingCommand, IApplicationMessage message, int retryTimes) {
        ICommand command = processingCommand.getMessage();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("PublishApplicationMessageAsync", (Func)new Func<CompletableFuture<Boolean>>(this, message){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ IApplicationMessage $message;

            public final CompletableFuture<Boolean> apply() {
                return DefaultProcessingCommandHandler.access$getApplicationMessagePublisher$p(this.this$0).publishAsync((IMessage)this.$message);
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$message = iApplicationMessage;
            }
        }, (Action1)new Action1<Boolean>(this, processingCommand, message, future){
            final /* synthetic */ DefaultProcessingCommandHandler this$0;
            final /* synthetic */ ProcessingCommand $processingCommand;
            final /* synthetic */ IApplicationMessage $message;
            final /* synthetic */ CompletableFuture $future;

            public final void apply(Boolean it) {
                String string = this.$message.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.javaClass.name");
                DefaultProcessingCommandHandler.access$completeCommand(this.this$0, this.$processingCommand, CommandStatus.Success, string, DefaultProcessingCommandHandler.access$getSerializeService$p(this.this$0).serialize(this.$message)).whenComplete(new BiConsumer<Boolean, Throwable>(this){
                    final /* synthetic */ publishMessageAsync.2 this$0;

                    public final void accept(Boolean $noName_0, Throwable $noName_1) {
                        this.this$0.$future.complete(true);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = defaultProcessingCommandHandler;
                this.$processingCommand = processingCommand;
                this.$message = iApplicationMessage;
                this.$future = completableFuture;
            }
        }, new Func<String>(message, command){
            final /* synthetic */ IApplicationMessage $message;
            final /* synthetic */ ICommand $command;

            @Nullable
            public final String apply() {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string = "[application message:[id:%s,type:%s],command:[id:%s,type:%s]]";
                Object[] objectArray = new Object[]{this.$message.getId(), this.$message.getClass().getName(), this.$command.getId(), this.$command.getClass().getName()};
                boolean bl = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                return string2;
            }
            {
                this.$message = iApplicationMessage;
                this.$command = iCommand;
            }
        }, null, retryTimes, true);
        return future;
    }

    private final HandlerFindResult getCommandHandler(ProcessingCommand processingCommand, Function<Class<?>, List<MessageHandlerData<ICommandHandlerProxy>>> getHandlersFunc) {
        ICommand command = processingCommand.getMessage();
        List<MessageHandlerData<ICommandHandlerProxy>> list = getHandlersFunc.apply(command.getClass());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHandlersFunc.apply(command.javaClass)");
        List<MessageHandlerData<ICommandHandlerProxy>> handlerDataList = list;
        if (handlerDataList.isEmpty()) {
            return HandlerFindResult.Companion.getNotFound();
        }
        if (handlerDataList.size() > 1) {
            return HandlerFindResult.Companion.getTooManyHandlerData();
        }
        MessageHandlerData handlerData = handlerDataList.stream().findFirst().orElse(new MessageHandlerData());
        if (handlerData.getListHandlers().isEmpty()) {
            return HandlerFindResult.Companion.getNotFound();
        }
        if (handlerData.getListHandlers().size() > 1) {
            return HandlerFindResult.Companion.getTooManyHandler();
        }
        return new HandlerFindResult(HandlerFindStatus.Found, (ICommandHandlerProxy)handlerData.getListHandlers().get(0));
    }

    private final CompletableFuture<Boolean> completeCommand(ProcessingCommand processingCommand, CommandStatus commandStatus, String resultType, String result) {
        String string = processingCommand.getMessage().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processingCommand.message.id");
        String string2 = processingCommand.getMessage().getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"processingCommand.message.aggregateRootId");
        CommandResult commandResult = new CommandResult(commandStatus, string, string2, result, resultType);
        return processingCommand.getMailBox().completeMessage(processingCommand, commandResult);
    }

    public DefaultProcessingCommandHandler(@NotNull IEventStore eventStore, @NotNull ICommandHandlerProvider commandHandlerProvider, @NotNull ITypeNameProvider typeNameProvider, @NotNull IEventCommittingService eventCommittingService, @NotNull IMemoryCache memoryCache, @NotNull IMessagePublisher<IApplicationMessage> applicationMessagePublisher, @NotNull IMessagePublisher<IDomainException> exceptionPublisher, @NotNull ISerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)commandHandlerProvider, (String)"commandHandlerProvider");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        Intrinsics.checkNotNullParameter((Object)eventCommittingService, (String)"eventCommittingService");
        Intrinsics.checkNotNullParameter((Object)memoryCache, (String)"memoryCache");
        Intrinsics.checkNotNullParameter(applicationMessagePublisher, (String)"applicationMessagePublisher");
        Intrinsics.checkNotNullParameter(exceptionPublisher, (String)"exceptionPublisher");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.eventStore = eventStore;
        this.commandHandlerProvider = commandHandlerProvider;
        this.typeNameProvider = typeNameProvider;
        this.eventCommittingService = eventCommittingService;
        this.memoryCache = memoryCache;
        this.applicationMessagePublisher = applicationMessagePublisher;
        this.exceptionPublisher = exceptionPublisher;
        this.serializeService = serializeService;
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DefaultProcessingCommandHandler.class);
    }

    public static final /* synthetic */ ICommandHandlerProvider access$getCommandHandlerProvider$p(DefaultProcessingCommandHandler $this) {
        return $this.commandHandlerProvider;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ CompletableFuture access$commitChangesAsync(DefaultProcessingCommandHandler $this, ProcessingCommand processingCommand, boolean success, IApplicationMessage message, String errorMessage) {
        return $this.commitChangesAsync(processingCommand, success, message, errorMessage);
    }

    public static final /* synthetic */ CompletableFuture access$commitAggregateChanges(DefaultProcessingCommandHandler $this, ProcessingCommand processingCommand) {
        return $this.commitAggregateChanges(processingCommand);
    }

    public static final /* synthetic */ CompletableFuture access$completeCommand(DefaultProcessingCommandHandler $this, ProcessingCommand processingCommand, CommandStatus commandStatus, String resultType, String result) {
        return $this.completeCommand(processingCommand, commandStatus, resultType, result);
    }

    public static final /* synthetic */ CompletableFuture access$handleCommandInternal(DefaultProcessingCommandHandler $this, ProcessingCommand processingCommand, ICommandHandlerProxy commandHandler, int retryTimes) {
        return $this.handleCommandInternal(processingCommand, commandHandler, retryTimes);
    }

    public static final /* synthetic */ CompletableFuture access$handleExceptionAsync(DefaultProcessingCommandHandler $this, ProcessingCommand processingCommand, ICommandHandlerProxy commandHandler, Throwable exception, String errorMessage, int retryTimes) {
        return $this.handleExceptionAsync(processingCommand, commandHandler, exception, errorMessage, retryTimes);
    }

    public static final /* synthetic */ IEventStore access$getEventStore$p(DefaultProcessingCommandHandler $this) {
        return $this.eventStore;
    }

    public static final /* synthetic */ IEventCommittingService access$getEventCommittingService$p(DefaultProcessingCommandHandler $this) {
        return $this.eventCommittingService;
    }

    public static final /* synthetic */ Throwable access$getRealException(DefaultProcessingCommandHandler $this, Throwable exception) {
        return $this.getRealException(exception);
    }

    public static final /* synthetic */ CompletableFuture access$publishExceptionAsync(DefaultProcessingCommandHandler $this, ProcessingCommand processingCommand, IDomainException exception, int retryTimes) {
        return $this.publishExceptionAsync(processingCommand, exception, retryTimes);
    }

    public static final /* synthetic */ IMessagePublisher access$getExceptionPublisher$p(DefaultProcessingCommandHandler $this) {
        return $this.exceptionPublisher;
    }

    public static final /* synthetic */ IMessagePublisher access$getApplicationMessagePublisher$p(DefaultProcessingCommandHandler $this) {
        return $this.applicationMessagePublisher;
    }

    public static final /* synthetic */ ISerializeService access$getSerializeService$p(DefaultProcessingCommandHandler $this) {
        return $this.serializeService;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/commanding/impl/DefaultProcessingCommandHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

