/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.io;

import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.enodeframework.common.exception.IORuntimeException;
import org.enodeframework.common.function.Action;
import org.enodeframework.common.function.Action1;
import org.enodeframework.common.function.Action2;
import org.enodeframework.common.function.DelayedTask;
import org.enodeframework.common.function.Func;
import org.enodeframework.common.utilities.Ensure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jn\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J~\u0010\u0006\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u0015H\u0007Jn\u0010\u001a\u001a\u00020\u0007\"\u0004\b\u0000\u0010\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\b0\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\b0\u000f2\u000e\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\f2\u0014\u0010\u0011\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\n\u0018\u00010\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J0\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001c0\r\"\u0004\b\u0000\u0010\u001c2\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001c0\r0\f2\u0006\u0010\u001e\u001a\u00020\nH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/enodeframework/common/io/IOHelper;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "tryAsyncActionRecursively", "", "TAsyncResult", "asyncActionName", "", "asyncAction", "Lorg/enodeframework/common/function/Func;", "Ljava/util/concurrent/CompletableFuture;", "successAction", "Lorg/enodeframework/common/function/Action1;", "getContextInfoFunc", "failedAction", "Lorg/enodeframework/common/function/Action2;", "", "retryTimes", "", "retryWhenFailed", "", "maxRetryTimes", "retryInterval", "tryAsyncActionRecursivelyWithoutResult", "tryIOFuncAsync", "T", "func", "funcName", "AsyncTaskExecutionContext", "enode"})
public final class IOHelper {
    private static final Logger logger;
    @NotNull
    public static final IOHelper INSTANCE;

    @JvmStatic
    public static final <TAsyncResult> void tryAsyncActionRecursively(@NotNull String asyncActionName, @NotNull Func<CompletableFuture<TAsyncResult>> asyncAction, @NotNull Action1<TAsyncResult> successAction, @NotNull Func<String> getContextInfoFunc, @Nullable Action2<Throwable, String> failedAction, int retryTimes, boolean retryWhenFailed) {
        Intrinsics.checkNotNullParameter((Object)asyncActionName, (String)"asyncActionName");
        Intrinsics.checkNotNullParameter(asyncAction, (String)"asyncAction");
        Intrinsics.checkNotNullParameter(successAction, (String)"successAction");
        Intrinsics.checkNotNullParameter(getContextInfoFunc, (String)"getContextInfoFunc");
        IOHelper.tryAsyncActionRecursively(asyncActionName, asyncAction, successAction, getContextInfoFunc, failedAction, retryTimes, retryWhenFailed, 3, 1000);
    }

    @JvmStatic
    public static final <TAsyncResult> void tryAsyncActionRecursively(@NotNull String asyncActionName, @NotNull Func<CompletableFuture<TAsyncResult>> asyncAction, @NotNull Action1<TAsyncResult> successAction, @NotNull Func<String> getContextInfoFunc, @Nullable Action2<Throwable, String> failedAction, int retryTimes, boolean retryWhenFailed, int maxRetryTimes, int retryInterval) {
        Intrinsics.checkNotNullParameter((Object)asyncActionName, (String)"asyncActionName");
        Intrinsics.checkNotNullParameter(asyncAction, (String)"asyncAction");
        Intrinsics.checkNotNullParameter(successAction, (String)"successAction");
        Intrinsics.checkNotNullParameter(getContextInfoFunc, (String)"getContextInfoFunc");
        AsyncTaskExecutionContext<TAsyncResult> asyncTaskExecutionContext = new AsyncTaskExecutionContext<TAsyncResult>(asyncActionName, asyncAction, successAction, getContextInfoFunc, failedAction, retryTimes, retryWhenFailed, maxRetryTimes, retryInterval);
        asyncTaskExecutionContext.execute();
    }

    @JvmStatic
    public static final <TAsyncResult> void tryAsyncActionRecursivelyWithoutResult(@NotNull String asyncActionName, @NotNull Func<CompletableFuture<TAsyncResult>> asyncAction, @NotNull Action1<TAsyncResult> successAction, @NotNull Func<String> getContextInfoFunc, @Nullable Action2<Throwable, String> failedAction, int retryTimes, boolean retryWhenFailed) {
        Intrinsics.checkNotNullParameter((Object)asyncActionName, (String)"asyncActionName");
        Intrinsics.checkNotNullParameter(asyncAction, (String)"asyncAction");
        Intrinsics.checkNotNullParameter(successAction, (String)"successAction");
        Intrinsics.checkNotNullParameter(getContextInfoFunc, (String)"getContextInfoFunc");
        AsyncTaskExecutionContext<TAsyncResult> asyncTaskExecutionContext = new AsyncTaskExecutionContext<TAsyncResult>(asyncActionName, asyncAction, successAction, getContextInfoFunc, failedAction, retryTimes, retryWhenFailed, 3, 1000);
        asyncTaskExecutionContext.execute();
    }

    @JvmStatic
    @NotNull
    public static final <T> CompletableFuture<T> tryIOFuncAsync(@NotNull Func<CompletableFuture<T>> func, @NotNull String funcName) {
        CompletableFuture<T> completableFuture;
        Intrinsics.checkNotNullParameter(func, (String)"func");
        Intrinsics.checkNotNullParameter((Object)funcName, (String)"funcName");
        Ensure.notNull(func, "func");
        Ensure.notNull(funcName, "funcName");
        try {
            CompletableFuture<T> completableFuture2 = func.apply();
            Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"func.apply()");
            completableFuture = completableFuture2;
        }
        catch (Exception ex) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "%s failed.";
            Object[] objectArray = new Object[]{funcName};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new IORuntimeException(string2, ex);
        }
        return completableFuture;
    }

    private IOHelper() {
    }

    static {
        IOHelper iOHelper;
        INSTANCE = iOHelper = new IOHelper();
        logger = LoggerFactory.getLogger(IOHelper.class);
    }

    public static final /* synthetic */ Logger access$getLogger$p(IOHelper $this) {
        IOHelper iOHelper = $this;
        return logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\r\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002Bu\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0012\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\u000e\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0004\u0018\u00010\f\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u000f\u0012\u0006\u0010\u0013\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\u0006\u0010\u0018\u001a\u00020\u0017J\u001a\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\r2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0002J\b\u0010\u001c\u001a\u00020\u0017H\u0002J\u0015\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u001fJ\u001a\u0010 \u001a\u0004\u0018\u00010\u00042\u000e\u0010!\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/enodeframework/common/io/IOHelper$AsyncTaskExecutionContext;", "TAsyncResult", "", "actionName", "", "asyncAction", "Lorg/enodeframework/common/function/Func;", "Ljava/util/concurrent/CompletableFuture;", "successAction", "Lorg/enodeframework/common/function/Action1;", "contextInfoFunc", "failedAction", "Lorg/enodeframework/common/function/Action2;", "", "retryTimes", "", "retryWhenFailed", "", "maxRetryTimes", "retryInterval", "(Ljava/lang/String;Lorg/enodeframework/common/function/Func;Lorg/enodeframework/common/function/Action1;Lorg/enodeframework/common/function/Func;Lorg/enodeframework/common/function/Action2;IZII)V", "currentRetryTimes", "doRetry", "", "execute", "executeFailedAction", "e", "errorMessage", "executeRetryAction", "executeSuccessAction", "result", "(Ljava/lang/Object;)V", "getContextInfo", "func", "processTaskException", "exception", "enode"})
    public static final class AsyncTaskExecutionContext<TAsyncResult> {
        private final Func<CompletableFuture<TAsyncResult>> asyncAction;
        private final Action1<TAsyncResult> successAction;
        private final Func<String> contextInfoFunc;
        private final Action2<Throwable, String> failedAction;
        private int currentRetryTimes;
        private final boolean retryWhenFailed;
        private final int maxRetryTimes;
        private final int retryInterval;
        private final String actionName;

        public final void execute() {
            CompletableFuture<Object> asyncResult = new CompletableFuture();
            try {
                CompletableFuture<TAsyncResult> completableFuture = this.asyncAction.apply();
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"asyncAction.apply()");
                asyncResult = completableFuture;
            }
            catch (Exception ex) {
                asyncResult.completeExceptionally(ex);
            }
            if (asyncResult.isCancelled()) {
                asyncResult.exceptionally(new Function<Throwable, TAsyncResult>(this){
                    final /* synthetic */ AsyncTaskExecutionContext this$0;

                    public final TAsyncResult apply(@NotNull Throwable ex) {
                        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                        IOHelper.access$getLogger$p(IOHelper.INSTANCE).error("Task '{}' was cancelled, contextInfo: {}, current retryTimes: {}.", new Object[]{AsyncTaskExecutionContext.access$getActionName$p(this.this$0), AsyncTaskExecutionContext.access$getContextInfo(this.this$0, AsyncTaskExecutionContext.access$getContextInfoFunc$p(this.this$0)), AsyncTaskExecutionContext.access$getCurrentRetryTimes$p(this.this$0), ex});
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "Task '%s' was cancelled.";
                        Object[] objectArray = new Object[]{AsyncTaskExecutionContext.access$getActionName$p(this.this$0)};
                        boolean bl = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                        AsyncTaskExecutionContext.access$executeFailedAction(this.this$0, ex, string2);
                        return null;
                    }
                    {
                        this.this$0 = asyncTaskExecutionContext;
                    }
                });
                return;
            }
            ((CompletableFuture)asyncResult.thenAccept(new Consumer<TAsyncResult>(this){
                final /* synthetic */ AsyncTaskExecutionContext this$0;

                public final void accept(TAsyncResult result) {
                    AsyncTaskExecutionContext.access$executeSuccessAction(this.this$0, result);
                }
                {
                    this.this$0 = asyncTaskExecutionContext;
                }
            })).exceptionally(new Function<Throwable, Void>(this){
                final /* synthetic */ AsyncTaskExecutionContext this$0;

                public final Void apply(@NotNull Throwable ex) {
                    Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                    AsyncTaskExecutionContext.access$processTaskException(this.this$0, ex);
                    return null;
                }
                {
                    this.this$0 = asyncTaskExecutionContext;
                }
            });
        }

        private final void executeRetryAction() {
            try {
                if (this.currentRetryTimes >= this.maxRetryTimes) {
                    DelayedTask.startDelayedTask(Duration.ofMillis(this.retryInterval), new Action(this){
                        final /* synthetic */ AsyncTaskExecutionContext this$0;

                        public final void apply() {
                            AsyncTaskExecutionContext.access$doRetry(this.this$0);
                        }
                        {
                            this.this$0 = asyncTaskExecutionContext;
                        }
                    });
                } else {
                    this.doRetry();
                }
            }
            catch (Exception ex) {
                IOHelper.access$getLogger$p(INSTANCE).error("Failed to execute the retryAction, actionName:{}, contextInfo:{}", new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), ex});
            }
        }

        private final void doRetry() {
            int n = this.currentRetryTimes;
            this.currentRetryTimes = n + 1;
            this.execute();
        }

        private final void executeSuccessAction(TAsyncResult result) {
            try {
                this.successAction.apply(result);
            }
            catch (Exception ex) {
                IOHelper.access$getLogger$p(INSTANCE).error("Failed to execute the successAction, actionName:{}, contextInfo:{}", new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), ex});
            }
        }

        private final void executeFailedAction(Throwable e, String errorMessage) {
            try {
                Action2<Throwable, String> action2 = this.failedAction;
                if (action2 != null) {
                    action2.apply(e, errorMessage);
                }
            }
            catch (Exception ex) {
                IOHelper.access$getLogger$p(INSTANCE).error("Failed to execute the failedAction of action:{}, contextInfo:{}", new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), ex});
            }
        }

        private final String getContextInfo(Func<String> func) {
            String string;
            try {
                string = func.apply();
            }
            catch (Exception ex) {
                IOHelper.access$getLogger$p(INSTANCE).error("Failed to execute the getContextInfoFunc.", (Throwable)ex);
                string = "";
            }
            return string;
        }

        private final void processTaskException(Throwable exception) {
            if (exception instanceof IORuntimeException) {
                IOHelper.access$getLogger$p(INSTANCE).error("Async task '{}' has io exception, contextInfo:{}, current retryTimes:{}, try to run the async task again.", new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), this.currentRetryTimes, exception});
                this.executeRetryAction();
            } else if (exception instanceof CompletionException && exception.getCause() instanceof IORuntimeException) {
                IOHelper.access$getLogger$p(INSTANCE).error("Async task '{}' has io exception, contextInfo:{}, current retryTimes:{}, try to run the async task again.", new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), this.currentRetryTimes, exception});
                this.executeRetryAction();
            } else {
                IOHelper.access$getLogger$p(INSTANCE).error("Task '{}' has unknown exception, contextInfo:{}, current retryTimes:{}", new Object[]{this.actionName, this.getContextInfo(this.contextInfoFunc), this.currentRetryTimes, exception});
                if (this.retryWhenFailed) {
                    this.executeRetryAction();
                } else {
                    this.executeFailedAction(exception, exception.getMessage());
                }
            }
        }

        public AsyncTaskExecutionContext(@NotNull String actionName, @NotNull Func<CompletableFuture<TAsyncResult>> asyncAction, @NotNull Action1<TAsyncResult> successAction, @NotNull Func<String> contextInfoFunc, @Nullable Action2<Throwable, String> failedAction, int retryTimes, boolean retryWhenFailed, int maxRetryTimes, int retryInterval) {
            Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
            Intrinsics.checkNotNullParameter(asyncAction, (String)"asyncAction");
            Intrinsics.checkNotNullParameter(successAction, (String)"successAction");
            Intrinsics.checkNotNullParameter(contextInfoFunc, (String)"contextInfoFunc");
            this.actionName = actionName;
            this.successAction = successAction;
            this.contextInfoFunc = contextInfoFunc;
            this.failedAction = failedAction;
            this.currentRetryTimes = retryTimes;
            this.retryWhenFailed = retryWhenFailed;
            this.maxRetryTimes = maxRetryTimes;
            this.retryInterval = retryInterval;
            this.asyncAction = asyncAction;
        }

        public static final /* synthetic */ String access$getActionName$p(AsyncTaskExecutionContext $this) {
            return $this.actionName;
        }

        public static final /* synthetic */ String access$getContextInfo(AsyncTaskExecutionContext $this, Func func) {
            return $this.getContextInfo(func);
        }

        public static final /* synthetic */ Func access$getContextInfoFunc$p(AsyncTaskExecutionContext $this) {
            return $this.contextInfoFunc;
        }

        public static final /* synthetic */ int access$getCurrentRetryTimes$p(AsyncTaskExecutionContext $this) {
            return $this.currentRetryTimes;
        }

        public static final /* synthetic */ void access$setCurrentRetryTimes$p(AsyncTaskExecutionContext $this, int n) {
            $this.currentRetryTimes = n;
        }

        public static final /* synthetic */ void access$executeFailedAction(AsyncTaskExecutionContext $this, Throwable e, String errorMessage) {
            $this.executeFailedAction(e, errorMessage);
        }

        public static final /* synthetic */ void access$executeSuccessAction(AsyncTaskExecutionContext $this, Object result) {
            $this.executeSuccessAction(result);
        }

        public static final /* synthetic */ void access$processTaskException(AsyncTaskExecutionContext $this, Throwable exception) {
            $this.processTaskException(exception);
        }

        public static final /* synthetic */ void access$doRetry(AsyncTaskExecutionContext $this) {
            $this.doRetry();
        }
    }
}

