/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.scheduling;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.enodeframework.common.function.Action;
import org.enodeframework.common.scheduling.IScheduleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduleService
implements IScheduleService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultScheduleService.class);
    private final Object lockObject = new Object();
    private final Map<String, TimerBasedTask> taskDict = new HashMap<String, TimerBasedTask>();
    private final ScheduledExecutorService scheduledThreadPool = new ScheduledThreadPoolExecutor(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setDaemon(true).setNameFormat("ScheduleService-%d").build());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startTask(String name, Action action, int dueTime, int period) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.taskDict.containsKey(name)) {
                return;
            }
            ScheduledFuture<?> scheduledFuture = this.scheduledThreadPool.scheduleWithFixedDelay(new TaskCallback(name), dueTime, period, TimeUnit.MILLISECONDS);
            this.taskDict.put(name, new TimerBasedTask(name, action, scheduledFuture, dueTime, period, false));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopTask(String name) {
        Object object = this.lockObject;
        synchronized (object) {
            if (this.taskDict.containsKey(name)) {
                TimerBasedTask task = this.taskDict.get(name);
                task.setStopped(true);
                task.getScheduledFuture().cancel(false);
                this.taskDict.remove(name);
            }
        }
    }

    class TaskCallback
    implements Runnable {
        private String taskName;

        public TaskCallback(String taskName) {
            this.taskName = taskName;
        }

        @Override
        public void run() {
            TimerBasedTask task = (TimerBasedTask)DefaultScheduleService.this.taskDict.get(this.taskName);
            if (task != null) {
                try {
                    if (!task.isStopped()) {
                        task.action.apply();
                    }
                }
                catch (Exception ex) {
                    logger.error("Task has exception, name: {}, due: {}, period: {}", new Object[]{task.getName(), task.getDueTime(), task.getPeriod(), ex});
                }
            }
        }
    }

    static class TimerBasedTask {
        private String name;
        private Action action;
        private ScheduledFuture<?> scheduledFuture;
        private int dueTime;
        private int period;
        private boolean stopped;

        public TimerBasedTask(String name, Action action, ScheduledFuture<?> scheduledFuture, int dueTime, int period, boolean stopped) {
            this.name = name;
            this.action = action;
            this.scheduledFuture = scheduledFuture;
            this.dueTime = dueTime;
            this.period = period;
            this.stopped = stopped;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Action getAction() {
            return this.action;
        }

        public void setAction(Action action) {
            this.action = action;
        }

        public ScheduledFuture<?> getScheduledFuture() {
            return this.scheduledFuture;
        }

        public void setScheduledFuture(ScheduledFuture<?> scheduledFuture) {
            this.scheduledFuture = scheduledFuture;
        }

        public int getDueTime() {
            return this.dueTime;
        }

        public void setDueTime(int dueTime) {
            this.dueTime = dueTime;
        }

        public int getPeriod() {
            return this.period;
        }

        public void setPeriod(int period) {
            this.period = period;
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public void setStopped(boolean stopped) {
            this.stopped = stopped;
        }
    }
}

