/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.enodeframework.common.container.ObjectContainer;
import org.enodeframework.domain.IAggregateRepository;
import org.enodeframework.domain.IAggregateRepositoryProvider;
import org.enodeframework.domain.IAggregateRepositoryProxy;
import org.enodeframework.domain.IAggregateRoot;
import org.enodeframework.domain.impl.AggregateRepositoryProxy;
import org.enodeframework.infrastructure.IAssemblyInitializer;
import org.enodeframework.infrastructure.TypeUtils;

public class DefaultAggregateRepositoryProvider
implements IAggregateRepositoryProvider,
IAssemblyInitializer {
    private final Map<Class<?>, IAggregateRepositoryProxy> repositoryDict = new HashMap();

    @Override
    public IAggregateRepositoryProxy getRepository(Class<? extends IAggregateRoot> aggregateRootType) {
        return this.repositoryDict.get(aggregateRootType);
    }

    @Override
    public void initialize(Set<Class<?>> componentTypes) {
        componentTypes.stream().filter(TypeUtils::isAggregateRepositoryType).forEach(this::registerAggregateRepository);
    }

    private void registerAggregateRepository(Class<?> aggregateRepositoryType) {
        Type[] genericInterfaces = aggregateRepositoryType.getGenericInterfaces();
        Arrays.stream(genericInterfaces).forEach(x -> {
            ParameterizedType superGenericInterfaceType = (ParameterizedType)x;
            if (!IAggregateRepository.class.equals((Object)superGenericInterfaceType.getRawType())) {
                return;
            }
            AggregateRepositoryProxy aggregateRepositoryProxy = new AggregateRepositoryProxy();
            aggregateRepositoryProxy.setInnerObject(ObjectContainer.INSTANCE.resolve(aggregateRepositoryType));
            this.repositoryDict.put((Class)superGenericInterfaceType.getActualTypeArguments()[0], aggregateRepositoryProxy);
        });
    }
}

