/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.concurrent.CompletableFuture;
import org.enodeframework.common.utilities.Ensure;
import org.enodeframework.domain.IAggregateRoot;
import org.enodeframework.domain.IMemoryCache;
import org.enodeframework.domain.IRepository;

public class DefaultRepository
implements IRepository {
    private final IMemoryCache memoryCache;

    public DefaultRepository(IMemoryCache memoryCache) {
        this.memoryCache = memoryCache;
    }

    @Override
    public <T extends IAggregateRoot> CompletableFuture<T> getAsync(Class<T> aggregateRootType, Object aggregateRootId) {
        Ensure.notNull(aggregateRootType, "aggregateRootType");
        Ensure.notNull(aggregateRootId, "aggregateRootId");
        CompletableFuture<T> future = this.memoryCache.getAsync(aggregateRootId, aggregateRootType);
        return future.thenCompose(aggregateRoot -> {
            if (aggregateRoot == null) {
                return this.memoryCache.refreshAggregateFromEventStoreAsync(aggregateRootType, aggregateRootId.toString());
            }
            return CompletableFuture.completedFuture(aggregateRoot);
        });
    }

    @Override
    public CompletableFuture<IAggregateRoot> getAsync(Object aggregateRootId) {
        return this.getAsync(IAggregateRoot.class, aggregateRootId);
    }

    @Override
    public <T extends IAggregateRoot> void refreshAggregate(T aggregateRoot) {
        this.memoryCache.refreshAggregate(aggregateRoot);
    }
}

