/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import org.enodeframework.common.exception.MailBoxProcessException;
import org.enodeframework.common.function.Action1;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.utilities.SystemClock;
import org.enodeframework.eventing.DomainEventStreamMessage;
import org.enodeframework.eventing.EnqueueMessageResult;
import org.enodeframework.eventing.ProcessingEvent;
import org.enodeframework.eventing.ProcessingEventMailBox;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\r\u0018\u0000 02\u00020\u0001:\u00010B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u001a\u001a\u00020\u001bJ\u0010\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u0007H\u0002J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0007J\u0006\u0010 \u001a\u00020\u001bJ\u0006\u0010!\u001a\u00020\u0014J\u0006\u0010\"\u001a\u00020\u0014J\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u0014J\u0006\u0010\f\u001a\u00020$J\u0006\u0010\u000e\u001a\u00020$J\u0006\u0010&\u001a\u00020\u001bJ\b\u0010'\u001a\u00020\u001bH\u0002J\b\u0010(\u001a\u00020\u001bH\u0002J\b\u0010)\u001a\u00020\u001bH\u0002J\u000e\u0010*\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u0014J\b\u0010,\u001a\u00020\u001bH\u0002J\u0010\u0010-\u001a\u00020\u001b2\u0006\u0010+\u001a\u00020\u0014H\u0002J\u0006\u0010.\u001a\u00020\u001bJ\u0006\u0010/\u001a\u00020$R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0015R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/enodeframework/eventing/ProcessingEventMailBox;", "", "aggregateRootTypeName", "", "aggregateRootId", "handleProcessingEventAction", "Lorg/enodeframework/common/function/Action1;", "Lorg/enodeframework/eventing/ProcessingEvent;", "(Ljava/lang/String;Ljava/lang/String;Lorg/enodeframework/common/function/Action1;)V", "getAggregateRootId", "()Ljava/lang/String;", "getAggregateRootTypeName", "isRemoved", "Ljava/util/concurrent/atomic/AtomicInteger;", "isRunning", "isUsing", "lastActiveTime", "Ljava/util/Date;", "lockObj", "nextExpectingEventVersion", "", "Ljava/lang/Integer;", "processingEventQueue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "waitingProcessingEventDict", "Ljava/util/concurrent/ConcurrentHashMap;", "completeRun", "", "enqueueEventStream", "processingEvent", "enqueueMessage", "Lorg/enodeframework/eventing/EnqueueMessageResult;", "exitUsing", "getTotalUnHandledMessageCount", "getWaitingMessageCount", "isInactive", "", "timeoutSeconds", "markAsRemoved", "processMessage", "setAsNotRunning", "setAsRunning", "setNextExpectingEventVersion", "version", "tryEnqueueValidWaitingMessage", "tryRemovedInvalidWaitingMessages", "tryRun", "tryUsing", "Companion", "enode"})
public final class ProcessingEventMailBox {
    private final Object lockObj;
    private final AtomicInteger isUsing;
    private final AtomicInteger isRemoved;
    private final AtomicInteger isRunning;
    private ConcurrentHashMap<Integer, ProcessingEvent> waitingProcessingEventDict;
    private ConcurrentLinkedQueue<ProcessingEvent> processingEventQueue;
    private Date lastActiveTime;
    private Integer nextExpectingEventVersion;
    @NotNull
    private final String aggregateRootTypeName;
    @NotNull
    private final String aggregateRootId;
    private Action1<ProcessingEvent> handleProcessingEventAction;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    private final void tryRemovedInvalidWaitingMessages(int version) {
        ((ConcurrentHashMap.KeySetView)this.waitingProcessingEventDict.keySet()).stream().filter((Predicate)new Predicate<Integer>(version){
            final /* synthetic */ int $version;

            public final boolean test(int x) {
                return x < this.$version;
            }
            {
                this.$version = n;
            }
        }).forEach((Consumer)new Consumer<Integer>(this, version){
            final /* synthetic */ ProcessingEventMailBox this$0;
            final /* synthetic */ int $version;

            public final void accept(int key2) {
                if (ProcessingEventMailBox.access$getWaitingProcessingEventDict$p(this.this$0).containsKey(key2)) {
                    ProcessingEvent processingEvent;
                    ProcessingEvent processingEvent2 = processingEvent = (ProcessingEvent)ProcessingEventMailBox.access$getWaitingProcessingEventDict$p(this.this$0).remove(key2);
                    Intrinsics.checkNotNull((Object)processingEvent2);
                    processingEvent2.complete();
                    Logger logger = ProcessingEventMailBox.access$getLogger$cp();
                    Object[] objectArray = new Object[9];
                    objectArray[0] = this.this$0.getClass().getName();
                    objectArray[1] = processingEvent.getMessage().getAggregateRootTypeName();
                    objectArray[2] = processingEvent.getMessage().getAggregateRootId();
                    DomainEventStreamMessage domainEventStreamMessage = processingEvent.getMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage, (String)"processingEvent.message");
                    objectArray[3] = domainEventStreamMessage.getCommandId();
                    objectArray[4] = processingEvent.getMessage().getVersion();
                    DomainEventStreamMessage domainEventStreamMessage2 = processingEvent.getMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage2, (String)"processingEvent.message");
                    objectArray[5] = domainEventStreamMessage2.getId();
                    DomainEventStreamMessage domainEventStreamMessage3 = processingEvent.getMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage3, (String)"processingEvent.message");
                    objectArray[6] = domainEventStreamMessage3.getEvents().stream().map(tryRemovedInvalidWaitingMessages.1.INSTANCE).collect(Collectors.joining("|"));
                    DomainEventStreamMessage domainEventStreamMessage4 = processingEvent.getMessage();
                    Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage4, (String)"processingEvent.message");
                    objectArray[7] = domainEventStreamMessage4.getEvents().stream().map(tryRemovedInvalidWaitingMessages.2.INSTANCE).collect(Collectors.joining("|"));
                    objectArray[8] = this.$version;
                    logger.warn("{} invalid waiting message removed, aggregateRootType: {}, aggregateRootId: {}, commandId: {}, eventVersion: {}, eventStreamId: {}, eventTypes: {}, eventIds: {}, nextExpectingEventVersion: {}", objectArray);
                }
            }
            {
                this.this$0 = processingEventMailBox;
                this.$version = n;
            }
        });
    }

    private final void tryEnqueueValidWaitingMessage() {
        if (this.nextExpectingEventVersion == null) {
            return;
        }
        while (true) {
            Map map = this.waitingProcessingEventDict;
            Object object = this.nextExpectingEventVersion;
            boolean bl = false;
            Map map2 = map;
            if (map2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.Map<K, *>");
            }
            if (!map2.containsKey(object)) break;
            object = this.waitingProcessingEventDict;
            Integer n = this.nextExpectingEventVersion;
            boolean bl2 = false;
            Object object2 = object;
            if (object2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.MutableMap<K, V>");
            }
            ProcessingEvent nextProcessingEvent = (ProcessingEvent)TypeIntrinsics.asMutableMap((Object)object2).remove(n);
            if (nextProcessingEvent == null) continue;
            this.enqueueEventStream(nextProcessingEvent);
            logger.info("{} enqueued waiting processingEvent, aggregateRootId: {}, aggregateRootTypeName: {}, eventVersion: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, this.aggregateRootTypeName, nextProcessingEvent.getMessage().getVersion()});
        }
    }

    public final int getTotalUnHandledMessageCount() {
        Collection collection = this.processingEventQueue;
        boolean bl = false;
        return collection.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void setNextExpectingEventVersion(int version) {
        var2_2 = this.lockObj;
        var3_3 = false;
        var4_4 = false;
        synchronized (var2_2) {
            $i$a$-synchronized-ProcessingEventMailBox$setNextExpectingEventVersion$1 = false;
            this.tryRemovedInvalidWaitingMessages(version);
            if (this.nextExpectingEventVersion == null) ** GOTO lbl-1000
            v0 = this.nextExpectingEventVersion;
            Intrinsics.checkNotNull((Object)v0);
            if (version > v0) lbl-1000:
            // 2 sources

            {
                this.nextExpectingEventVersion = version;
                ProcessingEventMailBox.logger.info("{} refreshed nextExpectingEventVersion, aggregateRootId: {}, aggregateRootTypeName: {}, version: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, this.aggregateRootTypeName, this.nextExpectingEventVersion});
                this.tryEnqueueValidWaitingMessage();
                this.lastActiveTime = new Date();
                this.tryRun();
            } else {
                v1 = this.nextExpectingEventVersion;
                if (v1 != null && version == v1) {
                    ProcessingEventMailBox.logger.info("{} equals nextExpectingEventVersion ignored, aggregateRootId: {}, aggregateRootTypeName: {}, version: {}, current nextExpectingEventVersion: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, this.aggregateRootTypeName, version, this.nextExpectingEventVersion});
                } else {
                    ProcessingEventMailBox.logger.info("{} nextExpectingEventVersion ignored, aggregateRootId: {}, aggregateRootTypeName: {}, version: {}, current nextExpectingEventVersion: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, this.aggregateRootTypeName, version, this.nextExpectingEventVersion});
                }
            }
            var4_5 = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enqueueEventStream(ProcessingEvent processingEvent) {
        Object object = this.lockObj;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            processingEvent.setMailbox(this);
            this.processingEventQueue.add(processingEvent);
            this.nextExpectingEventVersion = processingEvent.getMessage().getVersion() + 1;
            Logger logger = ProcessingEventMailBox.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            if (logger.isDebugEnabled()) {
                Object[] objectArray = new Object[8];
                objectArray[0] = this.getClass().getName();
                objectArray[1] = processingEvent.getMessage().getAggregateRootTypeName();
                objectArray[2] = processingEvent.getMessage().getAggregateRootId();
                DomainEventStreamMessage domainEventStreamMessage = processingEvent.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage, (String)"processingEvent.message");
                objectArray[3] = domainEventStreamMessage.getCommandId();
                objectArray[4] = processingEvent.getMessage().getVersion();
                DomainEventStreamMessage domainEventStreamMessage2 = processingEvent.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage2, (String)"processingEvent.message");
                objectArray[5] = domainEventStreamMessage2.getId();
                DomainEventStreamMessage domainEventStreamMessage3 = processingEvent.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage3, (String)"processingEvent.message");
                objectArray[6] = domainEventStreamMessage3.getEvents().stream().map(enqueueEventStream.1.1.INSTANCE).collect(Collectors.joining("|"));
                DomainEventStreamMessage domainEventStreamMessage4 = processingEvent.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage4, (String)"processingEvent.message");
                objectArray[7] = domainEventStreamMessage4.getEvents().stream().map(enqueueEventStream.1.2.INSTANCE).collect(Collectors.joining("|"));
                ProcessingEventMailBox.logger.debug("{} enqueued new message, aggregateRootType: {}, aggregateRootId: {}, commandId: {}, eventVersion: {}, eventStreamId: {}, eventTypes: {}, eventIds: {}", objectArray);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final EnqueueMessageResult enqueueMessage(@NotNull ProcessingEvent processingEvent) {
        Intrinsics.checkNotNullParameter((Object)processingEvent, (String)"processingEvent");
        Object object = this.lockObj;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            block9: {
                DomainEventStreamMessage eventStream;
                block8: {
                    boolean bl3 = false;
                    if (this.isRemoved()) {
                        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                        String string = "ProcessingEventMailBox was removed, cannot allow to enqueue message, aggregateRootTypeName: %s, aggregateRootId: %s";
                        Object[] objectArray = new Object[]{this.aggregateRootTypeName, this.aggregateRootId};
                        boolean bl4 = false;
                        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                        throw (Throwable)new MailBoxProcessException(string2);
                    }
                    eventStream = processingEvent.getMessage();
                    if (this.nextExpectingEventVersion != null) {
                        int n = eventStream.getVersion();
                        Integer n2 = this.nextExpectingEventVersion;
                        Intrinsics.checkNotNull((Object)n2);
                        if (n <= n2) break block8;
                    }
                    if (this.waitingProcessingEventDict.putIfAbsent(eventStream.getVersion(), processingEvent) == null) {
                        Object[] objectArray = new Object[9];
                        objectArray[0] = this.getClass().getName();
                        objectArray[1] = eventStream.getAggregateRootTypeName();
                        objectArray[2] = eventStream.getAggregateRootId();
                        DomainEventStreamMessage domainEventStreamMessage = eventStream;
                        Intrinsics.checkNotNullExpressionValue((Object)domainEventStreamMessage, (String)"eventStream");
                        objectArray[3] = domainEventStreamMessage.getCommandId();
                        objectArray[4] = eventStream.getVersion();
                        objectArray[5] = eventStream.getId();
                        objectArray[6] = eventStream.getEvents().stream().map(enqueueMessage.1.1.INSTANCE).collect(Collectors.joining("|"));
                        objectArray[7] = eventStream.getEvents().stream().map(enqueueMessage.1.2.INSTANCE).collect(Collectors.joining("|"));
                        objectArray[8] = this.nextExpectingEventVersion;
                        logger.warn("{} waiting message added, aggregateRootType: {}, aggregateRootId: {}, commandId: {}, eventVersion: {}, eventStreamId: {}, eventTypes: {}, eventIds: {}, nextExpectingEventVersion: {}", objectArray);
                    }
                    EnqueueMessageResult enqueueMessageResult = EnqueueMessageResult.AddToWaitingList;
                    return enqueueMessageResult;
                }
                Integer n = this.nextExpectingEventVersion;
                if (n == null || eventStream.getVersion() != n.intValue()) break block9;
                this.enqueueEventStream(processingEvent);
                this.tryEnqueueValidWaitingMessage();
                this.lastActiveTime = new Date();
                this.tryRun();
                EnqueueMessageResult enqueueMessageResult = EnqueueMessageResult.Success;
                return enqueueMessageResult;
            }
            EnqueueMessageResult enqueueMessageResult = EnqueueMessageResult.Ignored;
            return enqueueMessageResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryRun() {
        Object object = this.lockObj;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            if (this.isRunning()) {
                return;
            }
            this.setAsRunning();
            Logger logger = ProcessingEventMailBox.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            if (logger.isDebugEnabled()) {
                ProcessingEventMailBox.logger.debug("{} start run, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
            }
            Job job = BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getDefault())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null, this){
                int label;
                final /* synthetic */ ProcessingEventMailBox this$0;
                {
                    this.this$0 = processingEventMailBox;
                    super(2, continuation);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProcessingEventMailBox.access$processMessage(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                    Intrinsics.checkNotNullParameter(completion, (String)"completion");
                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    return function2;
                }

                public final Object invoke(Object object, Object object2) {
                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    public final void completeRun() {
        this.lastActiveTime = new Date();
        Logger logger = ProcessingEventMailBox.logger;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
        if (logger.isDebugEnabled()) {
            ProcessingEventMailBox.logger.debug("{} complete run, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
        }
        this.setAsNotRunning();
        if (this.getTotalUnHandledMessageCount() > 0) {
            this.tryRun();
        }
    }

    public final boolean isInactive(int timeoutSeconds) {
        return SystemClock.now() - this.lastActiveTime.getTime() >= (long)timeoutSeconds;
    }

    private final void processMessage() {
        ProcessingEvent message = this.processingEventQueue.poll();
        if (message != null) {
            this.lastActiveTime = new Date();
            try {
                this.handleProcessingEventAction.apply(message);
            }
            catch (Exception ex) {
                logger.error("{} run has unknown exception, aggregateRootId: {}", new Object[]{this.getClass().getName(), this.aggregateRootId, ex});
                Task.sleep(1L);
                this.completeRun();
            }
        } else {
            this.completeRun();
        }
    }

    public final boolean tryUsing() {
        return this.isUsing.compareAndSet(0, 1);
    }

    public final void exitUsing() {
        this.isUsing.set(0);
    }

    public final void markAsRemoved() {
        this.isRemoved.set(1);
    }

    private final void setAsRunning() {
        this.isRunning.set(1);
    }

    public final boolean isRunning() {
        return this.isRunning.get() == 1;
    }

    public final boolean isRemoved() {
        return this.isRemoved.get() == 1;
    }

    private final void setAsNotRunning() {
        this.isRunning.set(0);
    }

    public final int getWaitingMessageCount() {
        return this.waitingProcessingEventDict.size();
    }

    @NotNull
    public final String getAggregateRootTypeName() {
        return this.aggregateRootTypeName;
    }

    @NotNull
    public final String getAggregateRootId() {
        return this.aggregateRootId;
    }

    public ProcessingEventMailBox(@NotNull String aggregateRootTypeName, @NotNull String aggregateRootId, @NotNull Action1<ProcessingEvent> handleProcessingEventAction) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter(handleProcessingEventAction, (String)"handleProcessingEventAction");
        this.aggregateRootTypeName = aggregateRootTypeName;
        this.aggregateRootId = aggregateRootId;
        this.handleProcessingEventAction = handleProcessingEventAction;
        this.lockObj = new Object();
        this.isUsing = new AtomicInteger(0);
        this.isRemoved = new AtomicInteger(0);
        this.isRunning = new AtomicInteger(0);
        this.waitingProcessingEventDict = new ConcurrentHashMap();
        this.processingEventQueue = new ConcurrentLinkedQueue();
        this.lastActiveTime = new Date();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(ProcessingEventMailBox.class);
    }

    public static final /* synthetic */ ConcurrentHashMap access$getWaitingProcessingEventDict$p(ProcessingEventMailBox $this) {
        return $this.waitingProcessingEventDict;
    }

    public static final /* synthetic */ void access$setWaitingProcessingEventDict$p(ProcessingEventMailBox $this, ConcurrentHashMap concurrentHashMap) {
        $this.waitingProcessingEventDict = concurrentHashMap;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ void access$processMessage(ProcessingEventMailBox $this) {
        $this.processMessage();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/eventing/ProcessingEventMailBox$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

