/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventAppendResult;
import org.enodeframework.eventing.IEventStore;
import org.enodeframework.eventing.impl.InMemoryEventStore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J \u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00122\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u0018\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\u00122\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J,\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016J4\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u00122\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u001c\u001a\u00020\u0016H\u0016R\u001e\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\b\u0012\u00060\u0006R\u00020\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lorg/enodeframework/eventing/impl/InMemoryEventStore;", "Lorg/enodeframework/eventing/IEventStore;", "()V", "aggregateInfoDict", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/enodeframework/eventing/impl/InMemoryEventStore$AggregateInfo;", "lockObj", "", "batchAppend", "", "aggregateRootId", "eventStreamList", "", "Lorg/enodeframework/eventing/DomainEventStream;", "eventAppendResult", "Lorg/enodeframework/eventing/EventAppendResult;", "batchAppendAsync", "Ljava/util/concurrent/CompletableFuture;", "eventStreams", "find", "version", "", "commandId", "findAsync", "queryAggregateEvents", "aggregateRootTypeName", "minVersion", "maxVersion", "queryAggregateEventsAsync", "AggregateInfo", "enode"})
public final class InMemoryEventStore
implements IEventStore {
    private final Object lockObj = new Object();
    private final ConcurrentMap<String, AggregateInfo> aggregateInfoDict = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DomainEventStream> queryAggregateEvents(@NotNull String aggregateRootId, @NotNull String aggregateRootTypeName, int minVersion, int maxVersion) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Map.Entry x;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        List eventStreams = new ArrayList();
        AggregateInfo aggregateInfo = (AggregateInfo)this.aggregateInfoDict.get(aggregateRootId);
        if (aggregateInfo == null) {
            return eventStreams;
        }
        AggregateInfo aggregateInfo2 = aggregateInfo;
        int min = Math.max(minVersion, 1);
        int max = Math.min(maxVersion, aggregateInfo2.getCurrentVersion());
        Map $this$filter$iv = aggregateInfo2.getEventDict();
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        void var14_14 = $this$filterTo$iv$iv;
        boolean bl = false;
        Iterator iterator = var14_14.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            x = element$iv$iv = iterator.next();
            boolean bl2 = false;
            Object k = x.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"x.key");
            int n = ((Number)k).intValue();
            if (!(min <= n && max >= n)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        $this$filter$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        var14_14 = $this$mapTo$iv$iv;
        bl = false;
        for (Map.Entry item$iv$iv : var14_14.entrySet()) {
            x = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl3 = false;
            DomainEventStream domainEventStream = (DomainEventStream)x.getValue();
            object.add(domainEventStream);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompletableFuture<EventAppendResult> batchAppendAsync(@NotNull List<? extends DomainEventStream> eventStreams) {
        Intrinsics.checkNotNullParameter(eventStreams, (String)"eventStreams");
        Map map = eventStreams.stream().distinct().collect(Collectors.groupingBy(batchAppendAsync.eventStreamDict.1.INSTANCE));
        Intrinsics.checkNotNullExpressionValue(map, (String)"eventStreams.stream().di\u2026-> obj.aggregateRootId })");
        Map eventStreamDict2 = map;
        EventAppendResult eventAppendResult = new EventAppendResult();
        CompletableFuture<EventAppendResult> future = new CompletableFuture<EventAppendResult>();
        Object object = eventStreamDict2;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key2;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            List value = entry2.getValue();
            this.batchAppend((String)key2, value, eventAppendResult);
        }
        future.complete(eventAppendResult);
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<DomainEventStream> findAsync(@NotNull String aggregateRootId, int version) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        CompletableFuture<DomainEventStream> completableFuture = CompletableFuture.completedFuture(this.find(aggregateRootId, version));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.comple\u2026ggregateRootId, version))");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<DomainEventStream> findAsync(@NotNull String aggregateRootId, @NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        CompletableFuture<DomainEventStream> completableFuture = CompletableFuture.completedFuture(this.find(aggregateRootId, commandId));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.comple\u2026regateRootId, commandId))");
        return completableFuture;
    }

    @Override
    @NotNull
    public CompletableFuture<List<DomainEventStream>> queryAggregateEventsAsync(@NotNull String aggregateRootId, @NotNull String aggregateRootTypeName, int minVersion, int maxVersion) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        CompletableFuture<List<DomainEventStream>> completableFuture = CompletableFuture.completedFuture(this.queryAggregateEvents(aggregateRootId, aggregateRootTypeName, minVersion, maxVersion));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"CompletableFuture.comple\u2026 minVersion, maxVersion))");
        return completableFuture;
    }

    private final DomainEventStream find(String aggregateRootId, int version) {
        AggregateInfo aggregateInfo = this.aggregateInfoDict.getOrDefault(aggregateRootId, null);
        if (aggregateInfo == null) {
            return null;
        }
        AggregateInfo aggregateInfo2 = aggregateInfo;
        return (DomainEventStream)aggregateInfo2.getEventDict().get(version);
    }

    private final DomainEventStream find(String aggregateRootId, String commandId) {
        AggregateInfo aggregateInfo = this.aggregateInfoDict.getOrDefault(aggregateRootId, null);
        if (aggregateInfo == null) {
            return null;
        }
        AggregateInfo aggregateInfo2 = aggregateInfo;
        return (DomainEventStream)aggregateInfo2.getCommandDict().get(commandId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void batchAppend(String aggregateRootId, List<? extends DomainEventStream> eventStreamList, EventAppendResult eventAppendResult) {
        Object object = this.lockObj;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            Optional optionalDomainEventStream;
            boolean bl3 = false;
            AggregateInfo aggregateInfo = this.aggregateInfoDict.computeIfAbsent(aggregateRootId, new Function<String, AggregateInfo>(this, aggregateRootId, eventStreamList, eventAppendResult){
                final /* synthetic */ InMemoryEventStore this$0;
                final /* synthetic */ String $aggregateRootId$inlined;
                final /* synthetic */ List $eventStreamList$inlined;
                final /* synthetic */ EventAppendResult $eventAppendResult$inlined;
                {
                    this.this$0 = inMemoryEventStore;
                    this.$aggregateRootId$inlined = string;
                    this.$eventStreamList$inlined = list;
                    this.$eventAppendResult$inlined = eventAppendResult;
                }

                public final AggregateInfo apply(String it) {
                    return this.this$0.new AggregateInfo();
                }
            });
            Optional optional = optionalDomainEventStream = eventStreamList.stream().findFirst();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"optionalDomainEventStream");
            if (optional.isPresent()) {
                Object e = optionalDomainEventStream.get();
                Intrinsics.checkNotNullExpressionValue(e, (String)"optionalDomainEventStream.get()");
                DomainEventStream firstEventStream = (DomainEventStream)e;
                int n = firstEventStream.getVersion();
                AggregateInfo aggregateInfo2 = aggregateInfo;
                Intrinsics.checkNotNull((Object)aggregateInfo2);
                if (n != aggregateInfo2.getCurrentVersion() + 1) {
                    eventAppendResult.addDuplicateEventAggregateRootId(aggregateRootId);
                    return;
                }
            }
            int firstEventStream = 0;
            int n = eventStreamList.size() - 1;
            while (firstEventStream < n) {
                void i;
                if (eventStreamList.get((int)(i + true)).getVersion() != eventStreamList.get((int)i).getVersion() + 1) {
                    eventAppendResult.addDuplicateEventAggregateRootId(aggregateRootId);
                    return;
                }
                ++i;
            }
            List duplicateCommandIds = new ArrayList();
            for (DomainEventStream domainEventStream : eventStreamList) {
                AggregateInfo aggregateInfo3 = aggregateInfo;
                Intrinsics.checkNotNull((Object)aggregateInfo3);
                if (!aggregateInfo3.getCommandDict().containsKey(domainEventStream.getCommandId())) continue;
                String string = domainEventStream.getCommandId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eventStream.commandId");
                duplicateCommandIds.add(string);
            }
            if (duplicateCommandIds.size() > 0) {
                eventAppendResult.addDuplicateCommandIds(aggregateRootId, duplicateCommandIds);
                return;
            }
            for (DomainEventStream domainEventStream : eventStreamList) {
                AggregateInfo aggregateInfo4 = aggregateInfo;
                Intrinsics.checkNotNull((Object)aggregateInfo4);
                ((Map)aggregateInfo4.getEventDict()).put(domainEventStream.getVersion(), domainEventStream);
                ((Map)aggregateInfo.getCommandDict()).put(domainEventStream.getCommandId(), domainEventStream);
                aggregateInfo.setCurrentVersion(domainEventStream.getVersion());
            }
            if (!eventAppendResult.getSuccessAggregateRootIdList().contains(aggregateRootId)) {
                eventAppendResult.addSuccessAggregateRootId(aggregateRootId);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R&\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\b\"\u0004\b\u0013\u0010\nR\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001a"}, d2={"Lorg/enodeframework/eventing/impl/InMemoryEventStore$AggregateInfo;", "", "(Lorg/enodeframework/eventing/impl/InMemoryEventStore;)V", "commandDict", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/enodeframework/eventing/DomainEventStream;", "getCommandDict", "()Ljava/util/concurrent/ConcurrentMap;", "setCommandDict", "(Ljava/util/concurrent/ConcurrentMap;)V", "currentVersion", "", "getCurrentVersion", "()I", "setCurrentVersion", "(I)V", "eventDict", "getEventDict", "setEventDict", "status", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getStatus", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "setStatus", "(Ljava/util/concurrent/atomic/AtomicBoolean;)V", "enode"})
    public final class AggregateInfo {
        @NotNull
        private AtomicBoolean status = new AtomicBoolean(false);
        private int currentVersion;
        @NotNull
        private ConcurrentMap<Integer, DomainEventStream> eventDict = new ConcurrentHashMap();
        @NotNull
        private ConcurrentMap<String, DomainEventStream> commandDict = new ConcurrentHashMap();

        @NotNull
        public final AtomicBoolean getStatus() {
            return this.status;
        }

        public final void setStatus(@NotNull AtomicBoolean atomicBoolean) {
            Intrinsics.checkNotNullParameter((Object)atomicBoolean, (String)"<set-?>");
            this.status = atomicBoolean;
        }

        public final int getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(int n) {
            this.currentVersion = n;
        }

        @NotNull
        public final ConcurrentMap<Integer, DomainEventStream> getEventDict() {
            return this.eventDict;
        }

        public final void setEventDict(@NotNull ConcurrentMap<Integer, DomainEventStream> concurrentMap) {
            Intrinsics.checkNotNullParameter(concurrentMap, (String)"<set-?>");
            this.eventDict = concurrentMap;
        }

        @NotNull
        public final ConcurrentMap<String, DomainEventStream> getCommandDict() {
            return this.commandDict;
        }

        public final void setCommandDict(@NotNull ConcurrentMap<String, DomainEventStream> concurrentMap) {
            Intrinsics.checkNotNullParameter(concurrentMap, (String)"<set-?>");
            this.commandDict = concurrentMap;
        }
    }
}

