/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.infrastructure.impl;

import java.util.Map;
import java.util.Objects;
import org.enodeframework.common.exception.EnodeClassNotFoundException;
import org.enodeframework.infrastructure.ITypeNameProvider;

public class DefaultTypeNameProvider
implements ITypeNameProvider {
    private final Map<String, String> typeDict;

    public DefaultTypeNameProvider(Map<String, String> typeDict) {
        this.typeDict = typeDict;
        typeDict.forEach(this::checkForAliasCircle);
    }

    @Override
    public String getTypeName(Class<?> type) {
        return type.getName();
    }

    @Override
    public Class<?> getType(String typeName) {
        try {
            return Class.forName(typeName);
        }
        catch (ClassNotFoundException e) {
            String type = this.typeDict.get(typeName);
            if (type != null) {
                return this.getType(type);
            }
            throw new EnodeClassNotFoundException(e);
        }
    }

    public void checkForAliasCircle(String name, String alias) {
        if (this.hasAlias(name, alias)) {
            throw new IllegalStateException("Cannot register alias '" + alias + "' for name '" + name + "': Circular reference - '" + name + "' is a direct or indirect alias for '" + alias + "' already");
        }
    }

    private boolean hasAlias(String name, String alias) {
        String registeredName = this.typeDict.get(alias);
        return Objects.equals(registeredName, name) || registeredName != null && this.hasAlias(name, registeredName);
    }
}

