/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.enodeframework.common.utilities.IdGenerator;
import org.enodeframework.messaging.IMessage;

public abstract class Message
implements IMessage {
    protected String id;
    protected Date timestamp;
    protected Map<String, Object> items;

    public Message(String id) {
        this.id = id;
        this.timestamp = new Date();
        this.items = new HashMap<String, Object>();
    }

    public Message() {
        this(IdGenerator.nextId());
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Map<String, Object> getItems() {
        return this.items;
    }

    @Override
    public void setItems(Map<String, Object> items) {
        this.items = items;
    }

    @Override
    public void mergeItems(Map<String, Object> mitems) {
        if (mitems == null || mitems.size() == 0) {
            return;
        }
        if (this.items == null) {
            this.items = new HashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : mitems.entrySet()) {
            if (this.items.containsKey(entry.getKey())) continue;
            this.items.put(entry.getKey(), entry.getValue());
        }
    }
}

