/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging.impl;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.enodeframework.infrastructure.IObjectProxy;
import org.enodeframework.infrastructure.ITypeNameProvider;
import org.enodeframework.messaging.IMessage;
import org.enodeframework.messaging.impl.RootDispatching;

public class MultiMessageDispatching {
    private final IMessage[] messages;
    private final ConcurrentMap<String, IObjectProxy> handlerDict;
    private final RootDispatching rootDispatching;

    public MultiMessageDispatching(List<? extends IMessage> messages, List<? extends IObjectProxy> handlers2, RootDispatching rootDispatching, ITypeNameProvider typeNameProvider) {
        this.messages = messages.toArray(new IMessage[0]);
        this.handlerDict = new ConcurrentHashMap<String, IObjectProxy>();
        handlers2.forEach(x -> this.handlerDict.putIfAbsent(typeNameProvider.getTypeName(x.getInnerObject().getClass()), (IObjectProxy)x));
        this.rootDispatching = rootDispatching;
        this.rootDispatching.addChildDispatching(this);
    }

    public IMessage[] getMessages() {
        return this.messages;
    }

    public void removeHandledHandler(String handlerTypeName) {
        if (this.handlerDict.remove(handlerTypeName) != null && this.handlerDict.isEmpty()) {
            this.rootDispatching.onChildDispatchingFinished(this);
        }
    }
}

