/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.command;

import com.google.common.base.Strings;
import java.util.HashMap;
import org.enodeframework.commanding.ICommand;
import org.enodeframework.commanding.ICommandProcessor;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.impl.CommandExecuteContext;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.common.utilities.InetUtil;
import org.enodeframework.domain.IAggregateStorage;
import org.enodeframework.domain.IRepository;
import org.enodeframework.infrastructure.ITypeNameProvider;
import org.enodeframework.queue.IMessageContext;
import org.enodeframework.queue.IMessageHandler;
import org.enodeframework.queue.ISendReplyService;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.command.CommandMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCommandMessageHandler
implements IMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommandMessageHandler.class);
    private final ISendReplyService sendReplyService;
    private final ITypeNameProvider typeNameProvider;
    private final ICommandProcessor commandProcessor;
    private final IRepository repository;
    private final IAggregateStorage aggregateRootStorage;
    private final ISerializeService serializeService;

    public DefaultCommandMessageHandler(ISendReplyService sendReplyService, ITypeNameProvider typeNameProvider, ICommandProcessor commandProcessor, IRepository repository, IAggregateStorage aggregateRootStorage, ISerializeService serializeService) {
        this.sendReplyService = sendReplyService;
        this.typeNameProvider = typeNameProvider;
        this.commandProcessor = commandProcessor;
        this.repository = repository;
        this.aggregateRootStorage = aggregateRootStorage;
        this.serializeService = serializeService;
    }

    @Override
    public void handle(QueueMessage queueMessage, IMessageContext context) {
        logger.info("Received command message: {}", (Object)this.serializeService.serialize(queueMessage));
        CommandMessage commandMessage = this.serializeService.deserialize(queueMessage.getBody(), CommandMessage.class);
        Class<?> commandType = this.typeNameProvider.getType(commandMessage.getCommandType());
        ICommand command = (ICommand)this.serializeService.deserialize(commandMessage.getCommandData(), commandType);
        CommandExecuteContext commandExecuteContext = new CommandExecuteContext(this.repository, this.aggregateRootStorage, queueMessage, context, commandMessage, this.sendReplyService);
        HashMap<String, Object> commandItems = new HashMap<String, Object>();
        String uri = InetUtil.toUri(commandMessage.getReplyAddress());
        if (!Strings.isNullOrEmpty((String)uri)) {
            commandItems.put("COMMAND_REPLY_ADDRESS", uri);
        }
        this.commandProcessor.process(new ProcessingCommand(command, commandExecuteContext, commandItems));
    }
}

