/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.command;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalCause;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.bridge.BridgeOptions;
import io.vertx.ext.bridge.PermittedOptions;
import io.vertx.ext.eventbus.bridge.tcp.TcpEventBusBridge;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandReturnType;
import org.enodeframework.commanding.CommandStatus;
import org.enodeframework.commanding.ICommand;
import org.enodeframework.common.exception.DuplicateCommandRegisterException;
import org.enodeframework.common.function.Action;
import org.enodeframework.common.scheduling.IScheduleService;
import org.enodeframework.common.scheduling.Worker;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.common.utilities.InetUtil;
import org.enodeframework.common.utilities.ReplyMessage;
import org.enodeframework.common.utilities.SystemClock;
import org.enodeframework.queue.command.CommandTaskCompletionSource;
import org.enodeframework.queue.command.ICommandResultProcessor;
import org.enodeframework.queue.domainevent.DomainEventHandledMessage;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 52\u00020\u00012\u00020\u0002:\u00015B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001e\u001a\u00020\fH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0017H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020\u000fH\u0002J\u0010\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020)H\u0002J\u001a\u0010*\u001a\u00020 2\u0006\u0010+\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010\u0015H\u0002J&\u0010-\u001a\u00020 2\u0006\u0010%\u001a\u00020&2\u0006\u0010.\u001a\u00020/2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f01H\u0016J\b\u00102\u001a\u00020 H\u0016J\u0010\u00103\u001a\u00020 2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u00104\u001a\u00020 H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lorg/enodeframework/queue/command/DefaultCommandResultProcessor;", "Lio/vertx/core/AbstractVerticle;", "Lorg/enodeframework/queue/command/ICommandResultProcessor;", "scheduleService", "Lorg/enodeframework/common/scheduling/IScheduleService;", "serializeService", "Lorg/enodeframework/common/serializing/ISerializeService;", "port", "", "completionSourceTimeout", "(Lorg/enodeframework/common/scheduling/IScheduleService;Lorg/enodeframework/common/serializing/ISerializeService;II)V", "bindAddress", "Ljava/net/InetSocketAddress;", "commandExecutedMessageLocalQueue", "Ljava/util/concurrent/BlockingQueue;", "Lorg/enodeframework/commanding/CommandResult;", "commandExecutedMessageWorker", "Lorg/enodeframework/common/scheduling/Worker;", "commandTaskDict", "Lcom/google/common/cache/Cache;", "", "Lorg/enodeframework/queue/command/CommandTaskCompletionSource;", "domainEventHandledMessageLocalQueue", "Lorg/enodeframework/queue/domainevent/DomainEventHandledMessage;", "domainEventHandledMessageWorker", "scanExpireCommandTaskName", "started", "", "tcpEventBusBridge", "Lio/vertx/ext/eventbus/bridge/tcp/TcpEventBusBridge;", "getBindAddress", "processDomainEventHandledMessage", "", "message", "processExecutedCommandMessage", "commandResult", "processFailedSendingCommand", "command", "Lorg/enodeframework/commanding/ICommand;", "processRequestInternal", "reply", "Lorg/enodeframework/common/utilities/ReplyMessage;", "processTimeoutCommand", "commandId", "commandTaskCompletionSource", "registerProcessingCommand", "commandReturnType", "Lorg/enodeframework/commanding/CommandReturnType;", "taskCompletionSource", "Ljava/util/concurrent/CompletableFuture;", "start", "startServer", "stop", "Companion", "enode"})
public final class DefaultCommandResultProcessor
extends AbstractVerticle
implements ICommandResultProcessor {
    private final String scanExpireCommandTaskName;
    private final Cache<String, CommandTaskCompletionSource> commandTaskDict;
    private final BlockingQueue<CommandResult> commandExecutedMessageLocalQueue;
    private final BlockingQueue<DomainEventHandledMessage> domainEventHandledMessageLocalQueue;
    private final Worker commandExecutedMessageWorker;
    private final Worker domainEventHandledMessageWorker;
    private InetSocketAddress bindAddress;
    private TcpEventBusBridge tcpEventBusBridge;
    private boolean started;
    private final IScheduleService scheduleService;
    private final ISerializeService serializeService;
    private final int port;
    private final int completionSourceTimeout;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    private final void startServer(int port) {
        InetSocketAddress inetSocketAddress = this.bindAddress = new InetSocketAddress(InetAddress.getLocalHost(), port);
        if (inetSocketAddress == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindAddress");
        }
        String address = InetUtil.toUri(inetSocketAddress);
        this.vertx.eventBus().consumer(address, (Handler)new Handler<Message<JsonObject>>(this){
            final /* synthetic */ DefaultCommandResultProcessor this$0;

            public final void handle(@NotNull Message<JsonObject> msg) {
                ReplyMessage replyMessage;
                Intrinsics.checkNotNullParameter(msg, (String)"msg");
                ReplyMessage replyMessage2 = replyMessage = (ReplyMessage)((JsonObject)msg.body()).mapTo(ReplyMessage.class);
                Intrinsics.checkNotNullExpressionValue((Object)replyMessage2, (String)"replyMessage");
                DefaultCommandResultProcessor.access$processRequestInternal(this.this$0, replyMessage2);
                msg.reply((Object)new JsonObject().put("value", (Object)"success"));
            }
            {
                this.this$0 = defaultCommandResultProcessor;
            }
        });
        BridgeOptions bridgeOptions = new BridgeOptions();
        bridgeOptions.addInboundPermitted(new PermittedOptions().setAddress(address));
        bridgeOptions.addOutboundPermitted(new PermittedOptions().setAddress(address));
        TcpEventBusBridge tcpEventBusBridge = TcpEventBusBridge.create((Vertx)this.vertx, (BridgeOptions)bridgeOptions).listen(port, (Handler)new Handler<AsyncResult<TcpEventBusBridge>>(port){
            final /* synthetic */ int $port;

            public final void handle(@NotNull AsyncResult<TcpEventBusBridge> res) {
                Intrinsics.checkNotNullParameter(res, (String)"res");
                if (!res.succeeded()) {
                    DefaultCommandResultProcessor.access$getLogger$cp().error("vertx netServer start failed. port: {}", (Object)this.$port, (Object)res.cause());
                }
            }
            {
                this.$port = n;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)tcpEventBusBridge, (String)"TcpEventBusBridge.create\u2026)\n            }\n        }");
        this.tcpEventBusBridge = tcpEventBusBridge;
    }

    @Override
    public void registerProcessingCommand(@NotNull ICommand command, @NotNull CommandReturnType commandReturnType, @NotNull CompletableFuture<CommandResult> taskCompletionSource) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)commandReturnType), (String)"commandReturnType");
        Intrinsics.checkNotNullParameter(taskCompletionSource, (String)"taskCompletionSource");
        ConcurrentMap concurrentMap = this.commandTaskDict.asMap();
        String string = command.getId();
        String string2 = command.getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"command.aggregateRootId");
        if (concurrentMap.putIfAbsent(string, new CommandTaskCompletionSource(string2, commandReturnType, taskCompletionSource)) != null) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string3 = "Duplicate processing command registration, type:%s, id:%s";
            Object[] objectArray = new Object[]{command.getClass().getName(), command.getId()};
            boolean bl = false;
            String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new DuplicateCommandRegisterException(string4);
        }
    }

    public void start() {
        if (this.started) {
            return;
        }
        this.startServer(this.port);
        this.commandExecutedMessageWorker.start();
        this.domainEventHandledMessageWorker.start();
        this.scheduleService.startTask(this.scanExpireCommandTaskName, new Action(this){
            final /* synthetic */ DefaultCommandResultProcessor this$0;

            public final void apply() {
                DefaultCommandResultProcessor.access$getCommandTaskDict$p(this.this$0).cleanUp();
            }
            {
                this.this$0 = defaultCommandResultProcessor;
            }
        }, this.completionSourceTimeout, this.completionSourceTimeout);
        this.started = true;
    }

    public void stop() {
        this.scheduleService.stopTask(this.scanExpireCommandTaskName);
        this.commandExecutedMessageWorker.stop();
        this.domainEventHandledMessageWorker.stop();
        TcpEventBusBridge tcpEventBusBridge = this.tcpEventBusBridge;
        if (tcpEventBusBridge == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"tcpEventBusBridge");
        }
        tcpEventBusBridge.close();
    }

    @Override
    @NotNull
    public InetSocketAddress getBindAddress() {
        InetSocketAddress inetSocketAddress = this.bindAddress;
        if (inetSocketAddress == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bindAddress");
        }
        return inetSocketAddress;
    }

    private final void processRequestInternal(ReplyMessage reply) {
        if (reply.getCode() == CommandReturnType.CommandExecuted.getValue()) {
            CommandResult result = reply.getCommandResult();
            this.commandExecutedMessageLocalQueue.add(result);
        } else if (reply.getCode() == CommandReturnType.EventHandled.getValue()) {
            DomainEventHandledMessage message = reply.getEventHandledMessage();
            this.domainEventHandledMessageLocalQueue.add(message);
        }
    }

    private final void processExecutedCommandMessage(CommandResult commandResult) {
        CommandTaskCompletionSource commandTaskCompletionSource = (CommandTaskCompletionSource)this.commandTaskDict.asMap().get(commandResult.getCommandId());
        if (commandTaskCompletionSource == null) {
            Logger logger = DefaultCommandResultProcessor.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            if (logger.isDebugEnabled()) {
                DefaultCommandResultProcessor.logger.debug("Command result return, {}, but commandTaskCompletionSource maybe timeout expired.", (Object)this.serializeService.serialize(commandResult));
            }
            return;
        }
        if (commandTaskCompletionSource.getCommandReturnType() == CommandReturnType.CommandExecuted) {
            this.commandTaskDict.asMap().remove(commandResult.getCommandId());
            if (commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult)) {
                Logger logger = DefaultCommandResultProcessor.logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                if (logger.isDebugEnabled()) {
                    DefaultCommandResultProcessor.logger.debug("Command result return CommandExecuted, {}", (Object)this.serializeService.serialize(commandResult));
                }
            }
        } else if (commandTaskCompletionSource.getCommandReturnType() == CommandReturnType.EventHandled && (CommandStatus.Failed == commandResult.getStatus() || CommandStatus.NothingChanged == commandResult.getStatus())) {
            this.commandTaskDict.asMap().remove(commandResult.getCommandId());
            if (commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult)) {
                Logger logger = DefaultCommandResultProcessor.logger;
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                if (logger.isDebugEnabled()) {
                    DefaultCommandResultProcessor.logger.debug("Command result return EventHandled, {}", (Object)this.serializeService.serialize(commandResult));
                }
            }
        }
    }

    private final void processTimeoutCommand(String commandId, CommandTaskCompletionSource commandTaskCompletionSource) {
        if (commandTaskCompletionSource != null) {
            logger.error("Wait command notify timeout, commandId: {}", (Object)commandId);
            String string = commandTaskCompletionSource.getAggregateRootId();
            String string2 = String.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"String::class.java.name");
            CommandResult commandResult = new CommandResult(CommandStatus.Failed, commandId, string, "Wait command notify timeout.", string2);
            commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult);
        }
    }

    @Override
    public void processFailedSendingCommand(@NotNull ICommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        CommandTaskCompletionSource commandTaskCompletionSource = (CommandTaskCompletionSource)this.commandTaskDict.asMap().remove(command.getId());
        if (commandTaskCompletionSource != null) {
            String string = command.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"command.id");
            String string2 = command.getAggregateRootId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"command.aggregateRootId");
            String string3 = String.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
            CommandResult commandResult = new CommandResult(CommandStatus.Failed, string, string2, "Failed to send the command.", string3);
            commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult);
        }
    }

    private final void processDomainEventHandledMessage(DomainEventHandledMessage message) {
        CommandTaskCompletionSource commandTaskCompletionSource = (CommandTaskCompletionSource)this.commandTaskDict.asMap().get(message.getCommandId());
        if (commandTaskCompletionSource != null) {
            if (CommandReturnType.EventHandled != commandTaskCompletionSource.getCommandReturnType()) {
                logger.warn("event arrived early than command: {}", (Object)this.serializeService.serialize(message));
                return;
            }
            this.commandTaskDict.asMap().remove(message.getCommandId());
            String string = message.getCommandId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.commandId");
            String string2 = message.getAggregateRootId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.aggregateRootId");
            CommandResult commandResult = new CommandResult(CommandStatus.Success, string, string2, message.getCommandResult(), "");
            commandTaskCompletionSource.getTaskCompletionSource().complete(commandResult);
            Logger logger = DefaultCommandResultProcessor.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            if (logger.isDebugEnabled()) {
                DefaultCommandResultProcessor.logger.debug("DomainEvent result return, {}", (Object)this.serializeService.serialize(message));
            }
        }
    }

    public DefaultCommandResultProcessor(@NotNull IScheduleService scheduleService, @NotNull ISerializeService serializeService, int port, int completionSourceTimeout) {
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.scheduleService = scheduleService;
        this.serializeService = serializeService;
        this.port = port;
        this.completionSourceTimeout = completionSourceTimeout;
        this.scanExpireCommandTaskName = "CleanTimeoutCommandTask_" + SystemClock.now() + new Random().nextInt(10000);
        Cache cache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<String, CommandTaskCompletionSource>(){

            public final void onRemoval(@NotNull RemovalNotification<String, CommandTaskCompletionSource> notification) {
                Intrinsics.checkNotNullParameter(notification, (String)"notification");
                if (notification.getCause() == RemovalCause.EXPIRED) {
                    Object object = notification.getKey();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"notification.key");
                    this.processTimeoutCommand((String)object, (CommandTaskCompletionSource)notification.getValue());
                }
            }
        }).expireAfterWrite((long)this.completionSourceTimeout, TimeUnit.MILLISECONDS).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"CacheBuilder.newBuilder(\u2026nit.MILLISECONDS).build()");
        this.commandTaskDict = cache;
        this.commandExecutedMessageLocalQueue = new LinkedBlockingQueue();
        this.domainEventHandledMessageLocalQueue = new LinkedBlockingQueue();
        this.commandExecutedMessageWorker = new Worker("ProcessExecutedCommandMessage", new Action(){

            @Override
            public final void apply() {
                Object e = commandExecutedMessageLocalQueue.take();
                Intrinsics.checkNotNullExpressionValue(e, (String)"commandExecutedMessageLocalQueue.take()");
                this.processExecutedCommandMessage((CommandResult)e);
            }
        });
        this.domainEventHandledMessageWorker = new Worker("ProcessDomainEventHandledMessage", new Action(){

            @Override
            public final void apply() {
                Object e = domainEventHandledMessageLocalQueue.take();
                Intrinsics.checkNotNullExpressionValue(e, (String)"domainEventHandledMessageLocalQueue.take()");
                this.processDomainEventHandledMessage((DomainEventHandledMessage)e);
            }
        });
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DefaultCommandResultProcessor.class);
    }

    public static final /* synthetic */ void access$processRequestInternal(DefaultCommandResultProcessor $this, ReplyMessage reply) {
        $this.processRequestInternal(reply);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ Cache access$getCommandTaskDict$p(DefaultCommandResultProcessor $this) {
        return $this.commandTaskDict;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/queue/command/DefaultCommandResultProcessor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

