/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.command;

import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandReturnType;
import org.enodeframework.commanding.ICommand;
import org.enodeframework.commanding.ICommandService;
import org.enodeframework.common.io.ReplySocketAddress;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.common.utilities.Ensure;
import org.enodeframework.common.utilities.InetUtil;
import org.enodeframework.queue.ISendMessageService;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.command.CommandMessage;
import org.enodeframework.queue.command.DefaultCommandService;
import org.enodeframework.queue.command.ICommandResultProcessor;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00110\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/enodeframework/queue/command/DefaultCommandService;", "Lorg/enodeframework/commanding/ICommandService;", "topic", "", "tag", "commandResultProcessor", "Lorg/enodeframework/queue/command/ICommandResultProcessor;", "sendMessageService", "Lorg/enodeframework/queue/ISendMessageService;", "serializeService", "Lorg/enodeframework/common/serializing/ISerializeService;", "(Ljava/lang/String;Ljava/lang/String;Lorg/enodeframework/queue/command/ICommandResultProcessor;Lorg/enodeframework/queue/ISendMessageService;Lorg/enodeframework/common/serializing/ISerializeService;)V", "buildCommandMessage", "Lorg/enodeframework/queue/QueueMessage;", "command", "Lorg/enodeframework/commanding/ICommand;", "needReply", "", "execute", "Lorg/enodeframework/commanding/CommandResult;", "commandReturnType", "Lorg/enodeframework/commanding/CommandReturnType;", "executeAsync", "Ljava/util/concurrent/CompletableFuture;", "send", "sendAsync", "enode"})
public final class DefaultCommandService
implements ICommandService {
    private final String topic;
    private final String tag;
    private final ICommandResultProcessor commandResultProcessor;
    private final ISendMessageService sendMessageService;
    private final ISerializeService serializeService;

    @Override
    @NotNull
    public CompletableFuture<Boolean> sendAsync(@NotNull ICommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        CompletableFuture<Boolean> completableFuture = this.sendMessageService.sendMessageAsync(this.buildCommandMessage(command, false));
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"sendMessageService.sendM\u2026dMessage(command, false))");
        return completableFuture;
    }

    @Override
    public boolean send(@NotNull ICommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Boolean bl = this.sendAsync(command).join();
        Intrinsics.checkNotNullExpressionValue((Object)bl, (String)"this.sendAsync(command).join()");
        return bl;
    }

    @Override
    @NotNull
    public CompletableFuture<CommandResult> executeAsync(@NotNull ICommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        return this.executeAsync(command, CommandReturnType.CommandExecuted);
    }

    @Override
    @NotNull
    public CompletableFuture<CommandResult> executeAsync(@NotNull ICommand command, @NotNull CommandReturnType commandReturnType) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)commandReturnType), (String)"commandReturnType");
        CompletableFuture<CommandResult> taskCompletionSource = new CompletableFuture<CommandResult>();
        try {
            Ensure.notNull(this.commandResultProcessor, "commandResultProcessor");
            this.commandResultProcessor.registerProcessingCommand(command, commandReturnType, taskCompletionSource);
            CompletableFuture<Boolean> sendMessageAsync = this.sendMessageService.sendMessageAsync(this.buildCommandMessage(command, true));
            sendMessageAsync.exceptionally((Function)new Function<Throwable, Boolean>(this, command, taskCompletionSource){
                final /* synthetic */ DefaultCommandService this$0;
                final /* synthetic */ ICommand $command;
                final /* synthetic */ CompletableFuture $taskCompletionSource;

                public final Boolean apply(@NotNull Throwable ex) {
                    Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
                    DefaultCommandService.access$getCommandResultProcessor$p(this.this$0).processFailedSendingCommand(this.$command);
                    this.$taskCompletionSource.completeExceptionally(ex);
                    return null;
                }
                {
                    this.this$0 = defaultCommandService;
                    this.$command = iCommand;
                    this.$taskCompletionSource = completableFuture;
                }
            });
        }
        catch (Exception ex) {
            taskCompletionSource.completeExceptionally(ex);
        }
        return taskCompletionSource;
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull ICommand command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        CommandResult commandResult = this.executeAsync(command).join();
        Intrinsics.checkNotNullExpressionValue((Object)commandResult, (String)"this.executeAsync(command).join()");
        return commandResult;
    }

    @Override
    @NotNull
    public CommandResult execute(@NotNull ICommand command, @NotNull CommandReturnType commandReturnType) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)((Object)commandReturnType), (String)"commandReturnType");
        CommandResult commandResult = this.executeAsync(command, commandReturnType).join();
        Intrinsics.checkNotNullExpressionValue((Object)commandResult, (String)"this.executeAsync(comman\u2026commandReturnType).join()");
        return commandResult;
    }

    @NotNull
    protected final QueueMessage buildCommandMessage(@NotNull ICommand command, boolean needReply) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Ensure.notNull(command.getAggregateRootId(), "aggregateRootId");
        Ensure.notNull(this.topic, "topic");
        String commandData = this.serializeService.serialize(command);
        CommandMessage commandMessage = new CommandMessage();
        if (needReply) {
            ReplySocketAddress replyAddress = InetUtil.toSocketAddress(this.commandResultProcessor.getBindAddress());
            commandMessage.setReplyAddress(replyAddress);
        }
        commandMessage.setCommandData(commandData);
        commandMessage.setCommandType(command.getClass().getName());
        String messageData = this.serializeService.serialize(commandMessage);
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setTopic(this.topic);
        queueMessage.setTag(this.tag);
        queueMessage.setBody(messageData);
        queueMessage.setRouteKey(command.getAggregateRootId());
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s%s";
        Object[] objectArray = new Object[]{command.getId(), Optional.ofNullable(command.getAggregateRootId()).map(buildCommandMessage.key.1.INSTANCE).orElse("")};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String key2 = string2;
        queueMessage.setKey(key2);
        return queueMessage;
    }

    public DefaultCommandService(@NotNull String topic, @NotNull String tag, @NotNull ICommandResultProcessor commandResultProcessor, @NotNull ISendMessageService sendMessageService, @NotNull ISerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)topic, (String)"topic");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)commandResultProcessor, (String)"commandResultProcessor");
        Intrinsics.checkNotNullParameter((Object)sendMessageService, (String)"sendMessageService");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.topic = topic;
        this.tag = tag;
        this.commandResultProcessor = commandResultProcessor;
        this.sendMessageService = sendMessageService;
        this.serializeService = serializeService;
    }

    public static final /* synthetic */ ICommandResultProcessor access$getCommandResultProcessor$p(DefaultCommandService $this) {
        return $this.commandResultProcessor;
    }
}

