/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.domainevent;

import java.util.concurrent.CompletableFuture;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.common.utilities.Ensure;
import org.enodeframework.eventing.DomainEventStreamMessage;
import org.enodeframework.eventing.IEventSerializer;
import org.enodeframework.messaging.IMessagePublisher;
import org.enodeframework.queue.ISendMessageService;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.domainevent.EventStreamMessage;

public class DefaultDomainEventPublisher
implements IMessagePublisher<DomainEventStreamMessage> {
    private final String topic;
    private final String tag;
    private final IEventSerializer eventSerializer;
    private final ISendMessageService sendMessageService;
    private final ISerializeService serializeService;

    public DefaultDomainEventPublisher(String topic, String tag, IEventSerializer eventSerializer, ISendMessageService sendMessageService, ISerializeService serializeService) {
        this.eventSerializer = eventSerializer;
        this.sendMessageService = sendMessageService;
        this.topic = topic;
        this.tag = tag;
        this.serializeService = serializeService;
    }

    protected QueueMessage createDomainEventStreamMessage(DomainEventStreamMessage eventStream) {
        Ensure.notNull(eventStream.getAggregateRootId(), "aggregateRootId");
        Ensure.notNull(this.topic, "topic");
        EventStreamMessage message = new EventStreamMessage();
        message.setId(eventStream.getId());
        message.setCommandId(eventStream.getCommandId());
        message.setAggregateRootTypeName(eventStream.getAggregateRootTypeName());
        message.setAggregateRootId(eventStream.getAggregateRootId());
        message.setTimestamp(eventStream.getTimestamp());
        message.setVersion(eventStream.getVersion());
        message.setEvents(this.eventSerializer.serialize(eventStream.getEvents()));
        message.setItems(eventStream.getItems());
        String data = this.serializeService.serialize(message);
        String routeKey = message.getAggregateRootId();
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setTopic(this.topic);
        queueMessage.setTag(this.tag);
        queueMessage.setBody(data);
        queueMessage.setRouteKey(routeKey);
        queueMessage.setKey(String.format("%s_evt_agg_%s", message.getId(), message.getAggregateRootId()));
        return queueMessage;
    }

    @Override
    public CompletableFuture<Boolean> publishAsync(DomainEventStreamMessage message) {
        return this.sendMessageService.sendMessageAsync(this.createDomainEventStreamMessage(message));
    }
}

