/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding.impl;

import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.enodeframework.commanding.ICommandProcessor;
import org.enodeframework.commanding.IProcessingCommandHandler;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.ProcessingCommandMailbox;
import org.enodeframework.common.function.Action;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.scheduling.IScheduleService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\n\"\u0004\b\u0016\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/enodeframework/commanding/impl/DefaultCommandProcessor;", "Lorg/enodeframework/commanding/ICommandProcessor;", "processingCommandHandler", "Lorg/enodeframework/commanding/IProcessingCommandHandler;", "scheduleService", "Lorg/enodeframework/common/scheduling/IScheduleService;", "(Lorg/enodeframework/commanding/IProcessingCommandHandler;Lorg/enodeframework/common/scheduling/IScheduleService;)V", "aggregateRootMaxInactiveSeconds", "", "getAggregateRootMaxInactiveSeconds", "()I", "setAggregateRootMaxInactiveSeconds", "(I)V", "commandMailBoxPersistenceMaxBatchSize", "getCommandMailBoxPersistenceMaxBatchSize", "setCommandMailBoxPersistenceMaxBatchSize", "mailboxDict", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/enodeframework/commanding/ProcessingCommandMailbox;", "scanExpiredAggregateIntervalMilliseconds", "getScanExpiredAggregateIntervalMilliseconds", "setScanExpiredAggregateIntervalMilliseconds", "taskName", "cleanInactiveMailbox", "", "isMailBoxAllowRemove", "", "mailbox", "process", "processingCommand", "Lorg/enodeframework/commanding/ProcessingCommand;", "start", "stop", "Companion", "enode"})
public final class DefaultCommandProcessor
implements ICommandProcessor {
    private final ConcurrentMap<String, ProcessingCommandMailbox> mailboxDict;
    private final String taskName;
    private int aggregateRootMaxInactiveSeconds;
    private int commandMailBoxPersistenceMaxBatchSize;
    private int scanExpiredAggregateIntervalMilliseconds;
    private final IProcessingCommandHandler processingCommandHandler;
    private final IScheduleService scheduleService;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final int getAggregateRootMaxInactiveSeconds() {
        return this.aggregateRootMaxInactiveSeconds;
    }

    public final void setAggregateRootMaxInactiveSeconds(int n) {
        this.aggregateRootMaxInactiveSeconds = n;
    }

    public final int getCommandMailBoxPersistenceMaxBatchSize() {
        return this.commandMailBoxPersistenceMaxBatchSize;
    }

    public final void setCommandMailBoxPersistenceMaxBatchSize(int n) {
        this.commandMailBoxPersistenceMaxBatchSize = n;
    }

    public final int getScanExpiredAggregateIntervalMilliseconds() {
        return this.scanExpiredAggregateIntervalMilliseconds;
    }

    public final void setScanExpiredAggregateIntervalMilliseconds(int n) {
        this.scanExpiredAggregateIntervalMilliseconds = n;
    }

    @Override
    public void process(@NotNull ProcessingCommand processingCommand) {
        Intrinsics.checkNotNullParameter((Object)processingCommand, (String)"processingCommand");
        String aggregateRootId = processingCommand.getMessage().getAggregateRootId();
        boolean bl = !Strings.isNullOrEmpty((String)aggregateRootId);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "aggregateRootId of command cannot be null or empty, commandId: %s";
            Object[] objectArray = new Object[]{processingCommand.getMessage().getId()};
            boolean bl5 = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            String string3 = string2;
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        ProcessingCommandMailbox mailbox2 = this.mailboxDict.computeIfAbsent(aggregateRootId, new Function<String, ProcessingCommandMailbox>(this){
            final /* synthetic */ DefaultCommandProcessor this$0;

            public final ProcessingCommandMailbox apply(@NotNull String x) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                return new ProcessingCommandMailbox(x, DefaultCommandProcessor.access$getProcessingCommandHandler$p(this.this$0), this.this$0.getCommandMailBoxPersistenceMaxBatchSize());
            }
            {
                this.this$0 = defaultCommandProcessor;
            }
        });
        long mailboxTryUsingCount = 0L;
        while (!mailbox2.tryUsing()) {
            Task.sleep(1L);
            long l = mailboxTryUsingCount;
            if ((mailboxTryUsingCount = l + 1L) % (long)10000 != 0L) continue;
            logger.warn("Command mailbox try using count: {}, aggregateRootId: {}", (Object)mailboxTryUsingCount, (Object)mailbox2.getAggregateRootId());
        }
        if (mailbox2.isRemoved()) {
            mailbox2 = this.mailboxDict.computeIfAbsent(aggregateRootId, new Function<String, ProcessingCommandMailbox>(this){
                final /* synthetic */ DefaultCommandProcessor this$0;

                public final ProcessingCommandMailbox apply(@NotNull String x) {
                    Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                    return new ProcessingCommandMailbox(x, DefaultCommandProcessor.access$getProcessingCommandHandler$p(this.this$0), this.this$0.getCommandMailBoxPersistenceMaxBatchSize());
                }
                {
                    this.this$0 = defaultCommandProcessor;
                }
            });
        }
        mailbox2.enqueueMessage(processingCommand);
        mailbox2.exitUsing();
    }

    @Override
    public void start() {
        this.scheduleService.startTask(this.taskName, new Action(this){
            final /* synthetic */ DefaultCommandProcessor this$0;

            public final void apply() {
                DefaultCommandProcessor.access$cleanInactiveMailbox(this.this$0);
            }
            {
                this.this$0 = defaultCommandProcessor;
            }
        }, this.scanExpiredAggregateIntervalMilliseconds, this.scanExpiredAggregateIntervalMilliseconds);
    }

    @Override
    public void stop() {
        this.scheduleService.stopTask(this.taskName);
    }

    private final boolean isMailBoxAllowRemove(ProcessingCommandMailbox mailbox2) {
        return mailbox2.isInactive(this.aggregateRootMaxInactiveSeconds) && !mailbox2.isRunning() && mailbox2.getTotalUnHandledMessageCount() == 0L;
    }

    private final void cleanInactiveMailbox() {
        List list = this.mailboxDict.entrySet().stream().filter((Predicate)new Predicate<Map.Entry<String, ProcessingCommandMailbox>>(this){
            final /* synthetic */ DefaultCommandProcessor this$0;

            public final boolean test(@NotNull Map.Entry<String, ProcessingCommandMailbox> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                return DefaultCommandProcessor.access$isMailBoxAllowRemove(this.this$0, entry.getValue());
            }
            {
                this.this$0 = defaultCommandProcessor;
            }
        }).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"mailboxDict.entries.stre\u2026lect(Collectors.toList())");
        List inactiveList2 = list;
        inactiveList2.forEach(new Consumer<Map.Entry<? extends String, ? extends ProcessingCommandMailbox>>(this){
            final /* synthetic */ DefaultCommandProcessor this$0;

            public final void accept(@NotNull Map.Entry<String, ProcessingCommandMailbox> entry) {
                ProcessingCommandMailbox removed;
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                if (DefaultCommandProcessor.access$isMailBoxAllowRemove(this.this$0, entry.getValue()) && (removed = (ProcessingCommandMailbox)DefaultCommandProcessor.access$getMailboxDict$p(this.this$0).remove(entry.getKey())) != null) {
                    removed.markAsRemoved();
                    DefaultCommandProcessor.access$getLogger$cp().info("Removed inactive command mailbox, aggregateRootId: {}", (Object)entry.getKey());
                }
            }
            {
                this.this$0 = defaultCommandProcessor;
            }
        });
    }

    public DefaultCommandProcessor(@NotNull IProcessingCommandHandler processingCommandHandler, @NotNull IScheduleService scheduleService) {
        Intrinsics.checkNotNullParameter((Object)processingCommandHandler, (String)"processingCommandHandler");
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        this.processingCommandHandler = processingCommandHandler;
        this.scheduleService = scheduleService;
        this.aggregateRootMaxInactiveSeconds = 259200;
        this.commandMailBoxPersistenceMaxBatchSize = 1000;
        this.scanExpiredAggregateIntervalMilliseconds = 5000;
        this.mailboxDict = new ConcurrentHashMap();
        this.taskName = "CleanInactiveProcessingCommandMailBoxes_" + System.nanoTime() + new Random().nextInt(10000);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DefaultCommandProcessor.class);
    }

    public static final /* synthetic */ IProcessingCommandHandler access$getProcessingCommandHandler$p(DefaultCommandProcessor $this) {
        return $this.processingCommandHandler;
    }

    public static final /* synthetic */ void access$cleanInactiveMailbox(DefaultCommandProcessor $this) {
        $this.cleanInactiveMailbox();
    }

    public static final /* synthetic */ boolean access$isMailBoxAllowRemove(DefaultCommandProcessor $this, ProcessingCommandMailbox mailbox2) {
        return $this.isMailBoxAllowRemove(mailbox2);
    }

    public static final /* synthetic */ ConcurrentMap access$getMailboxDict$p(DefaultCommandProcessor $this) {
        return $this.mailboxDict;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/commanding/impl/DefaultCommandProcessor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

