/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.serializing;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import org.enodeframework.common.exception.EnodeRuntimeException;
import org.enodeframework.common.serializing.ISerializeService;

public class DefaultSerializeService
implements ISerializeService {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Override
    public <T> T deserialize(String json, Class<T> type) {
        try {
            return (T)MAPPER.readValue(json, type);
        }
        catch (JsonProcessingException e) {
            throw new EnodeRuntimeException(e);
        }
    }

    @Override
    public String serialize(Object target) {
        try {
            return MAPPER.writeValueAsString(target);
        }
        catch (JsonProcessingException e) {
            throw new EnodeRuntimeException(e);
        }
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        MAPPER.configure(MapperFeature.AUTO_DETECT_FIELDS, true);
    }
}

