/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain;

import java.util.Date;
import org.enodeframework.common.utilities.SystemClock;
import org.enodeframework.domain.IAggregateRoot;

public class AggregateCacheInfo {
    private IAggregateRoot aggregateRoot;
    private Date lastUpdateTime;

    public AggregateCacheInfo(IAggregateRoot aggregateRoot) {
        this.aggregateRoot = aggregateRoot;
        this.lastUpdateTime = new Date();
    }

    public void updateAggregateRoot(IAggregateRoot aggregateRoot) {
        this.aggregateRoot = aggregateRoot;
        this.lastUpdateTime = new Date();
    }

    public boolean isExpired(int timeoutSeconds) {
        return (SystemClock.now() - this.lastUpdateTime.getTime()) / 1000L >= (long)timeoutSeconds;
    }

    public IAggregateRoot getAggregateRoot() {
        return this.aggregateRoot;
    }

    public void setAggregateRoot(IAggregateRoot aggregateRoot) {
        this.aggregateRoot = aggregateRoot;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }
}

