/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.enodeframework.common.container.ObjectContainer;
import org.enodeframework.common.exception.HandlerNotFoundException;
import org.enodeframework.common.function.Action2;
import org.enodeframework.common.utilities.Ensure;
import org.enodeframework.domain.IAggregateRoot;
import org.enodeframework.domain.IAggregateRootInternalHandlerProvider;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.IDomainEvent;

public abstract class AggregateRoot<TAggregateRootId>
implements IAggregateRoot {
    private final IAggregateRootInternalHandlerProvider aggregateRootInternalHandlerProvider;
    protected TAggregateRootId id;
    protected int version;
    private final List<IDomainEvent<?>> emptyEvents = new ArrayList();
    private Queue<IDomainEvent<?>> uncommittedEvents = new ConcurrentLinkedQueue();

    protected AggregateRoot() {
        this.aggregateRootInternalHandlerProvider = ObjectContainer.resolve(IAggregateRootInternalHandlerProvider.class);
    }

    protected AggregateRoot(TAggregateRootId id) {
        this(id, 0);
    }

    protected AggregateRoot(TAggregateRootId id, int version) {
        this();
        Ensure.notNull(id, "id");
        this.id = id;
        if (version < 0) {
            throw new IllegalArgumentException(String.format("Version cannot small than zero, aggregateRootId: %s, version: %d", id, version));
        }
        this.version = version;
    }

    public TAggregateRootId getId() {
        return this.id;
    }

    protected void applyEvent(IDomainEvent<TAggregateRootId> domainEvent) {
        Ensure.notNull(domainEvent, "domainEvent");
        Ensure.notNull(this.id, "AggregateRootId");
        domainEvent.setAggregateRootId(this.id);
        domainEvent.setVersion(this.version + 1);
        this.handleEvent(domainEvent);
        this.appendUncommittedEvent(domainEvent);
    }

    protected void applyEvents(List<IDomainEvent<TAggregateRootId>> domainEvents) {
        for (IDomainEvent<TAggregateRootId> domainEvent : domainEvents) {
            this.applyEvent(domainEvent);
        }
    }

    private void handleEvent(IDomainEvent<?> domainEvent) {
        Action2<IAggregateRoot, IDomainEvent<?>> handler = this.aggregateRootInternalHandlerProvider.getInternalEventHandler(this.getClass(), domainEvent.getClass());
        if (handler == null) {
            throw new HandlerNotFoundException(String.format("Could not find event handler for [%s] of [%s]", domainEvent.getClass().getName(), this.getClass().getName()));
        }
        if (this.id == null && domainEvent.getVersion() == 1) {
            this.id = domainEvent.getAggregateRootId();
        }
        handler.apply(this, domainEvent);
    }

    private void appendUncommittedEvent(IDomainEvent<TAggregateRootId> domainEvent) {
        if (this.uncommittedEvents == null) {
            this.uncommittedEvents = new ConcurrentLinkedQueue();
        }
        if (this.uncommittedEvents.stream().anyMatch(x -> x.getClass().equals(domainEvent.getClass()))) {
            throw new UnsupportedOperationException(String.format("Cannot apply duplicated domain event type: %s, current aggregateRoot type: %s, id: %s", domainEvent.getClass(), this.getClass().getName(), this.id));
        }
        this.uncommittedEvents.add(domainEvent);
    }

    private void verifyEvent(DomainEventStream eventStream) {
        if (eventStream.getVersion() > 1 && !eventStream.getAggregateRootId().equals(this.getUniqueId())) {
            throw new UnsupportedOperationException(String.format("Invalid domain event stream, aggregateRootId:%s, expected aggregateRootId:%s, type:%s", eventStream.getAggregateRootId(), this.getUniqueId(), this.getClass().getName()));
        }
        if (eventStream.getVersion() != this.getVersion() + 1) {
            throw new UnsupportedOperationException(String.format("Invalid domain event stream, version:%d, expected version:%d, current aggregateRoot type:%s, id:%s", eventStream.getVersion(), this.getVersion(), this.getClass().getName(), this.getUniqueId()));
        }
    }

    @Override
    public String getUniqueId() {
        return this.id.toString();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public List<IDomainEvent<?>> getChanges() {
        if (this.uncommittedEvents == null) {
            return this.emptyEvents;
        }
        return Lists.newArrayList(this.uncommittedEvents);
    }

    @Override
    public void acceptChanges() {
        if (this.uncommittedEvents != null && !this.uncommittedEvents.isEmpty()) {
            this.version = this.uncommittedEvents.peek().getVersion();
            this.uncommittedEvents.clear();
        }
    }

    @Override
    public void replayEvents(List<DomainEventStream> eventStreams) {
        if (eventStreams == null) {
            return;
        }
        eventStreams.forEach(eventStream -> {
            this.verifyEvent((DomainEventStream)eventStream);
            eventStream.events().forEach(this::handleEvent);
            this.version = eventStream.getVersion();
        });
    }
}

