/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.enodeframework.common.utilities.IdGenerator;
import org.enodeframework.domain.IDomainException;

public abstract class DomainException
extends RuntimeException
implements IDomainException {
    private static final long serialVersionUID = 2099914413380872726L;
    private String id;
    private Date timestamp;
    private Map<String, Object> items;

    public DomainException() {
        this(IdGenerator.nextId());
    }

    public DomainException(String id) {
        this.id = id;
        this.timestamp = new Date();
        this.items = new HashMap<String, Object>();
    }

    @Override
    public abstract void serializeTo(Map<String, Object> var1);

    @Override
    public abstract void restoreFrom(Map<String, Object> var1);

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public Date getTimestamp() {
        return this.timestamp;
    }

    @Override
    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public Map<String, Object> getItems() {
        return this.items;
    }

    @Override
    public void setItems(Map<String, Object> items) {
        this.items = items;
    }

    @Override
    public void mergeItems(Map<String, Object> mitems) {
        if (mitems == null || mitems.size() == 0) {
            return;
        }
        if (this.items == null) {
            this.items = new HashMap<String, Object>();
        }
        for (Map.Entry<String, Object> entry : mitems.entrySet()) {
            if (this.items.containsKey(entry.getKey())) continue;
            this.items.put(entry.getKey(), entry.getValue());
        }
    }
}

