/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.enodeframework.common.exception.AggregateRootTypeNotMatchException;
import org.enodeframework.common.function.Action;
import org.enodeframework.common.scheduling.IScheduleService;
import org.enodeframework.common.utilities.Ensure;
import org.enodeframework.domain.AggregateCacheInfo;
import org.enodeframework.domain.AggregateRootReferenceChangedException;
import org.enodeframework.domain.IAggregateRoot;
import org.enodeframework.domain.IAggregateStorage;
import org.enodeframework.domain.IMemoryCache;
import org.enodeframework.infrastructure.ITypeNameProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u0019\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\u001bH\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!2\u0006\u0010\"\u001a\u00020\u000eH\u0016J.\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001b0!\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001b0$H\u0016J\u001f\u0010%\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\u001bH\u0016\u00a2\u0006\u0002\u0010\u001eJ.\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u001b0!\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001b0$2\u0006\u0010\"\u001a\u00020\u000bH\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0!2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0016J$\u0010(\u001a\u00020\u001a2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010)\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u001aH\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/enodeframework/domain/impl/DefaultMemoryCache;", "Lorg/enodeframework/domain/IMemoryCache;", "aggregateStorage", "Lorg/enodeframework/domain/IAggregateStorage;", "scheduleService", "Lorg/enodeframework/common/scheduling/IScheduleService;", "typeNameProvider", "Lorg/enodeframework/infrastructure/ITypeNameProvider;", "(Lorg/enodeframework/domain/IAggregateStorage;Lorg/enodeframework/common/scheduling/IScheduleService;Lorg/enodeframework/infrastructure/ITypeNameProvider;)V", "aggregateRootInfoDict", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/enodeframework/domain/AggregateCacheInfo;", "lockObj", "", "scanExpiredAggregateIntervalMilliseconds", "", "getScanExpiredAggregateIntervalMilliseconds", "()I", "setScanExpiredAggregateIntervalMilliseconds", "(I)V", "taskName", "timeoutSeconds", "getTimeoutSeconds", "setTimeoutSeconds", "acceptAggregateRootChanges", "", "T", "Lorg/enodeframework/domain/IAggregateRoot;", "aggregateRoot", "(Lorg/enodeframework/domain/IAggregateRoot;)V", "cleanInactiveAggregateRoot", "getAsync", "Ljava/util/concurrent/CompletableFuture;", "aggregateRootId", "aggregateRootType", "Ljava/lang/Class;", "refreshAggregate", "refreshAggregateFromEventStoreAsync", "aggregateRootTypeName", "resetAggregateRootCache", "start", "stop", "Companion", "enode"})
public final class DefaultMemoryCache
implements IMemoryCache {
    private final ConcurrentMap<String, AggregateCacheInfo> aggregateRootInfoDict;
    private final Object lockObj;
    private final String taskName;
    private int timeoutSeconds;
    private int scanExpiredAggregateIntervalMilliseconds;
    private final IAggregateStorage aggregateStorage;
    private final IScheduleService scheduleService;
    private final ITypeNameProvider typeNameProvider;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public final int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public final void setTimeoutSeconds(int n) {
        this.timeoutSeconds = n;
    }

    public final int getScanExpiredAggregateIntervalMilliseconds() {
        return this.scanExpiredAggregateIntervalMilliseconds;
    }

    public final void setScanExpiredAggregateIntervalMilliseconds(int n) {
        this.scanExpiredAggregateIntervalMilliseconds = n;
    }

    @Override
    @NotNull
    public <T extends IAggregateRoot> CompletableFuture<T> getAsync(@NotNull Object aggregateRootId, @NotNull Class<T> aggregateRootType) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Ensure.notNull(aggregateRootId, "aggregateRootId");
        Ensure.notNull(aggregateRootType, "aggregateRootType");
        CompletableFuture<IAggregateRoot> future = new CompletableFuture<IAggregateRoot>();
        AggregateCacheInfo aggregateRootInfo = (AggregateCacheInfo)this.aggregateRootInfoDict.get(aggregateRootId.toString());
        if (aggregateRootInfo == null) {
            future.complete(null);
            return future;
        }
        IAggregateRoot iAggregateRoot = aggregateRootInfo.getAggregateRoot();
        if (iAggregateRoot == null) {
            throw new NullPointerException("null cannot be cast to non-null type T");
        }
        IAggregateRoot aggregateRoot = iAggregateRoot;
        if (Intrinsics.areEqual(aggregateRootInfo.getAggregateRoot().getClass(), aggregateRootType) ^ true) {
            StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
            String string = "Incorrect aggregate root type, aggregateRootId:%s, type:%s, expecting type:%s";
            Object[] objectArray = new Object[]{aggregateRootId, aggregateRootInfo.getAggregateRoot().getClass(), aggregateRootType};
            boolean bl = false;
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
            throw (Throwable)new AggregateRootTypeNotMatchException(string2);
        }
        if (aggregateRoot.getChanges().size() > 0) {
            CompletableFuture<T> latestAggregateRootFuture = this.aggregateStorage.getAsync(aggregateRootType, aggregateRootId.toString());
            CompletionStage completionStage = latestAggregateRootFuture.thenApply(new Function<IAggregateRoot, T>(this, aggregateRootType, aggregateRootId){
                final /* synthetic */ DefaultMemoryCache this$0;
                final /* synthetic */ Class $aggregateRootType;
                final /* synthetic */ Object $aggregateRootId;

                public final T apply(@NotNull IAggregateRoot latestAggregateRoot) {
                    Intrinsics.checkNotNullParameter((Object)latestAggregateRoot, (String)"latestAggregateRoot");
                    DefaultMemoryCache.access$resetAggregateRootCache(this.this$0, this.$aggregateRootType, this.$aggregateRootId.toString(), latestAggregateRoot);
                    return (T)latestAggregateRoot;
                }
                {
                    this.this$0 = defaultMemoryCache;
                    this.$aggregateRootType = clazz;
                    this.$aggregateRootId = object;
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"latestAggregateRootFutur\u2026teRoot as T\n            }");
            return completionStage;
        }
        future.complete(aggregateRoot);
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<IAggregateRoot> getAsync(@NotNull Object aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        return this.getAsync(aggregateRootId, IAggregateRoot.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends IAggregateRoot> void acceptAggregateRootChanges(@NotNull T aggregateRoot) {
        Intrinsics.checkNotNullParameter(aggregateRoot, (String)"aggregateRoot");
        Object object = this.lockObj;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            AtomicBoolean cacheReset = new AtomicBoolean(false);
            AggregateCacheInfo cacheInfo = this.aggregateRootInfoDict.computeIfAbsent(aggregateRoot.getUniqueId(), new Function<String, AggregateCacheInfo>(cacheReset, this, aggregateRoot){
                final /* synthetic */ AtomicBoolean $cacheReset;
                final /* synthetic */ DefaultMemoryCache this$0;
                final /* synthetic */ IAggregateRoot $aggregateRoot$inlined;
                {
                    this.$cacheReset = atomicBoolean;
                    this.this$0 = defaultMemoryCache;
                    this.$aggregateRoot$inlined = iAggregateRoot;
                }

                public final AggregateCacheInfo apply(String it) {
                    this.$aggregateRoot$inlined.acceptChanges();
                    this.$cacheReset.set(true);
                    DefaultMemoryCache.access$getLogger$cp().info("Aggregate root in-memory cache initialized, aggregateRootType: {}, aggregateRootId: {}, aggregateRootVersion: {}", new Object[]{this.$aggregateRoot$inlined.getClass().getName(), this.$aggregateRoot$inlined.getUniqueId(), this.$aggregateRoot$inlined.getVersion()});
                    return new AggregateCacheInfo(this.$aggregateRoot$inlined);
                }
            });
            if (cacheReset.get()) {
                return;
            }
            AggregateCacheInfo aggregateCacheInfo = cacheInfo;
            Intrinsics.checkNotNull((Object)aggregateCacheInfo);
            IAggregateRoot iAggregateRoot = aggregateCacheInfo.getAggregateRoot();
            Intrinsics.checkNotNullExpressionValue((Object)iAggregateRoot, (String)"cacheInfo!!.aggregateRoot");
            int aggregateRootOldVersion = iAggregateRoot.getVersion();
            if (aggregateRoot.getVersion() > 1 && cacheInfo.getAggregateRoot() != aggregateRoot) {
                throw (Throwable)new AggregateRootReferenceChangedException(aggregateRoot);
            }
            aggregateRoot.acceptChanges();
            cacheInfo.updateAggregateRoot(aggregateRoot);
            logger.info("Aggregate root in-memory cache changed, aggregateRootType: {}, aggregateRootId: {}, aggregateRootNewVersion: {}, aggregateRootOldVersion: {}", new Object[]{aggregateRoot.getClass().getName(), aggregateRoot.getUniqueId(), aggregateRoot.getVersion(), aggregateRootOldVersion});
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public <T extends IAggregateRoot> void refreshAggregate(@NotNull T aggregateRoot) {
        Intrinsics.checkNotNullParameter(aggregateRoot, (String)"aggregateRoot");
        Class<?> clazz = aggregateRoot.getClass();
        String string = aggregateRoot.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aggregateRoot.uniqueId");
        this.resetAggregateRootCache(clazz, string, aggregateRoot);
    }

    @Override
    @NotNull
    public CompletableFuture<IAggregateRoot> refreshAggregateFromEventStoreAsync(@NotNull String aggregateRootTypeName, @NotNull String aggregateRootId) {
        CompletableFuture<IAggregateRoot> completableFuture;
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Ensure.notNull(aggregateRootTypeName, "aggregateRootTypeName");
        CompletableFuture<IAggregateRoot> future = new CompletableFuture<IAggregateRoot>();
        try {
            Class<?> clazz = this.typeNameProvider.getType(aggregateRootTypeName);
            if (clazz == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Class<org.enodeframework.domain.IAggregateRoot>");
            }
            Class<?> aggregateRootType = clazz;
            completableFuture = this.refreshAggregateFromEventStoreAsync(aggregateRootType, aggregateRootId);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            completableFuture = future;
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public <T extends IAggregateRoot> CompletableFuture<T> refreshAggregateFromEventStoreAsync(@NotNull Class<T> aggregateRootType, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Ensure.notNull(aggregateRootId, "aggregateRootId");
        Ensure.notNull(aggregateRootType, "aggregateRootType");
        CompletionStage completionStage = ((CompletableFuture)this.aggregateStorage.getAsync(aggregateRootType, aggregateRootId).thenApply(new Function<T, T>(this, aggregateRootType, aggregateRootId){
            final /* synthetic */ DefaultMemoryCache this$0;
            final /* synthetic */ Class $aggregateRootType;
            final /* synthetic */ String $aggregateRootId;

            public final T apply(@NotNull T aggregateRoot) {
                Intrinsics.checkNotNullParameter(aggregateRoot, (String)"aggregateRoot");
                DefaultMemoryCache.access$resetAggregateRootCache(this.this$0, this.$aggregateRootType, this.$aggregateRootId, aggregateRoot);
                return aggregateRoot;
            }
            {
                this.this$0 = defaultMemoryCache;
                this.$aggregateRootType = clazz;
                this.$aggregateRootId = string;
            }
        })).exceptionally(new Function<Throwable, T>(this, aggregateRootType, aggregateRootId){
            final /* synthetic */ DefaultMemoryCache this$0;
            final /* synthetic */ Class $aggregateRootType;
            final /* synthetic */ String $aggregateRootId;

            public final T apply(@Nullable Throwable ex) {
                DefaultMemoryCache.access$getLogger$cp().error("Refresh aggregate from event store has unknown exception, aggregateRootTypeName:{}, aggregateRootId:{}", new Object[]{DefaultMemoryCache.access$getTypeNameProvider$p(this.this$0).getTypeName(this.$aggregateRootType), this.$aggregateRootId, ex});
                return null;
            }
            {
                this.this$0 = defaultMemoryCache;
                this.$aggregateRootType = clazz;
                this.$aggregateRootId = string;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"aggregateStorage.getAsyn\u2026           null\n        }");
        return completionStage;
    }

    @Override
    public void start() {
        this.scheduleService.startTask(this.taskName, new Action(this){
            final /* synthetic */ DefaultMemoryCache this$0;

            public final void apply() {
                DefaultMemoryCache.access$cleanInactiveAggregateRoot(this.this$0);
            }
            {
                this.this$0 = defaultMemoryCache;
            }
        }, this.scanExpiredAggregateIntervalMilliseconds, this.scanExpiredAggregateIntervalMilliseconds);
    }

    @Override
    public void stop() {
        this.scheduleService.stopTask(this.taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetAggregateRootCache(Class<?> aggregateRootType, String aggregateRootId, IAggregateRoot aggregateRoot) {
        AggregateCacheInfo aggregateCacheInfo = (AggregateCacheInfo)this.aggregateRootInfoDict.remove(aggregateRootId);
        if (aggregateCacheInfo != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = aggregateRootType.getName();
            objectArray[1] = aggregateRootId;
            IAggregateRoot iAggregateRoot = aggregateCacheInfo.getAggregateRoot();
            Intrinsics.checkNotNullExpressionValue((Object)iAggregateRoot, (String)"aggregateCacheInfo.aggregateRoot");
            objectArray[2] = iAggregateRoot.getVersion();
            logger.info("Removed dirty in-memory aggregate, aggregateRootType: {}, aggregateRootId: {}, version: {}", objectArray);
        }
        Object object = this.lockObj;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            boolean bl3 = false;
            AtomicBoolean cacheReset = new AtomicBoolean(false);
            AggregateCacheInfo cacheInfo = this.aggregateRootInfoDict.computeIfAbsent(aggregateRoot.getUniqueId(), new Function<String, AggregateCacheInfo>(cacheReset, this, aggregateRoot){
                final /* synthetic */ AtomicBoolean $cacheReset;
                final /* synthetic */ DefaultMemoryCache this$0;
                final /* synthetic */ IAggregateRoot $aggregateRoot$inlined;
                {
                    this.$cacheReset = atomicBoolean;
                    this.this$0 = defaultMemoryCache;
                    this.$aggregateRoot$inlined = iAggregateRoot;
                }

                public final AggregateCacheInfo apply(String it) {
                    Logger logger = DefaultMemoryCache.access$getLogger$cp();
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
                    if (logger.isDebugEnabled()) {
                        DefaultMemoryCache.access$getLogger$cp().debug("Aggregate root in-memory cache reset, aggregateRootType: {}, aggregateRootId: {}, aggregateRootVersion: {}", new Object[]{this.$aggregateRoot$inlined.getClass().getName(), this.$aggregateRoot$inlined.getUniqueId(), this.$aggregateRoot$inlined.getVersion()});
                    }
                    this.$cacheReset.set(true);
                    return new AggregateCacheInfo(this.$aggregateRoot$inlined);
                }
            });
            if (cacheReset.get()) {
                return;
            }
            AggregateCacheInfo aggregateCacheInfo2 = cacheInfo;
            Intrinsics.checkNotNull((Object)aggregateCacheInfo2);
            IAggregateRoot iAggregateRoot = aggregateCacheInfo2.getAggregateRoot();
            Intrinsics.checkNotNullExpressionValue((Object)iAggregateRoot, (String)"cacheInfo!!.aggregateRoot");
            int aggregateRootOldVersion = iAggregateRoot.getVersion();
            cacheInfo.updateAggregateRoot(aggregateRoot);
            Logger logger = DefaultMemoryCache.logger;
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"logger");
            if (logger.isDebugEnabled()) {
                DefaultMemoryCache.logger.debug("Aggregate root in-memory cache reset, aggregateRootType: {}, aggregateRootId: {}, aggregateRootNewVersion: {}, aggregateRootOldVersion: {}", new Object[]{aggregateRoot.getClass().getName(), aggregateRoot.getUniqueId(), aggregateRoot.getVersion(), aggregateRootOldVersion});
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void cleanInactiveAggregateRoot() {
        List list = this.aggregateRootInfoDict.entrySet().stream().filter((Predicate)new Predicate<Map.Entry<String, AggregateCacheInfo>>(this){
            final /* synthetic */ DefaultMemoryCache this$0;

            public final boolean test(@NotNull Map.Entry<String, ? extends AggregateCacheInfo> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                AggregateCacheInfo aggregateCacheInfo = entry.getValue();
                Intrinsics.checkNotNull((Object)aggregateCacheInfo);
                return aggregateCacheInfo.isExpired(this.this$0.getTimeoutSeconds());
            }
            {
                this.this$0 = defaultMemoryCache;
            }
        }).collect(Collectors.toList());
        Intrinsics.checkNotNullExpressionValue(list, (String)"aggregateRootInfoDict.en\u2026lect(Collectors.toList())");
        List inactiveList2 = list;
        inactiveList2.forEach(new Consumer<Map.Entry<? extends String, ? extends AggregateCacheInfo>>(this){
            final /* synthetic */ DefaultMemoryCache this$0;

            public final void accept(@NotNull Map.Entry<String, ? extends AggregateCacheInfo> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                if (DefaultMemoryCache.access$getAggregateRootInfoDict$p(this.this$0).remove(entry.getKey()) != null) {
                    DefaultMemoryCache.access$getLogger$cp().info("Removed inactive aggregate root, id: {}", (Object)entry.getKey());
                }
            }
            {
                this.this$0 = defaultMemoryCache;
            }
        });
    }

    public DefaultMemoryCache(@NotNull IAggregateStorage aggregateStorage, @NotNull IScheduleService scheduleService, @NotNull ITypeNameProvider typeNameProvider) {
        Intrinsics.checkNotNullParameter((Object)aggregateStorage, (String)"aggregateStorage");
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        this.aggregateStorage = aggregateStorage;
        this.scheduleService = scheduleService;
        this.typeNameProvider = typeNameProvider;
        this.lockObj = new Object();
        this.timeoutSeconds = 5000;
        this.scanExpiredAggregateIntervalMilliseconds = 5000;
        this.aggregateRootInfoDict = new ConcurrentHashMap();
        this.taskName = "CleanInactiveAggregates_" + System.nanoTime() + new Random().nextInt(10000);
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DefaultMemoryCache.class);
    }

    public static final /* synthetic */ void access$resetAggregateRootCache(DefaultMemoryCache $this, Class aggregateRootType, String aggregateRootId, IAggregateRoot aggregateRoot) {
        $this.resetAggregateRootCache(aggregateRootType, aggregateRootId, aggregateRoot);
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    public static final /* synthetic */ ITypeNameProvider access$getTypeNameProvider$p(DefaultMemoryCache $this) {
        return $this.typeNameProvider;
    }

    public static final /* synthetic */ void access$cleanInactiveAggregateRoot(DefaultMemoryCache $this) {
        $this.cleanInactiveAggregateRoot();
    }

    public static final /* synthetic */ ConcurrentMap access$getAggregateRootInfoDict$p(DefaultMemoryCache $this) {
        return $this.aggregateRootInfoDict;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/domain/impl/DefaultMemoryCache$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

