/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing.impl;

import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.eventing.IDomainEvent;
import org.enodeframework.eventing.IEventSerializer;
import org.enodeframework.infrastructure.ITypeNameProvider;

public class DefaultEventSerializer
implements IEventSerializer {
    private final ITypeNameProvider typeNameProvider;
    private final ISerializeService serializeService;

    public DefaultEventSerializer(ITypeNameProvider typeNameProvider, ISerializeService serializeService) {
        this.typeNameProvider = typeNameProvider;
        this.serializeService = serializeService;
    }

    @Override
    public Map<String, String> serialize(List<IDomainEvent<?>> evnts) {
        LinkedHashMap dict = Maps.newLinkedHashMap();
        evnts.forEach(evnt -> {
            String typeName = this.typeNameProvider.getTypeName(evnt.getClass());
            String eventData = this.serializeService.serialize(evnt);
            dict.put(typeName, eventData);
        });
        return dict;
    }

    @Override
    public List<IDomainEvent<?>> deserialize(Map<String, String> data) {
        ArrayList evnts = new ArrayList();
        data.forEach((key2, value) -> {
            Class<?> eventType = this.typeNameProvider.getType((String)key2);
            IDomainEvent evnt = (IDomainEvent)this.serializeService.deserialize((String)value, eventType);
            evnts.add(evnt);
        });
        return evnts;
    }
}

