/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.enodeframework.eventing.IPublishedVersionStore;

public class InMemoryPublishedVersionStore
implements IPublishedVersionStore {
    private final ConcurrentMap<String, Integer> versionDict = new ConcurrentHashMap<String, Integer>();

    @Override
    public CompletableFuture<Integer> updatePublishedVersionAsync(String processorName, String aggregateRootTypeName, String aggregateRootId, int publishedVersion) {
        this.versionDict.put(this.buildKey(processorName, aggregateRootId), publishedVersion);
        return CompletableFuture.completedFuture(1);
    }

    @Override
    public CompletableFuture<Integer> getPublishedVersionAsync(String processorName, String aggregateRootTypeName, String aggregateRootId) {
        int publishedVersion = this.versionDict.getOrDefault(this.buildKey(processorName, aggregateRootId), 0);
        return CompletableFuture.completedFuture(publishedVersion);
    }

    private String buildKey(String eventProcessorName, String aggregateRootId) {
        return String.format("%s-%s", eventProcessorName, aggregateRootId);
    }
}

