/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.infrastructure.impl;

import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;

public class ManyType {
    private final List<Class<?>> types;

    public ManyType(List<Class<?>> types) {
        if (new HashSet(types).size() != types.size()) {
            throw new IllegalArgumentException(String.format("Invalid ManyType: %s", types.stream().map(Class::getName).collect(Collectors.joining("|"))));
        }
        this.types = types;
    }

    public List<Class<?>> getTypes() {
        return this.types;
    }

    public int hashCode() {
        return this.types.stream().map(Object::hashCode).reduce((x, y) -> x ^ y).orElse(1);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ManyType)) {
            return false;
        }
        ManyType other = (ManyType)obj;
        if (this.types.size() != other.types.size()) {
            return false;
        }
        return this.types.stream().allMatch(type -> other.types.stream().anyMatch(x -> x == type)) && other.types.stream().allMatch(type -> this.types.stream().anyMatch(x -> x == type));
    }
}

