/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging.impl;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.enodeframework.messaging.IMessage;
import org.enodeframework.messaging.impl.DefaultMessageDispatcher;
import org.enodeframework.messaging.impl.RootDispatching;

public class QueueMessageDispatching {
    private final DefaultMessageDispatcher dispatcher;
    private final RootDispatching rootDispatching;
    private final ConcurrentLinkedQueue<IMessage> messageQueue;

    public QueueMessageDispatching(DefaultMessageDispatcher dispatcher, RootDispatching rootDispatching, List<? extends IMessage> messages) {
        this.dispatcher = dispatcher;
        this.messageQueue = new ConcurrentLinkedQueue();
        this.messageQueue.addAll(messages);
        this.rootDispatching = rootDispatching;
        this.rootDispatching.addChildDispatching(this);
    }

    public IMessage dequeueMessage() {
        return this.messageQueue.poll();
    }

    public void onMessageHandled(IMessage message) {
        IMessage nextMessage = this.dequeueMessage();
        if (nextMessage == null) {
            this.rootDispatching.onChildDispatchingFinished(this);
            return;
        }
        this.dispatcher.dispatchSingleMessage(nextMessage, this);
    }
}

