/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging.impl;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.enodeframework.common.function.Action2;
import org.enodeframework.infrastructure.IObjectProxy;

public class QueuedHandler<T extends IObjectProxy> {
    private final Action2<QueuedHandler<T>, T> dispatchToNextHandler;
    private final ConcurrentLinkedQueue<T> handlerQueue = new ConcurrentLinkedQueue();

    public QueuedHandler(List<T> handlers2, Action2<QueuedHandler<T>, T> dispatchToNextHandler) {
        this.handlerQueue.addAll(handlers2);
        this.dispatchToNextHandler = dispatchToNextHandler;
    }

    public T dequeueHandler() {
        return (T)((IObjectProxy)this.handlerQueue.poll());
    }

    public void onHandlerFinished(T handler) {
        T nextHandler = this.dequeueHandler();
        if (nextHandler != null) {
            this.dispatchToNextHandler.apply(this, nextHandler);
        }
    }
}

