/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging.impl;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.enodeframework.infrastructure.IObjectProxy;
import org.enodeframework.infrastructure.ITypeNameProvider;
import org.enodeframework.messaging.IMessage;
import org.enodeframework.messaging.impl.QueueMessageDispatching;

public class SingleMessageDispatching {
    private final ConcurrentHashMap<String, IObjectProxy> handlerDict;
    private final QueueMessageDispatching queueMessageDispatching;
    private final IMessage message;

    public SingleMessageDispatching(IMessage message, QueueMessageDispatching queueMessageDispatching, List<? extends IObjectProxy> handlers2, ITypeNameProvider typeNameProvider) {
        this.message = message;
        this.queueMessageDispatching = queueMessageDispatching;
        this.handlerDict = new ConcurrentHashMap();
        handlers2.forEach(x -> this.handlerDict.putIfAbsent(typeNameProvider.getTypeName(x.getInnerObject().getClass()), (IObjectProxy)x));
    }

    public void removeHandledHandler(String handlerTypeName) {
        if (this.handlerDict.remove(handlerTypeName) != null && this.handlerDict.isEmpty()) {
            this.queueMessageDispatching.onMessageHandled(this.message);
        }
    }

    public IMessage getMessage() {
        return this.message;
    }
}

