/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.streams.WriteStream;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameHelper;
import io.vertx.ext.eventbus.bridge.tcp.impl.protocol.FrameParser;
import java.time.Duration;
import java.util.Arrays;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandReturnType;
import org.enodeframework.common.io.ReplySocketAddress;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.common.utilities.InetUtil;
import org.enodeframework.common.utilities.ReplyMessage;
import org.enodeframework.queue.DefaultSendReplyService;
import org.enodeframework.queue.ISendReplyService;
import org.enodeframework.queue.domainevent.DomainEventHandledMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 !2\u00020\u00012\u00020\u0002:\u0001!B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u001e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J \u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00122\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0016H\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u001fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000Rf\u0010\b\u001aZ\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\r \u000b*\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\f \u000b*,\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\r \u000b*\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/enodeframework/queue/DefaultSendReplyService;", "Lio/vertx/core/AbstractVerticle;", "Lorg/enodeframework/queue/ISendReplyService;", "serializeService", "Lorg/enodeframework/common/serializing/ISerializeService;", "(Lorg/enodeframework/common/serializing/ISerializeService;)V", "netClient", "Lio/vertx/core/net/NetClient;", "netSocketCache", "Lcom/google/common/cache/Cache;", "", "kotlin.jvm.PlatformType", "Lio/vertx/core/Promise;", "Lio/vertx/core/net/NetSocket;", "started", "", "stoped", "sendCommandReply", "Ljava/util/concurrent/CompletableFuture;", "commandResult", "Lorg/enodeframework/commanding/CommandResult;", "replyAddress", "Lorg/enodeframework/common/io/ReplySocketAddress;", "sendEventReply", "eventHandledMessage", "Lorg/enodeframework/queue/domainevent/DomainEventHandledMessage;", "sendReply", "replyMessage", "Lorg/enodeframework/common/utilities/ReplyMessage;", "replySocketAddress", "start", "", "stop", "Companion", "enode"})
public final class DefaultSendReplyService
extends AbstractVerticle
implements ISendReplyService {
    private boolean started;
    private boolean stoped;
    private NetClient netClient;
    private final Cache<String, Promise<NetSocket>> netSocketCache;
    private final ISerializeService serializeService;
    private static final Logger logger;
    @NotNull
    public static final Companion Companion;

    public void start() {
        if (!this.started) {
            NetClient netClient = this.vertx.createNetClient();
            Intrinsics.checkNotNullExpressionValue((Object)netClient, (String)"vertx.createNetClient()");
            this.netClient = netClient;
            this.started = true;
        }
    }

    public void stop() {
        if (!this.stoped) {
            NetClient netClient = this.netClient;
            if (netClient == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"netClient");
            }
            netClient.close();
            this.stoped = true;
        }
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> sendCommandReply(@NotNull CommandResult commandResult, @NotNull ReplySocketAddress replyAddress) {
        Intrinsics.checkNotNullParameter((Object)commandResult, (String)"commandResult");
        Intrinsics.checkNotNullParameter((Object)replyAddress, (String)"replyAddress");
        ReplyMessage replyMessage = new ReplyMessage();
        replyMessage.setCode(CommandReturnType.CommandExecuted.getValue());
        replyMessage.setCommandResult(commandResult);
        return this.sendReply(replyMessage, replyAddress);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> sendEventReply(@NotNull DomainEventHandledMessage eventHandledMessage, @NotNull ReplySocketAddress replyAddress) {
        Intrinsics.checkNotNullParameter((Object)eventHandledMessage, (String)"eventHandledMessage");
        Intrinsics.checkNotNullParameter((Object)replyAddress, (String)"replyAddress");
        ReplyMessage replyMessage = new ReplyMessage();
        replyMessage.setCode(CommandReturnType.EventHandled.getValue());
        replyMessage.setEventHandledMessage(eventHandledMessage);
        return this.sendReply(replyMessage, replyAddress);
    }

    private final CompletableFuture<Boolean> sendReply(ReplyMessage replyMessage, ReplySocketAddress replySocketAddress) {
        SocketAddress socketAddress = SocketAddress.inetSocketAddress((int)replySocketAddress.getPort(), (String)replySocketAddress.getHost());
        String message = this.serializeService.serialize(replyMessage);
        String address = InetUtil.toUri(replySocketAddress);
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        String string = "%s.%s";
        Object[] objectArray = new Object[]{"client", address};
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        String replyAddress = string2;
        Promise promise2 = (Promise)this.netSocketCache.get((Object)address, (Callable)new Callable<Promise<NetSocket>>(this, socketAddress){
            final /* synthetic */ DefaultSendReplyService this$0;
            final /* synthetic */ SocketAddress $socketAddress;

            /*
             * WARNING - void declaration
             */
            public final Promise<NetSocket> call() {
                void var1_1;
                Promise value = Promise.promise();
                DefaultSendReplyService.access$getNetClient$p(this.this$0).connect(this.$socketAddress, (Handler)value);
                return var1_1;
            }
            {
                this.this$0 = defaultSendReplyService;
                this.$socketAddress = socketAddress;
            }
        });
        promise2.future().onFailure((Handler)new Handler<Throwable>(this, address, message){
            final /* synthetic */ DefaultSendReplyService this$0;
            final /* synthetic */ String $address;
            final /* synthetic */ String $message;

            public final void handle(@Nullable Throwable throwable) {
                DefaultSendReplyService.access$getNetSocketCache$p(this.this$0).invalidate((Object)this.$address);
                DefaultSendReplyService.access$getLogger$cp().error("connect occurs unexpected error, msg: {}", (Object)this.$message, (Object)throwable);
            }
            {
                this.this$0 = defaultSendReplyService;
                this.$address = string;
                this.$message = string2;
            }
        }).onSuccess((Handler)new Handler<NetSocket>(this, address, message, replyAddress){
            final /* synthetic */ DefaultSendReplyService this$0;
            final /* synthetic */ String $address;
            final /* synthetic */ String $message;
            final /* synthetic */ String $replyAddress;

            public final void handle(@NotNull NetSocket socket) {
                Intrinsics.checkNotNullParameter((Object)socket, (String)"socket");
                socket.exceptionHandler((Handler)new Handler<Throwable>(this, socket){
                    final /* synthetic */ sendReply.2 this$0;
                    final /* synthetic */ NetSocket $socket;

                    public final void handle(@Nullable Throwable throwable) {
                        DefaultSendReplyService.access$getNetSocketCache$p(this.this$0.this$0).invalidate((Object)this.this$0.$address);
                        this.$socket.close();
                        DefaultSendReplyService.access$getLogger$cp().error("socket occurs unexpected error, msg: {}", (Object)this.this$0.$message, (Object)throwable);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$socket = netSocket;
                    }
                });
                socket.closeHandler((Handler)new Handler<Void>(this, socket){
                    final /* synthetic */ sendReply.2 this$0;
                    final /* synthetic */ NetSocket $socket;

                    public final void handle(Void it) {
                        DefaultSendReplyService.access$getNetSocketCache$p(this.this$0.this$0).invalidate((Object)this.this$0.$address);
                        DefaultSendReplyService.access$getLogger$cp().error("socket closed, indicatedServerName: {},writeHandlerID: {}", (Object)this.$socket.indicatedServerName(), (Object)this.$socket.writeHandlerID());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$socket = netSocket;
                    }
                });
                socket.handler((Handler)new FrameParser((Handler)new Handler<AsyncResult<JsonObject>>(this){
                    final /* synthetic */ sendReply.2 this$0;

                    public final void handle(@NotNull AsyncResult<JsonObject> parse) {
                        Intrinsics.checkNotNullParameter(parse, (String)"parse");
                        if (parse.succeeded()) {
                            DefaultSendReplyService.access$getLogger$cp().info("receive server response: {}, {}", (Object)this.this$0.$message, parse);
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
                socket.endHandler((Handler)new Handler<Void>(this){
                    final /* synthetic */ sendReply.2 this$0;

                    public final void handle(Void it) {
                        DefaultSendReplyService.access$getNetSocketCache$p(this.this$0.this$0).invalidate((Object)this.this$0.$address);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                FrameHelper.sendFrame((String)"send", (String)this.$address, (String)this.$replyAddress, (JsonObject)new JsonObject(this.$message), (WriteStream)((WriteStream)socket));
            }
            {
                this.this$0 = defaultSendReplyService;
                this.$address = string;
                this.$message = string2;
                this.$replyAddress = string3;
            }
        });
        return Task.completedTask;
    }

    public DefaultSendReplyService(@NotNull ISerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.serializeService = serializeService;
        this.netSocketCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(10L)).maximumSize(10L).build();
    }

    static {
        Companion = new Companion(null);
        logger = LoggerFactory.getLogger(DefaultSendReplyService.class);
    }

    public static final /* synthetic */ NetClient access$getNetClient$p(DefaultSendReplyService $this) {
        NetClient netClient = $this.netClient;
        if (netClient == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"netClient");
        }
        return netClient;
    }

    public static final /* synthetic */ void access$setNetClient$p(DefaultSendReplyService $this, NetClient netClient) {
        $this.netClient = netClient;
    }

    public static final /* synthetic */ Cache access$getNetSocketCache$p(DefaultSendReplyService $this) {
        return $this.netSocketCache;
    }

    public static final /* synthetic */ Logger access$getLogger$cp() {
        return logger;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/queue/DefaultSendReplyService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

