/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.applicationmessage;

import java.util.concurrent.CompletableFuture;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.common.utilities.Ensure;
import org.enodeframework.messaging.IApplicationMessage;
import org.enodeframework.messaging.IMessagePublisher;
import org.enodeframework.queue.ISendMessageService;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.applicationmessage.ApplicationDataMessage;

public class DefaultApplicationMessagePublisher
implements IMessagePublisher<IApplicationMessage> {
    private final String topic;
    private final String tag;
    private final ISendMessageService producer;
    private final ISerializeService serializeService;

    public DefaultApplicationMessagePublisher(String topic, String tag, ISendMessageService producer, ISerializeService serializeService) {
        this.topic = topic;
        this.tag = tag;
        this.producer = producer;
        this.serializeService = serializeService;
    }

    protected QueueMessage createApplicationMessage(IApplicationMessage message) {
        Ensure.notNull(this.topic, "topic");
        String appMessageData = this.serializeService.serialize(message);
        ApplicationDataMessage appDataMessage = new ApplicationDataMessage(appMessageData, message.getClass().getName());
        String data = this.serializeService.serialize(appDataMessage);
        String routeKey = message.getId();
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setBody(data);
        queueMessage.setRouteKey(routeKey);
        queueMessage.setKey(message.getId());
        queueMessage.setTopic(this.topic);
        queueMessage.setTag(this.tag);
        return queueMessage;
    }

    @Override
    public CompletableFuture<Boolean> publishAsync(IApplicationMessage message) {
        return this.producer.sendMessageAsync(this.createApplicationMessage(message));
    }
}

