/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.publishableexceptions;

import org.enodeframework.common.exception.MessageInstanceCreateException;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.domain.IDomainException;
import org.enodeframework.infrastructure.ITypeNameProvider;
import org.enodeframework.messaging.IMessageDispatcher;
import org.enodeframework.queue.IMessageContext;
import org.enodeframework.queue.IMessageHandler;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.publishableexceptions.PublishableExceptionMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPublishableExceptionMessageHandler
implements IMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultPublishableExceptionMessageHandler.class);
    private final ITypeNameProvider typeNameProvider;
    private final IMessageDispatcher messageDispatcher;
    private final ISerializeService serializeService;

    public DefaultPublishableExceptionMessageHandler(ITypeNameProvider typeNameProvider, IMessageDispatcher messageDispatcher, ISerializeService serializeService) {
        this.typeNameProvider = typeNameProvider;
        this.messageDispatcher = messageDispatcher;
        this.serializeService = serializeService;
    }

    @Override
    public void handle(QueueMessage queueMessage, IMessageContext context) {
        IDomainException exception;
        logger.info("Received domain exception message: {}", (Object)this.serializeService.serialize(queueMessage));
        PublishableExceptionMessage exceptionMessage = this.serializeService.deserialize(queueMessage.getBody(), PublishableExceptionMessage.class);
        Class<?> exceptionType = this.typeNameProvider.getType(exceptionMessage.getExceptionType());
        try {
            exception = (IDomainException)exceptionType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new MessageInstanceCreateException(e);
        }
        exception.setId(exceptionMessage.getUniqueId());
        exception.setTimestamp(exceptionMessage.getTimestamp());
        exception.setItems(exceptionMessage.getItems());
        exception.restoreFrom(exceptionMessage.getSerializableInfo());
        this.messageDispatcher.dispatchMessageAsync(exception).whenComplete((x, y) -> context.onMessageHandled(queueMessage));
    }
}

