/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.queue.publishableexceptions;

import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import org.enodeframework.common.serializing.ISerializeService;
import org.enodeframework.common.utilities.Ensure;
import org.enodeframework.domain.IDomainException;
import org.enodeframework.messaging.IMessagePublisher;
import org.enodeframework.queue.ISendMessageService;
import org.enodeframework.queue.QueueMessage;
import org.enodeframework.queue.publishableexceptions.PublishableExceptionMessage;

public class DefaultPublishableExceptionPublisher
implements IMessagePublisher<IDomainException> {
    private final String topic;
    private final String tag;
    private final ISendMessageService sendMessageService;
    private final ISerializeService serializeService;

    public DefaultPublishableExceptionPublisher(String topic, String tag, ISendMessageService sendMessageService, ISerializeService serializeService) {
        this.topic = topic;
        this.tag = tag;
        this.sendMessageService = sendMessageService;
        this.serializeService = serializeService;
    }

    protected QueueMessage createExceptionMessage(IDomainException exception) {
        Ensure.notNull(this.topic, "topic");
        HashMap<String, Object> serializableInfo = new HashMap<String, Object>();
        exception.serializeTo(serializableInfo);
        PublishableExceptionMessage exceptionMessage = new PublishableExceptionMessage();
        exceptionMessage.setUniqueId(exception.getId());
        exceptionMessage.setExceptionType(exception.getClass().getName());
        exceptionMessage.setTimestamp(exception.getTimestamp());
        exceptionMessage.setSerializableInfo(serializableInfo);
        exceptionMessage.setItems(exception.getItems());
        String data = this.serializeService.serialize(exceptionMessage);
        String routeKey = exception.getId();
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setTopic(this.topic);
        queueMessage.setTag(this.tag);
        queueMessage.setBody(data);
        queueMessage.setRouteKey(routeKey);
        queueMessage.setKey(exceptionMessage.getUniqueId());
        return queueMessage;
    }

    @Override
    public CompletableFuture<Boolean> publishAsync(IDomainException message) {
        return this.sendMessageService.sendMessageAsync(this.createExceptionMessage(message));
    }
}

