/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding;

import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.ProcessingCommandHandler;
import org.enodeframework.common.extensions.SystemClock;
import org.enodeframework.common.io.Task;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u0000 A2\u00020\u0001:\u0001AB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0003J\u001c\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170)2\u0006\u0010*\u001a\u00020#2\u0006\u0010+\u001a\u00020,J\b\u0010-\u001a\u00020&H\u0002J\u000e\u0010.\u001a\u00020&2\u0006\u0010*\u001a\u00020#J\u0006\u0010/\u001a\u00020&J\u0012\u00100\u001a\u0004\u0018\u00010#2\u0006\u00101\u001a\u00020\"H\u0002J\u0006\u00102\u001a\u00020\"J\u000e\u00103\u001a\u00020\u00172\u0006\u00104\u001a\u00020\u0007J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u00105\u001a\u00020&J\u0006\u00106\u001a\u00020&J\b\u00107\u001a\u00020&H\u0002J\u0018\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020\"2\u0006\u0010:\u001a\u00020\"H\u0002J\u000e\u0010;\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\"J\u0006\u0010<\u001a\u00020&J\b\u0010=\u001a\u00020&H\u0002J\b\u0010>\u001a\u00020&H\u0002J\u0006\u0010?\u001a\u00020&J\u0006\u0010@\u001a\u00020\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000f@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u000e\u0010\u001d\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006B"}, d2={"Lorg/enodeframework/commanding/ProcessingCommandMailbox;", "", "aggregateRootId", "", "messageHandler", "Lorg/enodeframework/commanding/ProcessingCommandHandler;", "batchSize", "", "(Ljava/lang/String;Lorg/enodeframework/commanding/ProcessingCommandHandler;I)V", "getAggregateRootId", "()Ljava/lang/String;", "setAggregateRootId", "(Ljava/lang/String;)V", "asyncLockObj", "<set-?>", "Ljava/util/concurrent/atomic/AtomicLong;", "consumingSequence", "getConsumingSequence", "()Ljava/util/concurrent/atomic/AtomicLong;", "duplicateCommandIdDict", "Ljava/util/concurrent/ConcurrentHashMap;", "", "isPauseRequested", "", "isPaused", "()Z", "isRemoved", "Ljava/util/concurrent/atomic/AtomicInteger;", "isRunning", "isUsing", "lastActiveTime", "Ljava/util/Date;", "lockObj", "messageDict", "", "Lorg/enodeframework/commanding/ProcessingCommand;", "nextSequence", "addDuplicateCommandId", "", "commandId", "completeMessage", "Ljava/util/concurrent/CompletableFuture;", "message", "result", "Lorg/enodeframework/commanding/CommandResult;", "completeRun", "enqueueMessage", "exitUsing", "getMessage", "sequence", "getTotalUnHandledMessageCount", "isInactive", "timeoutSeconds", "markAsRemoved", "pause", "processMessages", "processMessagesRecursively", "unHandledMessageCount", "scannedCount", "resetConsumingSequence", "resume", "setAsNotRunning", "setAsRunning", "tryRun", "tryUsing", "Companion", "enode"})
public final class ProcessingCommandMailbox {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String aggregateRootId;
    @NotNull
    private final ProcessingCommandHandler messageHandler;
    private final int batchSize;
    @NotNull
    private final Object lockObj;
    @NotNull
    private final Object asyncLockObj;
    @NotNull
    private ConcurrentHashMap<Long, ProcessingCommand> messageDict;
    @NotNull
    private ConcurrentHashMap<String, Byte> duplicateCommandIdDict;
    @NotNull
    private final AtomicInteger isUsing;
    @NotNull
    private final AtomicInteger isRemoved;
    @NotNull
    private Date lastActiveTime;
    private boolean isRunning;
    private boolean isPauseRequested;
    private boolean isPaused;
    private long nextSequence;
    @NotNull
    private AtomicLong consumingSequence;
    private static final Logger logger = LoggerFactory.getLogger(ProcessingCommandMailbox.class);

    public ProcessingCommandMailbox(@NotNull String aggregateRootId, @NotNull ProcessingCommandHandler messageHandler, int batchSize) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)messageHandler, (String)"messageHandler");
        this.aggregateRootId = aggregateRootId;
        this.messageHandler = messageHandler;
        this.batchSize = batchSize;
        this.lockObj = new Object();
        this.asyncLockObj = new Object();
        this.messageDict = new ConcurrentHashMap();
        this.duplicateCommandIdDict = new ConcurrentHashMap();
        this.isUsing = new AtomicInteger(0);
        this.isRemoved = new AtomicInteger(0);
        this.consumingSequence = new AtomicLong(0L);
        this.lastActiveTime = new Date();
    }

    @NotNull
    public final String getAggregateRootId() {
        return this.aggregateRootId;
    }

    public final void setAggregateRootId(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.aggregateRootId = string;
    }

    public final boolean isRunning() {
        return this.isRunning;
    }

    public final boolean isPaused() {
        return this.isPaused;
    }

    @NotNull
    public final AtomicLong getConsumingSequence() {
        return this.consumingSequence;
    }

    public final long getTotalUnHandledMessageCount() {
        return this.nextSequence - this.consumingSequence.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueMessage(@NotNull ProcessingCommand message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            message.setSequence(this.nextSequence);
            message.setMailBox(this);
            if (this.messageDict.putIfAbsent(message.getSequence(), message) == null) {
                long l = this.nextSequence;
                this.nextSequence = l + 1L;
                if (logger.isDebugEnabled()) {
                    Object[] objectArray = new Object[]{this.getClass().getName(), this.getAggregateRootId(), message.getSequence()};
                    logger.debug("{} enqueued new message, aggregateRootId: {}, messageSequence: {}", objectArray);
                }
                this.lastActiveTime = new Date();
                this.tryRun();
            } else {
                Object[] objectArray = new Object[]{this.getClass().getName(), this.getAggregateRootId(), message.getMessage().getId(), message.getSequence()};
                logger.error("{} enqueue message failed, aggregateRootId: {}, messageId: {}, messageSequence: {}", objectArray);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void tryRun() {
        Object object = this.lockObj;
        synchronized (object) {
            block8: {
                block7: {
                    boolean bl = false;
                    if (this.isRunning() || this.isPauseRequested) break block7;
                    if (!this.isPaused()) break block8;
                }
                return;
            }
            this.setAsRunning();
            if (logger.isDebugEnabled()) {
                Object[] objectArray = new Object[]{this.getClass().getName(), this.getAggregateRootId(), this.getConsumingSequence().get()};
                logger.debug("{} start run, aggregateRootId: {}, consumingSequence: {}", objectArray);
            }
            Deferred deferred = BuildersKt.async$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ ProcessingCommandMailbox this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            ProcessingCommandMailbox.access$processMessages(this.this$0);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
    }

    private final void completeRun() {
        this.lastActiveTime = new Date();
        if (logger.isDebugEnabled()) {
            logger.debug("{} complete run, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
        }
        this.setAsNotRunning();
        if (this.getTotalUnHandledMessageCount() > 0L) {
            this.tryRun();
        }
    }

    public final void pause() {
        this.isPauseRequested = true;
        if (logger.isDebugEnabled()) {
            logger.debug("{} pause requested, aggregateRootId: {}", (Object)this.getClass().getName(), (Object)this.aggregateRootId);
        }
        long count = 0L;
        while (this.isRunning) {
            Task.sleep(10L);
            long l = count;
            if ((count = l + 1L) % (long)100 != 0L || !logger.isDebugEnabled()) continue;
            Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, count};
            logger.debug("{} pause requested, but wait for too long to stop the current mailbox, aggregateRootId: {}, waitCount: {}", objectArray);
        }
        this.lastActiveTime = new Date();
        this.isPaused = true;
    }

    public final void resume() {
        this.isPauseRequested = false;
        this.isPaused = false;
        this.lastActiveTime = new Date();
        if (logger.isDebugEnabled()) {
            Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, this.consumingSequence.get()};
            logger.debug("{} resume requested, aggregateRootId: {}, consumingSequence: {}", objectArray);
        }
    }

    public final void addDuplicateCommandId(@NotNull String commandId) {
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        this.duplicateCommandIdDict.putIfAbsent(commandId, (byte)1);
    }

    public final void resetConsumingSequence(long consumingSequence) {
        this.consumingSequence.set(consumingSequence);
        this.lastActiveTime = new Date();
        if (logger.isDebugEnabled()) {
            Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, consumingSequence};
            logger.debug("{} reset consumingSequence, aggregateRootId: {}, consumingSequence: {}", objectArray);
        }
    }

    @NotNull
    public final CompletableFuture<Boolean> completeMessage(@NotNull ProcessingCommand message, @NotNull CommandResult result) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        try {
            ProcessingCommand removed = this.messageDict.remove(message.getSequence());
            if (removed != null) {
                this.duplicateCommandIdDict.remove(message.getMessage().getId());
                this.lastActiveTime = new Date();
                return message.completeAsync(result);
            }
        }
        catch (Exception ex) {
            Object[] objectArray = new Object[]{this.getClass().getName(), this.aggregateRootId, message.getMessage().getId(), message.getSequence(), result, ex};
            logger.error("{} complete message with result failed, aggregateRootId: {}, messageId: {}, messageSequence: {}, result: {}", objectArray);
        }
        return Task.completedTask;
    }

    public final boolean isInactive(int timeoutSeconds) {
        return SystemClock.now() - this.lastActiveTime.getTime() >= (long)timeoutSeconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void processMessages() {
        Object object = this.asyncLockObj;
        synchronized (object) {
            boolean bl = false;
            this.lastActiveTime = new Date();
            try {
                this.processMessagesRecursively(this.getTotalUnHandledMessageCount(), 0L);
            }
            catch (Exception ex) {
                Object[] objectArray = new Object[]{this.getClass().getName(), this.getAggregateRootId(), ex};
                logger.error("{} run has unknown exception, aggregateRootId: {}", objectArray);
                Task.sleep(1L);
                this.completeRun();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void processMessagesRecursively(long unHandledMessageCount, long scannedCount) {
        if (unHandledMessageCount <= 0L || scannedCount >= (long)this.batchSize || this.isPauseRequested) {
            this.completeRun();
            return;
        }
        ProcessingCommand message = this.getMessage(this.consumingSequence.get());
        if (message != null) {
            if (this.duplicateCommandIdDict.containsKey(message.getMessage().getId())) {
                message.setDuplicated(true);
            }
            this.messageHandler.handleAsync(message).whenComplete((arg_0, arg_1) -> ProcessingCommandMailbox.processMessagesRecursively$lambda-3(this, scannedCount, arg_0, arg_1));
        } else {
            this.consumingSequence.incrementAndGet();
            this.processMessagesRecursively(this.getTotalUnHandledMessageCount(), scannedCount + 1L);
        }
    }

    private final ProcessingCommand getMessage(long sequence) {
        return this.messageDict.get(sequence);
    }

    private final void setAsRunning() {
        this.isRunning = true;
    }

    public final boolean tryUsing() {
        return this.isUsing.compareAndSet(0, 1);
    }

    public final void exitUsing() {
        this.isUsing.set(0);
    }

    public final void markAsRemoved() {
        this.isRemoved.set(1);
    }

    public final boolean isRemoved() {
        return this.isRemoved.get() == 1;
    }

    private final void setAsNotRunning() {
        this.isRunning = false;
    }

    private static final void processMessagesRecursively$lambda-3(ProcessingCommandMailbox this$0, long $scannedCount, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.consumingSequence.incrementAndGet();
        this$0.processMessagesRecursively(this$0.getTotalUnHandledMessageCount(), $scannedCount + 1L);
    }

    public static final /* synthetic */ void access$processMessages(ProcessingCommandMailbox $this) {
        $this.processMessages();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/commanding/ProcessingCommandMailbox$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

