/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding.impl;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.commanding.CommandProcessor;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.ProcessingCommandHandler;
import org.enodeframework.commanding.ProcessingCommandMailbox;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.scheduling.ScheduleService;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0013H\u0002J\u0010\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0019H\u0016J\b\u0010!\u001a\u00020\u0019H\u0016R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\n\"\u0004\b\u0016\u0010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/enodeframework/commanding/impl/DefaultCommandProcessor;", "Lorg/enodeframework/commanding/CommandProcessor;", "processingCommandHandler", "Lorg/enodeframework/commanding/ProcessingCommandHandler;", "scheduleService", "Lorg/enodeframework/common/scheduling/ScheduleService;", "(Lorg/enodeframework/commanding/ProcessingCommandHandler;Lorg/enodeframework/common/scheduling/ScheduleService;)V", "aggregateRootMaxInactiveSeconds", "", "getAggregateRootMaxInactiveSeconds", "()I", "setAggregateRootMaxInactiveSeconds", "(I)V", "commandMailBoxPersistenceMaxBatchSize", "getCommandMailBoxPersistenceMaxBatchSize", "setCommandMailBoxPersistenceMaxBatchSize", "mailboxDict", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/enodeframework/commanding/ProcessingCommandMailbox;", "scanExpiredAggregateIntervalMilliseconds", "getScanExpiredAggregateIntervalMilliseconds", "setScanExpiredAggregateIntervalMilliseconds", "taskName", "cleanInactiveMailbox", "", "isMailBoxAllowRemove", "", "mailbox", "process", "processingCommand", "Lorg/enodeframework/commanding/ProcessingCommand;", "start", "stop", "Companion", "enode"})
public final class DefaultCommandProcessor
implements CommandProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProcessingCommandHandler processingCommandHandler;
    @NotNull
    private final ScheduleService scheduleService;
    @NotNull
    private final ConcurrentMap<String, ProcessingCommandMailbox> mailboxDict;
    @NotNull
    private final String taskName;
    private int aggregateRootMaxInactiveSeconds;
    private int commandMailBoxPersistenceMaxBatchSize;
    private int scanExpiredAggregateIntervalMilliseconds;
    private static final Logger logger = LoggerFactory.getLogger(DefaultCommandProcessor.class);

    public DefaultCommandProcessor(@NotNull ProcessingCommandHandler processingCommandHandler, @NotNull ScheduleService scheduleService) {
        Intrinsics.checkNotNullParameter((Object)processingCommandHandler, (String)"processingCommandHandler");
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        this.processingCommandHandler = processingCommandHandler;
        this.scheduleService = scheduleService;
        this.aggregateRootMaxInactiveSeconds = 259200;
        this.commandMailBoxPersistenceMaxBatchSize = 1000;
        this.scanExpiredAggregateIntervalMilliseconds = 5000;
        this.mailboxDict = new ConcurrentHashMap();
        this.taskName = "CleanInactiveProcessingCommandMailBoxes_" + System.nanoTime() + new Random().nextInt(10000);
    }

    public final int getAggregateRootMaxInactiveSeconds() {
        return this.aggregateRootMaxInactiveSeconds;
    }

    public final void setAggregateRootMaxInactiveSeconds(int n) {
        this.aggregateRootMaxInactiveSeconds = n;
    }

    public final int getCommandMailBoxPersistenceMaxBatchSize() {
        return this.commandMailBoxPersistenceMaxBatchSize;
    }

    public final void setCommandMailBoxPersistenceMaxBatchSize(int n) {
        this.commandMailBoxPersistenceMaxBatchSize = n;
    }

    public final int getScanExpiredAggregateIntervalMilliseconds() {
        return this.scanExpiredAggregateIntervalMilliseconds;
    }

    public final void setScanExpiredAggregateIntervalMilliseconds(int n) {
        this.scanExpiredAggregateIntervalMilliseconds = n;
    }

    @Override
    public void process(@NotNull ProcessingCommand processingCommand) {
        Intrinsics.checkNotNullParameter((Object)processingCommand, (String)"processingCommand");
        String aggregateRootId = processingCommand.getMessage().getAggregateRootIdAsString();
        if (!(!Strings.isNullOrEmpty((String)aggregateRootId))) {
            boolean $i$a$-require-DefaultCommandProcessor$process$22 = false;
            String string = "aggregateRootId of command cannot be null or empty, commandId: %s";
            Object[] objectArray = new Object[]{processingCommand.getMessage().getId()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String $i$a$-require-DefaultCommandProcessor$process$22 = string2;
            throw new IllegalArgumentException($i$a$-require-DefaultCommandProcessor$process$22.toString());
        }
        ProcessingCommandMailbox mailbox = this.mailboxDict.computeIfAbsent(aggregateRootId, arg_0 -> DefaultCommandProcessor.process$lambda-1(this, arg_0));
        long mailboxTryUsingCount = 0L;
        while (!mailbox.tryUsing()) {
            Task.sleep(1L);
            long l = mailboxTryUsingCount;
            if ((mailboxTryUsingCount = l + 1L) % (long)10000 != 0L) continue;
            logger.warn("Command mailbox try using count: {}, aggregateRootId: {}", (Object)mailboxTryUsingCount, (Object)mailbox.getAggregateRootId());
        }
        if (mailbox.isRemoved()) {
            mailbox = this.mailboxDict.computeIfAbsent(aggregateRootId, arg_0 -> DefaultCommandProcessor.process$lambda-2(this, arg_0));
        }
        mailbox.enqueueMessage(processingCommand);
        mailbox.exitUsing();
    }

    @Override
    public void start() {
        this.scheduleService.startTask(this.taskName, () -> DefaultCommandProcessor.start$lambda-3(this), this.scanExpiredAggregateIntervalMilliseconds, this.scanExpiredAggregateIntervalMilliseconds);
    }

    @Override
    public void stop() {
        this.scheduleService.stopTask(this.taskName);
    }

    private final boolean isMailBoxAllowRemove(ProcessingCommandMailbox mailbox) {
        return mailbox.isInactive(this.aggregateRootMaxInactiveSeconds) && !mailbox.isRunning() && mailbox.getTotalUnHandledMessageCount() == 0L;
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanInactiveMailbox() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.mailboxDict.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
            if (!this.isMailBoxAllowRemove((ProcessingCommandMailbox)v)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inactiveList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = inactiveList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessingCommandMailbox removed;
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            if (!this.isMailBoxAllowRemove((ProcessingCommandMailbox)entry.getValue()) || (removed = (ProcessingCommandMailbox)this.mailboxDict.remove(entry.getKey())) == null) continue;
            removed.markAsRemoved();
            logger.info("Removed inactive command mailbox, aggregateRootId: {}", entry.getKey());
        }
    }

    private static final ProcessingCommandMailbox process$lambda-1(DefaultCommandProcessor this$0, String x) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return new ProcessingCommandMailbox(x, this$0.processingCommandHandler, this$0.commandMailBoxPersistenceMaxBatchSize);
    }

    private static final ProcessingCommandMailbox process$lambda-2(DefaultCommandProcessor this$0, String x) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        return new ProcessingCommandMailbox(x, this$0.processingCommandHandler, this$0.commandMailBoxPersistenceMaxBatchSize);
    }

    private static final void start$lambda-3(DefaultCommandProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cleanInactiveMailbox();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/commanding/impl/DefaultCommandProcessor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

