/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.commanding.impl;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.future.FutureKt;
import org.enodeframework.commanding.CommandExecuteContext;
import org.enodeframework.commanding.CommandHandlerProvider;
import org.enodeframework.commanding.CommandHandlerProxy;
import org.enodeframework.commanding.CommandMessage;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandStatus;
import org.enodeframework.commanding.HandlerFindResult;
import org.enodeframework.commanding.HandlerFindStatus;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.ProcessingCommandHandler;
import org.enodeframework.common.exception.AggregateRootReferenceChangedException;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.DomainExceptionMessage;
import org.enodeframework.domain.MemoryCache;
import org.enodeframework.eventing.DomainEventMessage;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventCommittingContext;
import org.enodeframework.eventing.EventCommittingService;
import org.enodeframework.eventing.EventStore;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.messaging.ApplicationMessage;
import org.enodeframework.messaging.Message;
import org.enodeframework.messaging.MessageHandlerData;
import org.enodeframework.messaging.MessagePublisher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 72\u00020\u0001:\u00017BQ\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\r\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J0\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J0\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u001d2\b\u0010\"\u001a\u0004\u0018\u00010\u001dH\u0002J4\u0010#\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u00182\"\u0010%\u001a\u001e\u0012\b\u0012\u0006\u0012\u0002\b\u00030'\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020*0)0(0&H\u0002J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020,H\u0002J\u0016\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J&\u0010/\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020*2\u0006\u00101\u001a\u000202H\u0002J6\u00103\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00100\u001a\u00020*2\u0006\u0010-\u001a\u00020,2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u00101\u001a\u000202H\u0002J&\u00104\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010-\u001a\u00020\u00102\u0006\u00101\u001a\u000202H\u0002J&\u00105\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000e2\u0006\u00101\u001a\u000202H\u0002J\u001e\u00106\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00101\u001a\u000202H\u0002R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00100\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/enodeframework/commanding/impl/DefaultProcessingCommandHandler;", "Lorg/enodeframework/commanding/ProcessingCommandHandler;", "eventStore", "Lorg/enodeframework/eventing/EventStore;", "commandHandlerProvider", "Lorg/enodeframework/commanding/CommandHandlerProvider;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "eventCommittingService", "Lorg/enodeframework/eventing/EventCommittingService;", "memoryCache", "Lorg/enodeframework/domain/MemoryCache;", "applicationMessagePublisher", "Lorg/enodeframework/messaging/MessagePublisher;", "Lorg/enodeframework/messaging/ApplicationMessage;", "exceptionPublisher", "Lorg/enodeframework/domain/DomainExceptionMessage;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "(Lorg/enodeframework/eventing/EventStore;Lorg/enodeframework/commanding/CommandHandlerProvider;Lorg/enodeframework/infrastructure/TypeNameProvider;Lorg/enodeframework/eventing/EventCommittingService;Lorg/enodeframework/domain/MemoryCache;Lorg/enodeframework/messaging/MessagePublisher;Lorg/enodeframework/messaging/MessagePublisher;Lorg/enodeframework/common/serializing/SerializeService;)V", "commitAggregateChanges", "Ljava/util/concurrent/CompletableFuture;", "", "processingCommand", "Lorg/enodeframework/commanding/ProcessingCommand;", "commitChangesAsync", "success", "message", "errorMessage", "", "completeCommand", "commandStatus", "Lorg/enodeframework/commanding/CommandStatus;", "resultType", "result", "getCommandHandler", "Lorg/enodeframework/commanding/HandlerFindResult;", "getHandlersFunc", "Ljava/util/function/Function;", "Ljava/lang/Class;", "", "Lorg/enodeframework/messaging/MessageHandlerData;", "Lorg/enodeframework/commanding/CommandHandlerProxy;", "getRealException", "", "exception", "handleAsync", "handleCommandInternal", "commandHandler", "retryTimes", "", "handleExceptionAsync", "publishExceptionAsync", "publishMessageAsync", "republishCommandEvents", "Companion", "enode"})
public final class DefaultProcessingCommandHandler
implements ProcessingCommandHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final CommandHandlerProvider commandHandlerProvider;
    @NotNull
    private final TypeNameProvider typeNameProvider;
    @NotNull
    private final EventCommittingService eventCommittingService;
    @NotNull
    private final MemoryCache memoryCache;
    @NotNull
    private final MessagePublisher<ApplicationMessage> applicationMessagePublisher;
    @NotNull
    private final MessagePublisher<DomainExceptionMessage> exceptionPublisher;
    @NotNull
    private final SerializeService serializeService;
    private static final Logger logger = LoggerFactory.getLogger(DefaultProcessingCommandHandler.class);

    public DefaultProcessingCommandHandler(@NotNull EventStore eventStore, @NotNull CommandHandlerProvider commandHandlerProvider, @NotNull TypeNameProvider typeNameProvider, @NotNull EventCommittingService eventCommittingService, @NotNull MemoryCache memoryCache, @NotNull MessagePublisher<ApplicationMessage> applicationMessagePublisher, @NotNull MessagePublisher<DomainExceptionMessage> exceptionPublisher, @NotNull SerializeService serializeService) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)commandHandlerProvider, (String)"commandHandlerProvider");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        Intrinsics.checkNotNullParameter((Object)eventCommittingService, (String)"eventCommittingService");
        Intrinsics.checkNotNullParameter((Object)memoryCache, (String)"memoryCache");
        Intrinsics.checkNotNullParameter(applicationMessagePublisher, (String)"applicationMessagePublisher");
        Intrinsics.checkNotNullParameter(exceptionPublisher, (String)"exceptionPublisher");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        this.eventStore = eventStore;
        this.commandHandlerProvider = commandHandlerProvider;
        this.typeNameProvider = typeNameProvider;
        this.eventCommittingService = eventCommittingService;
        this.memoryCache = memoryCache;
        this.applicationMessagePublisher = applicationMessagePublisher;
        this.exceptionPublisher = exceptionPublisher;
        this.serializeService = serializeService;
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> handleAsync(@NotNull ProcessingCommand processingCommand) {
        Intrinsics.checkNotNullParameter((Object)processingCommand, (String)"processingCommand");
        CommandMessage<?> command = processingCommand.getMessage();
        if (Strings.isNullOrEmpty((String)command.getAggregateRootIdAsString())) {
            String string = "The aggregateRootId of command cannot be null or empty. commandType:%s, commandId:%s";
            Object[] objectArray = new Object[]{command.getClass().getName(), command.getId()};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String errorMessage = string2;
            logger.error(errorMessage);
            String string3 = String.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
            return this.completeCommand(processingCommand, CommandStatus.Failed, string3, errorMessage);
        }
        HandlerFindResult findResult = this.getCommandHandler(processingCommand, arg_0 -> DefaultProcessingCommandHandler.handleAsync$lambda-0(this, arg_0));
        switch (WhenMappings.$EnumSwitchMapping$0[findResult.getFindStatus().ordinal()]) {
            case 1: {
                CommandHandlerProxy commandHandlerProxy = findResult.getFindHandler();
                if (commandHandlerProxy == null) {
                    throw new NullPointerException("null cannot be cast to non-null type org.enodeframework.commanding.CommandHandlerProxy");
                }
                return this.handleCommandInternal(processingCommand, commandHandlerProxy, 0);
            }
            case 2: {
                logger.error("Found more than one command handler data, commandType:{}, commandId:{}", (Object)command.getClass().getName(), (Object)command.getId());
                String string = String.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
                return this.completeCommand(processingCommand, CommandStatus.Failed, string, "More than one command handler data found.");
            }
            case 3: {
                logger.error("Found more than one command handler, commandType:{}, commandId:{}", (Object)command.getClass().getName(), (Object)command.getId());
                String string = String.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
                return this.completeCommand(processingCommand, CommandStatus.Failed, string, "More than one command handler found.");
            }
            case 4: {
                String string = "No command handler found of command. commandType:%s, commandId:%s";
                Object[] objectArray = new Object[]{command.getClass().getName(), command.getId()};
                String string4 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"format(format, *args)");
                String errorMessage = string4;
                logger.error(errorMessage);
                String string5 = String.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"String::class.java.name");
                return this.completeCommand(processingCommand, CommandStatus.Failed, string5, errorMessage);
            }
        }
        return Task.completedTask;
    }

    private final CompletableFuture<Boolean> handleCommandInternal(ProcessingCommand processingCommand, CommandHandlerProxy commandHandler, int retryTimes) {
        CommandMessage<?> command = processingCommand.getMessage();
        CommandExecuteContext commandContext = processingCommand.getCommandExecuteContext();
        if (processingCommand.isDuplicated()) {
            return this.republishCommandEvents(processingCommand, 0);
        }
        CompletableFuture<Boolean> taskSource = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("HandleCommandAsync", () -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-1(commandContext, commandHandler, command), arg_0 -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-8(commandHandler, command, commandContext, this, processingCommand, taskSource, arg_0), () -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-9(command, commandHandler), (arg_0, arg_1) -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-11(this, processingCommand, commandHandler, taskSource, arg_0, arg_1), retryTimes, false);
        return taskSource;
    }

    private final CompletableFuture<Boolean> commitAggregateChanges(ProcessingCommand processingCommand) {
        CommandMessage<?> command = processingCommand.getMessage();
        CommandExecuteContext context = processingCommand.getCommandExecuteContext();
        List<AggregateRoot> trackedAggregateRoots = context.getTrackedAggregateRoots();
        int dirtyAggregateRootCount = 0;
        AggregateRoot dirtyAggregateRoot = null;
        List<DomainEventMessage<?>> changedEvents = new ArrayList();
        for (AggregateRoot aggregateRoot : trackedAggregateRoots) {
            List<DomainEventMessage<?>> events = aggregateRoot.getChanges();
            if (events.size() <= 0) continue;
            int n = dirtyAggregateRootCount;
            if ((dirtyAggregateRootCount = n + 1) > 1) {
                String string = "Detected more than one aggregate created or modified by command. commandType:%s, commandId:%s";
                Object[] objectArray = new Object[]{command.getClass().getName(), command.getId()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                String errorMessage = string2;
                logger.error(errorMessage);
                String string3 = String.class.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"String::class.java.name");
                return this.completeCommand(processingCommand, CommandStatus.Failed, string3, errorMessage);
            }
            dirtyAggregateRoot = aggregateRoot;
            Intrinsics.checkNotNullExpressionValue(events, (String)"events");
            changedEvents = events;
        }
        if (dirtyAggregateRootCount == 0 || changedEvents.isEmpty()) {
            return this.republishCommandEvents(processingCommand, 0);
        }
        Intrinsics.checkNotNull(dirtyAggregateRoot);
        DomainEventStream eventStream = new DomainEventStream(processingCommand.getMessage().getId(), dirtyAggregateRoot.getUniqueId(), this.typeNameProvider.getTypeName(dirtyAggregateRoot.getClass()), new Date(), changedEvents, command.getItems());
        this.memoryCache.acceptAggregateRootChanges(dirtyAggregateRoot);
        String commandResult = processingCommand.getCommandExecuteContext().getResult();
        Map<String, Object> map = processingCommand.getItems();
        String string = "COMMAND_RESULT";
        map.put(string, commandResult);
        this.eventCommittingService.commitDomainEventAsync(new EventCommittingContext(eventStream, processingCommand));
        return Task.completedTask;
    }

    private final CompletableFuture<Boolean> republishCommandEvents(ProcessingCommand processingCommand, int retryTimes) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        CommandMessage<?> command = processingCommand.getMessage();
        IOHelper.tryAsyncActionRecursively("ProcessIfNoEventsOfCommand", () -> DefaultProcessingCommandHandler.republishCommandEvents$lambda-12(this, command), arg_0 -> DefaultProcessingCommandHandler.republishCommandEvents$lambda-15(this, processingCommand, future, arg_0), () -> DefaultProcessingCommandHandler.republishCommandEvents$lambda-16(command), null, retryTimes, true);
        return future;
    }

    private final CompletableFuture<Boolean> handleExceptionAsync(ProcessingCommand processingCommand, CommandHandlerProxy commandHandler, Throwable exception, String errorMessage, int retryTimes) {
        CommandMessage<?> command = processingCommand.getMessage();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursively("FindEventByCommandIdAsync", () -> DefaultProcessingCommandHandler.handleExceptionAsync$lambda-17(this, command), arg_0 -> DefaultProcessingCommandHandler.handleExceptionAsync$lambda-21(this, processingCommand, exception, future, arg_0), () -> DefaultProcessingCommandHandler.handleExceptionAsync$lambda-22(command, commandHandler), null, retryTimes, true);
        return future;
    }

    private final Throwable getRealException(Throwable exception) {
        if (exception instanceof CompletionException) {
            if (exception.getCause() instanceof DomainExceptionMessage) {
                Throwable throwable = exception.getCause();
                Intrinsics.checkNotNull((Object)throwable);
                return throwable;
            }
            Throwable throwable = Arrays.stream(((CompletionException)exception).getSuppressed()).filter(DefaultProcessingCommandHandler::getRealException$lambda-23).findFirst().orElse(exception);
            Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"stream(exception.suppres\u2026       .orElse(exception)");
            return throwable;
        }
        return exception;
    }

    private final CompletableFuture<Boolean> publishExceptionAsync(ProcessingCommand processingCommand, DomainExceptionMessage exception, int retryTimes) {
        exception.mergeItems(processingCommand.getMessage().getItems());
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("PublishExceptionAsync", () -> DefaultProcessingCommandHandler.publishExceptionAsync$lambda-24(this, exception), arg_0 -> DefaultProcessingCommandHandler.publishExceptionAsync$lambda-26(this, processingCommand, exception, future, arg_0), () -> DefaultProcessingCommandHandler.publishExceptionAsync$lambda-27(processingCommand), null, retryTimes, true);
        return future;
    }

    private final CompletableFuture<Boolean> commitChangesAsync(ProcessingCommand processingCommand, boolean success, ApplicationMessage message, String errorMessage) {
        if (success) {
            if (message != null) {
                message.mergeItems(processingCommand.getMessage().getItems());
                return this.publishMessageAsync(processingCommand, message, 0);
            }
            return this.completeCommand(processingCommand, CommandStatus.Success, "", "");
        }
        String string = String.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
        return this.completeCommand(processingCommand, CommandStatus.Failed, string, errorMessage);
    }

    private final CompletableFuture<Boolean> publishMessageAsync(ProcessingCommand processingCommand, ApplicationMessage message, int retryTimes) {
        CommandMessage<?> command = processingCommand.getMessage();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("PublishApplicationMessageAsync", () -> DefaultProcessingCommandHandler.publishMessageAsync$lambda-28(this, message), arg_0 -> DefaultProcessingCommandHandler.publishMessageAsync$lambda-30(this, processingCommand, message, future, arg_0), () -> DefaultProcessingCommandHandler.publishMessageAsync$lambda-31(message, command), null, retryTimes, true);
        return future;
    }

    private final HandlerFindResult getCommandHandler(ProcessingCommand processingCommand, Function<Class<?>, List<MessageHandlerData<CommandHandlerProxy>>> getHandlersFunc) {
        MessageHandlerData handlerData;
        CommandMessage<?> command = processingCommand.getMessage();
        List<MessageHandlerData<CommandHandlerProxy>> list = getHandlersFunc.apply(command.getClass());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getHandlersFunc.apply(command.javaClass)");
        List<MessageHandlerData<CommandHandlerProxy>> handlerDataList = list;
        if (handlerDataList.isEmpty()) {
            return HandlerFindResult.Companion.getNotFound();
        }
        if (handlerDataList.size() > 1) {
            return HandlerFindResult.Companion.getTooManyHandlerData();
        }
        MessageHandlerData messageHandlerData = (MessageHandlerData)CollectionsKt.firstOrNull(handlerDataList);
        if (messageHandlerData == null) {
            messageHandlerData = new MessageHandlerData();
        }
        if ((handlerData = messageHandlerData).getListHandlers().isEmpty()) {
            return HandlerFindResult.Companion.getNotFound();
        }
        if (handlerData.getListHandlers().size() > 1) {
            return HandlerFindResult.Companion.getTooManyHandler();
        }
        return new HandlerFindResult(HandlerFindStatus.Found, (CommandHandlerProxy)CollectionsKt.first(handlerData.getListHandlers()));
    }

    private final CompletableFuture<Boolean> completeCommand(ProcessingCommand processingCommand, CommandStatus commandStatus, String resultType, String result) {
        String string = processingCommand.getMessage().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processingCommand.message.id");
        CommandResult commandResult = new CommandResult(commandStatus, string, processingCommand.getMessage().getAggregateRootIdAsString(), result, resultType);
        return processingCommand.getMailBox().completeMessage(processingCommand, commandResult);
    }

    private static final List handleAsync$lambda-0(DefaultProcessingCommandHandler this$0, Class commandType) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)commandType, (String)"commandType");
        return this$0.commandHandlerProvider.getHandlers(commandType);
    }

    private static final CompletableFuture handleCommandInternal$lambda-1(CommandExecuteContext $commandContext, CommandHandlerProxy $commandHandler, CommandMessage $command) {
        Intrinsics.checkNotNullParameter((Object)$commandContext, (String)"$commandContext");
        Intrinsics.checkNotNullParameter((Object)$commandHandler, (String)"$commandHandler");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        $commandContext.clear();
        return FutureKt.asCompletableFuture((Deferred)BuildersKt.async$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($commandHandler, $commandContext, $command, null){
            int label;
            final /* synthetic */ CommandHandlerProxy $commandHandler;
            final /* synthetic */ CommandExecuteContext $commandContext;
            final /* synthetic */ CommandMessage<?> $command;
            {
                this.$commandHandler = $commandHandler;
                this.$commandContext = $commandContext;
                this.$command = $command;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.$commandHandler.handleAsync(this.$commandContext, this.$command, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    private static final void handleCommandInternal$lambda-8$lambda-2(CompletableFuture $taskSource, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        $taskSource.complete(true);
    }

    private static final void handleCommandInternal$lambda-8$lambda-3(CompletableFuture $taskSource, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        $taskSource.complete(true);
    }

    private static final void handleCommandInternal$lambda-8$lambda-5$lambda-4(CompletableFuture $taskSource, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        $taskSource.complete(true);
    }

    private static final Boolean handleCommandInternal$lambda-8$lambda-5(CommandHandlerProxy $commandHandler, CommandMessage $command, DefaultProcessingCommandHandler this$0, ProcessingCommand $processingCommand, CompletableFuture $taskSource, Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)$commandHandler, (String)"$commandHandler");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Object object = new Object[]{$commandHandler.getInnerObject().getClass().getName(), $command.getClass().getName(), $command.getId(), $command.getAggregateRootId(), ex};
        logger.error("Commit aggregate changes has unknown exception, this should not be happen, and we just complete the command, handlerType:{}, commandType:{}, commandId:{}, aggregateRootId:{}", object);
        object = ex.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ex.javaClass.name");
        this$0.completeCommand($processingCommand, CommandStatus.Failed, (String)object, "Unknown exception caught when committing changes of command.").whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-8$lambda-5$lambda-4($taskSource, arg_0, arg_1));
        return null;
    }

    private static final void handleCommandInternal$lambda-8$lambda-6(CompletableFuture $taskSource, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        $taskSource.complete(true);
    }

    private static final void handleCommandInternal$lambda-8$lambda-7(CompletableFuture $taskSource, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        $taskSource.complete(true);
    }

    private static final void handleCommandInternal$lambda-8(CommandHandlerProxy $commandHandler, CommandMessage $command, CommandExecuteContext $commandContext, DefaultProcessingCommandHandler this$0, ProcessingCommand $processingCommand, CompletableFuture $taskSource, Unit it) {
        Intrinsics.checkNotNullParameter((Object)$commandHandler, (String)"$commandHandler");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        Intrinsics.checkNotNullParameter((Object)$commandContext, (String)"$commandContext");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        if (logger.isDebugEnabled()) {
            Object[] objectArray = new Object[]{$commandHandler.getInnerObject().getClass().getName(), $command.getClass().getName(), $command.getId(), $command.getAggregateRootId()};
            logger.debug("Handle command success. handlerType:{}, commandType:{}, commandId:{}, aggregateRootId:{}", objectArray);
        }
        if ($commandContext.getApplicationMessage() != null) {
            this$0.commitChangesAsync($processingCommand, true, $commandContext.getApplicationMessage(), "").whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-8$lambda-2($taskSource, arg_0, arg_1));
        } else {
            try {
                ((CompletableFuture)this$0.commitAggregateChanges($processingCommand).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-8$lambda-3($taskSource, arg_0, arg_1))).exceptionally(arg_0 -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-8$lambda-5($commandHandler, $command, this$0, $processingCommand, $taskSource, arg_0));
            }
            catch (AggregateRootReferenceChangedException aggregateRootReferenceChangedException) {
                Object[] objectArray = new Object[]{aggregateRootReferenceChangedException.getAggregateRoot().getUniqueId(), aggregateRootReferenceChangedException.getAggregateRoot().getClass().getName(), $command.getId(), $command.getClass().getName(), $commandHandler.getInnerObject().getClass().getName()};
                logger.info("Aggregate root reference changed when processing command, try to re-handle the command. aggregateRootId: {}, aggregateRootType: {}, commandId: {}, commandType: {}, handlerType: {}", objectArray);
                this$0.handleCommandInternal($processingCommand, $commandHandler, 0).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-8$lambda-6($taskSource, arg_0, arg_1));
            }
            catch (Exception e) {
                Object object = new Object[]{$commandHandler.getInnerObject().getClass().getName(), $command.getClass().getName(), $command.getId(), $command.getAggregateRootId(), e};
                logger.error("Commit aggregate changes has unknown exception, this should not be happen, and we just complete the command, handlerType:{}, commandType:{}, commandId:{}, aggregateRootId:{}", object);
                object = e.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.javaClass.name");
                this$0.completeCommand($processingCommand, CommandStatus.Failed, (String)object, "Unknown exception caught when committing changes of command.").whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-8$lambda-7($taskSource, arg_0, arg_1));
            }
        }
    }

    private static final String handleCommandInternal$lambda-9(CommandMessage $command, CommandHandlerProxy $commandHandler) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        Intrinsics.checkNotNullParameter((Object)$commandHandler, (String)"$commandHandler");
        String string = "[command:[id:%s,type:%s],handlerType:%s,aggregateRootId:%s]";
        Object[] objectArray = new Object[]{$command.getId(), $command.getClass().getName(), $commandHandler.getInnerObject().getClass().getName(), $command.getAggregateRootId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final void handleCommandInternal$lambda-11$lambda-10(CompletableFuture $taskSource, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        $taskSource.complete(true);
    }

    private static final void handleCommandInternal$lambda-11(DefaultProcessingCommandHandler this$0, ProcessingCommand $processingCommand, CommandHandlerProxy $commandHandler, CompletableFuture $taskSource, Throwable ex, String errorMessage) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$commandHandler, (String)"$commandHandler");
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        Intrinsics.checkNotNullParameter((Object)ex, (String)"ex");
        Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
        this$0.handleExceptionAsync($processingCommand, $commandHandler, ex, errorMessage, 0).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleCommandInternal$lambda-11$lambda-10($taskSource, arg_0, arg_1));
    }

    private static final CompletableFuture republishCommandEvents$lambda-12(DefaultProcessingCommandHandler this$0, CommandMessage $command) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        EventStore eventStore = this$0.eventStore;
        String string = $command.getAggregateRootIdAsString();
        String string2 = $command.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"command.id");
        return eventStore.findAsync(string, string2);
    }

    private static final void republishCommandEvents$lambda-15$lambda-13(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void republishCommandEvents$lambda-15$lambda-14(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void republishCommandEvents$lambda-15(DefaultProcessingCommandHandler this$0, ProcessingCommand $processingCommand, CompletableFuture $future, DomainEventStream result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (result != null) {
            this$0.eventCommittingService.publishDomainEventAsync($processingCommand, result).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.republishCommandEvents$lambda-15$lambda-13($future, arg_0, arg_1));
        } else {
            String string = String.class.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
            this$0.completeCommand($processingCommand, CommandStatus.NothingChanged, string, $processingCommand.getCommandExecuteContext().getResult()).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.republishCommandEvents$lambda-15$lambda-14($future, arg_0, arg_1));
        }
    }

    private static final String republishCommandEvents$lambda-16(CommandMessage $command) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        String string = "[commandId:%s]";
        Object[] objectArray = new Object[]{$command.getId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final CompletableFuture handleExceptionAsync$lambda-17(DefaultProcessingCommandHandler this$0, CommandMessage $command) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        EventStore eventStore = this$0.eventStore;
        String string = $command.getAggregateRootIdAsString();
        String string2 = $command.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"command.id");
        return eventStore.findAsync(string, string2);
    }

    private static final void handleExceptionAsync$lambda-21$lambda-18(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void handleExceptionAsync$lambda-21$lambda-19(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void handleExceptionAsync$lambda-21$lambda-20(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void handleExceptionAsync$lambda-21(DefaultProcessingCommandHandler this$0, ProcessingCommand $processingCommand, Throwable $exception, CompletableFuture $future, DomainEventStream result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (result != null) {
            this$0.eventCommittingService.publishDomainEventAsync($processingCommand, result).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleExceptionAsync$lambda-21$lambda-18($future, arg_0, arg_1));
        } else {
            Throwable realException = this$0.getRealException($exception);
            if (realException instanceof DomainExceptionMessage) {
                this$0.publishExceptionAsync($processingCommand, (DomainExceptionMessage)((Object)realException), 0).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleExceptionAsync$lambda-21$lambda-19($future, arg_0, arg_1));
            } else {
                String string = realException.getClass().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"realException.javaClass.name");
                this$0.completeCommand($processingCommand, CommandStatus.Failed, string, realException.getMessage()).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.handleExceptionAsync$lambda-21$lambda-20($future, arg_0, arg_1));
            }
        }
    }

    private static final String handleExceptionAsync$lambda-22(CommandMessage $command, CommandHandlerProxy $commandHandler) {
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        Intrinsics.checkNotNullParameter((Object)$commandHandler, (String)"$commandHandler");
        String string = "[command:[id:%s,type:%s],handlerType:%s,aggregateRootId:%s]";
        Object[] objectArray = new Object[]{$command.getId(), $command.getClass().getName(), $commandHandler.getInnerObject().getClass().getName(), $command.getAggregateRootId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final boolean getRealException$lambda-23(Throwable x) {
        return x instanceof DomainExceptionMessage;
    }

    private static final CompletableFuture publishExceptionAsync$lambda-24(DefaultProcessingCommandHandler this$0, DomainExceptionMessage $exception) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        return this$0.exceptionPublisher.publishAsync((DomainExceptionMessage)((Message)$exception));
    }

    private static final void publishExceptionAsync$lambda-26$lambda-25(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void publishExceptionAsync$lambda-26(DefaultProcessingCommandHandler this$0, ProcessingCommand $processingCommand, DomainExceptionMessage $exception, CompletableFuture $future, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$exception, (String)"$exception");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        String string = $exception.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"exception.javaClass.name");
        this$0.completeCommand($processingCommand, CommandStatus.Failed, string, ((Exception)((Object)$exception)).getMessage()).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.publishExceptionAsync$lambda-26$lambda-25($future, arg_0, arg_1));
    }

    private static final String publishExceptionAsync$lambda-27(ProcessingCommand $processingCommand) {
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        return "[commandId: " + $processingCommand.getMessage().getId() + ']';
    }

    private static final CompletableFuture publishMessageAsync$lambda-28(DefaultProcessingCommandHandler this$0, ApplicationMessage $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        return this$0.applicationMessagePublisher.publishAsync((ApplicationMessage)((Message)$message));
    }

    private static final void publishMessageAsync$lambda-30$lambda-29(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void publishMessageAsync$lambda-30(DefaultProcessingCommandHandler this$0, ProcessingCommand $processingCommand, ApplicationMessage $message, CompletableFuture $future, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        String string = $message.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message.javaClass.name");
        this$0.completeCommand($processingCommand, CommandStatus.Success, string, this$0.serializeService.serialize($message)).whenComplete((arg_0, arg_1) -> DefaultProcessingCommandHandler.publishMessageAsync$lambda-30$lambda-29($future, arg_0, arg_1));
    }

    private static final String publishMessageAsync$lambda-31(ApplicationMessage $message, CommandMessage $command) {
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$command, (String)"$command");
        String string = "[application message:[id:%s,type:%s],command:[id:%s,type:%s]]";
        Object[] objectArray = new Object[]{$message.getId(), $message.getClass().getName(), $command.getId(), $command.getClass().getName()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/commanding/impl/DefaultProcessingCommandHandler$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[HandlerFindStatus.values().length];
            nArray[HandlerFindStatus.Found.ordinal()] = 1;
            nArray[HandlerFindStatus.TooManyHandlerData.ordinal()] = 2;
            nArray[HandlerFindStatus.TooManyHandler.ordinal()] = 3;
            nArray[HandlerFindStatus.NotFound.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

