/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.utils;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Assert {
    private Assert() {
    }

    public static <T> void nonNull(T expression, String message) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("%s should not be null.", message));
        }
    }

    public static void state(boolean state, Supplier<String> messageSupplier) {
        if (!state) {
            throw new IllegalStateException(messageSupplier.get());
        }
    }

    public static void isTrue(boolean expression, Supplier<String> messageSupplier) {
        if (!expression) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }

    public static void isFalse(boolean expression, Supplier<String> messageSupplier) {
        if (expression) {
            throw new IllegalArgumentException(messageSupplier.get());
        }
    }

    public static void notNull(Object value, Supplier<String> messageSupplier) {
        Assert.isTrue(value != null, messageSupplier);
    }

    public static <T> T nonNull(T value, Supplier<String> messageSupplier) {
        Assert.isTrue(value != null, messageSupplier);
        return value;
    }

    public static <T, X extends Throwable> void assertThat(T value, Predicate<T> assertion, Supplier<? extends X> exceptionSupplier) throws X {
        if (!assertion.test(value)) {
            throw (Throwable)exceptionSupplier.get();
        }
    }

    public static <T, X extends Throwable> void assertNonNull(T value, Supplier<? extends X> exceptionSupplier) throws X {
        Assert.assertThat(value, Objects::nonNull, exceptionSupplier);
    }
}

