/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.common.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Date;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/common/utils/DateUtil;", "", "()V", "parseDate", "Ljava/util/Date;", "value", "enode"})
public final class DateUtil {
    @NotNull
    public static final DateUtil INSTANCE = new DateUtil();

    private DateUtil() {
    }

    @JvmStatic
    @NotNull
    public static final Date parseDate(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof LocalDateTime) {
            Date date = Date.from(((LocalDateTime)value).atZone(ZoneId.systemDefault()).toInstant());
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(value.atZone(ZoneId\u2026emDefault()).toInstant())");
            return date;
        }
        if (value instanceof LocalDate) {
            Date date = Date.from(((LocalDate)value).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(value.atStartOfDay(\u2026emDefault()).toInstant())");
            return date;
        }
        if (value instanceof Instant) {
            Date date = Date.from((Instant)value);
            Intrinsics.checkNotNullExpressionValue((Object)date, (String)"from(value)");
            return date;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        return new Date();
    }
}

