/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.enodeframework.common.container.DefaultObjectContainer;
import org.enodeframework.common.function.Action2;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.AggregateRootInternalHandlerProvider;
import org.enodeframework.eventing.DomainEventMessage;
import org.enodeframework.eventing.DomainEventStream;

public abstract class AbstractAggregateRoot<TAggregateRootId>
implements AggregateRoot {
    private final AggregateRootInternalHandlerProvider aggregateRootInternalHandlerProvider;
    private final List<DomainEventMessage<?>> emptyEvents = new ArrayList();
    protected TAggregateRootId id;
    protected int version;
    private Queue<DomainEventMessage<?>> uncommittedEvents = new ConcurrentLinkedQueue();

    protected AbstractAggregateRoot() {
        this.aggregateRootInternalHandlerProvider = DefaultObjectContainer.resolve(AggregateRootInternalHandlerProvider.class);
    }

    protected AbstractAggregateRoot(TAggregateRootId id) {
        this(id, 0);
    }

    protected AbstractAggregateRoot(TAggregateRootId id, int version) {
        this();
        Assert.nonNull(id, "id");
        this.id = id;
        if (version < 0) {
            throw new IllegalArgumentException(String.format("Version cannot small than zero, aggregateRootId: %s, version: %d", id, version));
        }
        this.version = version;
    }

    public TAggregateRootId getId() {
        return this.id;
    }

    protected void applyEvent(DomainEventMessage<TAggregateRootId> domainEvent) {
        Assert.nonNull(domainEvent, "domainEvent");
        Assert.nonNull(this.id, "AggregateRootId");
        domainEvent.setAggregateRootId(this.id);
        domainEvent.setVersion(this.version + 1);
        this.handleEvent(domainEvent);
        this.appendUncommittedEvent(domainEvent);
    }

    protected void applyEvents(List<DomainEventMessage<TAggregateRootId>> domainEvents) {
        for (DomainEventMessage<TAggregateRootId> domainEvent : domainEvents) {
            this.applyEvent(domainEvent);
        }
    }

    private void handleEvent(DomainEventMessage<?> domainEvent) {
        Action2<AggregateRoot, DomainEventMessage<?>> handler = this.aggregateRootInternalHandlerProvider.getInternalEventHandler(this.getClass(), domainEvent.getClass());
        if (this.id == null && domainEvent.getVersion() == 1) {
            this.id = domainEvent.getAggregateRootId();
        }
        handler.apply(this, domainEvent);
    }

    private void appendUncommittedEvent(DomainEventMessage<TAggregateRootId> domainEvent) {
        if (this.uncommittedEvents == null) {
            this.uncommittedEvents = new ConcurrentLinkedQueue();
        }
        if (this.uncommittedEvents.stream().anyMatch(x -> x.getClass().equals(domainEvent.getClass()))) {
            throw new UnsupportedOperationException(String.format("Cannot apply duplicated domain event type: %s, current aggregateRoot type: %s, id: %s", domainEvent.getClass(), this.getClass().getName(), this.id));
        }
        this.uncommittedEvents.add(domainEvent);
    }

    private void verifyEvent(DomainEventStream eventStream) {
        if (eventStream.getVersion() > 1 && !eventStream.getAggregateRootId().equals(this.getUniqueId())) {
            throw new UnsupportedOperationException(String.format("Invalid domain event stream, aggregateRootId:%s, expected aggregateRootId:%s, type:%s", eventStream.getAggregateRootId(), this.getUniqueId(), this.getClass().getName()));
        }
        if (eventStream.getVersion() != this.getVersion() + 1) {
            throw new UnsupportedOperationException(String.format("Invalid domain event stream, version:%d, expected version:%d, current aggregateRoot type:%s, id:%s", eventStream.getVersion(), this.getVersion(), this.getClass().getName(), this.getUniqueId()));
        }
    }

    @Override
    public String getUniqueId() {
        return this.id.toString();
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    @Override
    public List<DomainEventMessage<?>> getChanges() {
        if (this.uncommittedEvents == null) {
            return this.emptyEvents;
        }
        return Lists.newArrayList(this.uncommittedEvents);
    }

    @Override
    public void acceptChanges() {
        if (this.uncommittedEvents == null || this.uncommittedEvents.isEmpty()) {
            return;
        }
        this.version = this.uncommittedEvents.peek().getVersion();
        this.uncommittedEvents.clear();
    }

    @Override
    public void replayEvents(List<DomainEventStream> eventStreams) {
        if (eventStreams == null || eventStreams.isEmpty()) {
            return;
        }
        eventStreams.forEach(eventStream -> {
            this.verifyEvent((DomainEventStream)eventStream);
            eventStream.getEvents().forEach(this::handleEvent);
            this.version = eventStream.getVersion();
        });
    }
}

