/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain;

import java.util.Date;
import org.enodeframework.common.extensions.SystemClock;
import org.enodeframework.domain.AggregateRoot;

public class AggregateCacheInfo {
    private AggregateRoot aggregateRoot;
    private Date lastUpdateTime;

    public AggregateCacheInfo(AggregateRoot aggregateRoot) {
        this.aggregateRoot = aggregateRoot;
        this.lastUpdateTime = new Date();
    }

    public void updateAggregateRoot(AggregateRoot aggregateRoot) {
        this.aggregateRoot = aggregateRoot;
        this.lastUpdateTime = new Date();
    }

    public boolean isExpired(int timeoutSeconds) {
        return (SystemClock.now() - this.lastUpdateTime.getTime()) / 1000L >= (long)timeoutSeconds;
    }

    public AggregateRoot getAggregateRoot() {
        return this.aggregateRoot;
    }

    public void setAggregateRoot(AggregateRoot aggregateRoot) {
        this.aggregateRoot = aggregateRoot;
    }

    public Date getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }
}

