/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.concurrent.CompletableFuture;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.domain.AggregateRepositoryProvider;
import org.enodeframework.domain.AggregateRepositoryProxy;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.AggregateSnapshotter;

public class DefaultAggregateSnapshotter
implements AggregateSnapshotter {
    private final AggregateRepositoryProvider aggregateRepositoryProvider;

    public DefaultAggregateSnapshotter(AggregateRepositoryProvider aggregateRepositoryProvider) {
        this.aggregateRepositoryProvider = aggregateRepositoryProvider;
    }

    @Override
    public <T extends AggregateRoot> CompletableFuture<T> restoreFromSnapshotAsync(Class<T> aggregateRootType, String aggregateRootId) {
        AggregateRepositoryProxy aggregateRepository = this.aggregateRepositoryProvider.getRepository(aggregateRootType);
        return this.tryGetAggregateAsync(aggregateRepository, aggregateRootType, aggregateRootId, 0);
    }

    private <T extends AggregateRoot> CompletableFuture<T> tryGetAggregateAsync(AggregateRepositoryProxy aggregateRepository, Class<?> aggregateRootType, String aggregateRootId, int retryTimes) {
        CompletableFuture<Object> taskSource = new CompletableFuture<Object>();
        if (aggregateRepository == null) {
            taskSource.complete(null);
            return taskSource;
        }
        IOHelper.tryAsyncActionRecursively("TryGetAggregateAsync", () -> aggregateRepository.getAsync(aggregateRootId), result -> taskSource.complete(result), () -> String.format("aggregateRepository.getAsync has unknown exception, aggregateRepository: %s, aggregateRootTypeName: %s, aggregateRootId: %s", aggregateRepository.getClass().getName(), aggregateRootType.getName(), aggregateRootId), null, retryTimes, true);
        return taskSource;
    }
}

