/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.exception.AggregateRootReferenceChangedException;
import org.enodeframework.common.exception.AggregateRootTypeNotMatchException;
import org.enodeframework.common.scheduling.ScheduleService;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateCacheInfo;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.AggregateStorage;
import org.enodeframework.domain.MemoryCache;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 +2\u00020\u0001:\u0001+B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\u0019\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\u001bH\u0016\u00a2\u0006\u0002\u0010\u001eJ\b\u0010\u001f\u001a\u00020\u001aH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0!2\u0006\u0010\"\u001a\u00020\u000eH\u0016J.\u0010 \u001a\b\u0012\u0004\u0012\u0002H\u001b0!\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\"\u001a\u00020\u000e2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001b0$H\u0016J\u001f\u0010%\u001a\u00020\u001a\"\b\b\u0000\u0010\u001b*\u00020\u001c2\u0006\u0010\u001d\u001a\u0002H\u001bH\u0016\u00a2\u0006\u0002\u0010\u001eJ.\u0010&\u001a\b\u0012\u0004\u0012\u0002H\u001b0!\"\b\b\u0000\u0010\u001b*\u00020\u001c2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001b0$2\u0006\u0010\"\u001a\u00020\u000bH\u0016J\u001e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0!2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020\u000bH\u0016J$\u0010(\u001a\u00020\u001a2\n\u0010#\u001a\u0006\u0012\u0002\b\u00030$2\u0006\u0010\"\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\u001cH\u0002J\b\u0010)\u001a\u00020\u001aH\u0016J\b\u0010*\u001a\u00020\u001aH\u0016R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/enodeframework/domain/impl/DefaultMemoryCache;", "Lorg/enodeframework/domain/MemoryCache;", "aggregateStorage", "Lorg/enodeframework/domain/AggregateStorage;", "scheduleService", "Lorg/enodeframework/common/scheduling/ScheduleService;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "(Lorg/enodeframework/domain/AggregateStorage;Lorg/enodeframework/common/scheduling/ScheduleService;Lorg/enodeframework/infrastructure/TypeNameProvider;)V", "aggregateRootInfoDict", "Ljava/util/concurrent/ConcurrentMap;", "", "Lorg/enodeframework/domain/AggregateCacheInfo;", "lockObj", "", "scanExpiredAggregateIntervalMilliseconds", "", "getScanExpiredAggregateIntervalMilliseconds", "()I", "setScanExpiredAggregateIntervalMilliseconds", "(I)V", "taskName", "timeoutSeconds", "getTimeoutSeconds", "setTimeoutSeconds", "acceptAggregateRootChanges", "", "T", "Lorg/enodeframework/domain/AggregateRoot;", "aggregateRoot", "(Lorg/enodeframework/domain/AggregateRoot;)V", "cleanInactiveAggregateRoot", "getAsync", "Ljava/util/concurrent/CompletableFuture;", "aggregateRootId", "aggregateRootType", "Ljava/lang/Class;", "refreshAggregate", "refreshAggregateFromEventStoreAsync", "aggregateRootTypeName", "resetAggregateRootCache", "start", "stop", "Companion", "enode"})
public final class DefaultMemoryCache
implements MemoryCache {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AggregateStorage aggregateStorage;
    @NotNull
    private final ScheduleService scheduleService;
    @NotNull
    private final TypeNameProvider typeNameProvider;
    @NotNull
    private final ConcurrentMap<String, AggregateCacheInfo> aggregateRootInfoDict;
    @NotNull
    private final Object lockObj;
    @NotNull
    private final String taskName;
    private int timeoutSeconds;
    private int scanExpiredAggregateIntervalMilliseconds;
    private static final Logger logger = LoggerFactory.getLogger(DefaultMemoryCache.class);

    public DefaultMemoryCache(@NotNull AggregateStorage aggregateStorage, @NotNull ScheduleService scheduleService, @NotNull TypeNameProvider typeNameProvider) {
        Intrinsics.checkNotNullParameter((Object)aggregateStorage, (String)"aggregateStorage");
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        this.aggregateStorage = aggregateStorage;
        this.scheduleService = scheduleService;
        this.typeNameProvider = typeNameProvider;
        this.lockObj = new Object();
        this.timeoutSeconds = 5000;
        this.scanExpiredAggregateIntervalMilliseconds = 5000;
        this.aggregateRootInfoDict = new ConcurrentHashMap();
        this.taskName = "CleanInactiveAggregates_" + System.nanoTime() + new Random().nextInt(10000);
    }

    public final int getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public final void setTimeoutSeconds(int n) {
        this.timeoutSeconds = n;
    }

    public final int getScanExpiredAggregateIntervalMilliseconds() {
        return this.scanExpiredAggregateIntervalMilliseconds;
    }

    public final void setScanExpiredAggregateIntervalMilliseconds(int n) {
        this.scanExpiredAggregateIntervalMilliseconds = n;
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> getAsync(@NotNull Object aggregateRootId, @NotNull Class<T> aggregateRootType) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Assert.nonNull(aggregateRootId, "aggregateRootId");
        Assert.nonNull(aggregateRootType, "aggregateRootType");
        CompletableFuture<AggregateRoot> future = new CompletableFuture<AggregateRoot>();
        AggregateCacheInfo aggregateRootInfo = (AggregateCacheInfo)this.aggregateRootInfoDict.get(aggregateRootId.toString());
        if (aggregateRootInfo == null) {
            future.complete(null);
            return future;
        }
        AggregateRoot aggregateRoot = aggregateRootInfo.getAggregateRoot();
        if (aggregateRoot == null) {
            throw new NullPointerException("null cannot be cast to non-null type T of org.enodeframework.domain.impl.DefaultMemoryCache.getAsync");
        }
        AggregateRoot aggregateRoot2 = aggregateRoot;
        if (!Intrinsics.areEqual(aggregateRootInfo.getAggregateRoot().getClass(), aggregateRootType)) {
            String string = "Incorrect aggregate root type, aggregateRootId:%s, type:%s, expecting type:%s";
            Object[] objectArray = new Object[]{aggregateRootId, aggregateRootInfo.getAggregateRoot().getClass(), aggregateRootType};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new AggregateRootTypeNotMatchException(string2);
        }
        if (aggregateRoot2.getChanges().size() > 0) {
            CompletableFuture<T> latestAggregateRootFuture = this.aggregateStorage.getAsync(aggregateRootType, aggregateRootId.toString());
            CompletionStage completionStage = latestAggregateRootFuture.thenApply(arg_0 -> DefaultMemoryCache.getAsync$lambda-0(this, aggregateRootType, aggregateRootId, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"latestAggregateRootFutur\u2026teRoot as T\n            }");
            return completionStage;
        }
        future.complete(aggregateRoot2);
        return future;
    }

    @Override
    @NotNull
    public CompletableFuture<AggregateRoot> getAsync(@NotNull Object aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        return this.getAsync(aggregateRootId, AggregateRoot.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends AggregateRoot> void acceptAggregateRootChanges(@NotNull T aggregateRoot) {
        Intrinsics.checkNotNullParameter(aggregateRoot, (String)"aggregateRoot");
        Object object = this.lockObj;
        synchronized (object) {
            boolean bl = false;
            AtomicBoolean cacheReset = new AtomicBoolean(false);
            AggregateCacheInfo cacheInfo = this.aggregateRootInfoDict.computeIfAbsent(aggregateRoot.getUniqueId(), arg_0 -> DefaultMemoryCache.acceptAggregateRootChanges$lambda-2$lambda-1(aggregateRoot, cacheReset, arg_0));
            if (cacheReset.get()) {
                return;
            }
            AggregateCacheInfo aggregateCacheInfo = cacheInfo;
            Intrinsics.checkNotNull((Object)aggregateCacheInfo);
            int aggregateRootOldVersion = aggregateCacheInfo.getAggregateRoot().getVersion();
            if (aggregateRoot.getVersion() > 1 && cacheInfo.getAggregateRoot() != aggregateRoot) {
                throw new AggregateRootReferenceChangedException(aggregateRoot);
            }
            aggregateRoot.acceptChanges();
            cacheInfo.updateAggregateRoot(aggregateRoot);
            Object[] objectArray = new Object[]{aggregateRoot.getClass().getName(), aggregateRoot.getUniqueId(), aggregateRoot.getVersion(), aggregateRootOldVersion};
            logger.info("Aggregate root in-memory cache changed, aggregateRootType: {}, aggregateRootId: {}, aggregateRootNewVersion: {}, aggregateRootOldVersion: {}", objectArray);
            Unit unit = Unit.INSTANCE;
        }
    }

    @Override
    public <T extends AggregateRoot> void refreshAggregate(@NotNull T aggregateRoot) {
        Intrinsics.checkNotNullParameter(aggregateRoot, (String)"aggregateRoot");
        Class<?> clazz = aggregateRoot.getClass();
        String string = aggregateRoot.getUniqueId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"aggregateRoot.uniqueId");
        this.resetAggregateRootCache(clazz, string, aggregateRoot);
    }

    @Override
    @NotNull
    public CompletableFuture<AggregateRoot> refreshAggregateFromEventStoreAsync(@NotNull String aggregateRootTypeName, @NotNull String aggregateRootId) {
        CompletableFuture<AggregateRoot> completableFuture;
        Intrinsics.checkNotNullParameter((Object)aggregateRootTypeName, (String)"aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Assert.nonNull(aggregateRootTypeName, "aggregateRootTypeName");
        CompletableFuture<AggregateRoot> future = new CompletableFuture<AggregateRoot>();
        try {
            Class<?> aggregateRootType = this.typeNameProvider.getType(aggregateRootTypeName);
            completableFuture = this.refreshAggregateFromEventStoreAsync(aggregateRootType, aggregateRootId);
        }
        catch (Exception e) {
            future.completeExceptionally(e);
            completableFuture = future;
        }
        return completableFuture;
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> refreshAggregateFromEventStoreAsync(@NotNull Class<T> aggregateRootType, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Assert.nonNull(aggregateRootId, "aggregateRootId");
        Assert.nonNull(aggregateRootType, "aggregateRootType");
        CompletionStage completionStage = ((CompletableFuture)this.aggregateStorage.getAsync(aggregateRootType, aggregateRootId).thenApply(arg_0 -> DefaultMemoryCache.refreshAggregateFromEventStoreAsync$lambda-3(this, aggregateRootType, aggregateRootId, arg_0))).exceptionally(arg_0 -> DefaultMemoryCache.refreshAggregateFromEventStoreAsync$lambda-4(this, aggregateRootType, aggregateRootId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"aggregateStorage.getAsyn\u2026           null\n        }");
        return completionStage;
    }

    @Override
    public void start() {
        this.scheduleService.startTask(this.taskName, () -> DefaultMemoryCache.start$lambda-5(this), this.scanExpiredAggregateIntervalMilliseconds, this.scanExpiredAggregateIntervalMilliseconds);
    }

    @Override
    public void stop() {
        this.scheduleService.stopTask(this.taskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void resetAggregateRootCache(Class<?> aggregateRootType, String aggregateRootId, AggregateRoot aggregateRoot) {
        Object[] objectArray;
        AggregateCacheInfo aggregateCacheInfo = (AggregateCacheInfo)this.aggregateRootInfoDict.remove(aggregateRootId);
        if (aggregateCacheInfo != null) {
            objectArray = new Object[]{aggregateRootType.getName(), aggregateRootId, aggregateCacheInfo.getAggregateRoot().getVersion()};
            logger.info("Removed dirty in-memory aggregate, aggregateRootType: {}, aggregateRootId: {}, version: {}", objectArray);
        }
        objectArray = this.lockObj;
        synchronized (objectArray) {
            boolean bl = false;
            AtomicBoolean cacheReset = new AtomicBoolean(false);
            AggregateCacheInfo cacheInfo = this.aggregateRootInfoDict.computeIfAbsent(aggregateRoot.getUniqueId(), arg_0 -> DefaultMemoryCache.resetAggregateRootCache$lambda-7$lambda-6(aggregateRoot, cacheReset, arg_0));
            if (cacheReset.get()) {
                return;
            }
            AggregateCacheInfo aggregateCacheInfo2 = cacheInfo;
            Intrinsics.checkNotNull((Object)aggregateCacheInfo2);
            int aggregateRootOldVersion = aggregateCacheInfo2.getAggregateRoot().getVersion();
            cacheInfo.updateAggregateRoot(aggregateRoot);
            if (logger.isDebugEnabled()) {
                Object[] objectArray2 = new Object[]{aggregateRoot.getClass().getName(), aggregateRoot.getUniqueId(), aggregateRoot.getVersion(), aggregateRootOldVersion};
                logger.debug("Aggregate root in-memory cache reset, aggregateRootType: {}, aggregateRootId: {}, aggregateRootNewVersion: {}, aggregateRootOldVersion: {}", objectArray2);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanInactiveAggregateRoot() {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = this.aggregateRootInfoDict.entrySet();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            if (!((AggregateCacheInfo)entry.getValue()).isExpired(this.getTimeoutSeconds())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inactiveList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = inactiveList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry entry = (Map.Entry)element$iv;
            boolean bl = false;
            if (this.aggregateRootInfoDict.remove(entry.getKey()) == null) continue;
            logger.info("Removed inactive aggregate root, id: {}", entry.getKey());
        }
    }

    private static final AggregateRoot getAsync$lambda-0(DefaultMemoryCache this$0, Class $aggregateRootType, Object $aggregateRootId, AggregateRoot latestAggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)latestAggregateRoot, (String)"latestAggregateRoot");
        this$0.resetAggregateRootCache($aggregateRootType, $aggregateRootId.toString(), latestAggregateRoot);
        return latestAggregateRoot;
    }

    private static final AggregateCacheInfo acceptAggregateRootChanges$lambda-2$lambda-1(AggregateRoot $aggregateRoot, AtomicBoolean $cacheReset, String it) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRoot, (String)"$aggregateRoot");
        Intrinsics.checkNotNullParameter((Object)$cacheReset, (String)"$cacheReset");
        $aggregateRoot.acceptChanges();
        $cacheReset.set(true);
        Object[] objectArray = new Object[]{$aggregateRoot.getClass().getName(), $aggregateRoot.getUniqueId(), $aggregateRoot.getVersion()};
        logger.info("Aggregate root in-memory cache initialized, aggregateRootType: {}, aggregateRootId: {}, aggregateRootVersion: {}", objectArray);
        return new AggregateCacheInfo($aggregateRoot);
    }

    private static final AggregateRoot refreshAggregateFromEventStoreAsync$lambda-3(DefaultMemoryCache this$0, Class $aggregateRootType, String $aggregateRootId, AggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)aggregateRoot, (String)"aggregateRoot");
        this$0.resetAggregateRootCache($aggregateRootType, $aggregateRootId, aggregateRoot);
        return aggregateRoot;
    }

    private static final AggregateRoot refreshAggregateFromEventStoreAsync$lambda-4(DefaultMemoryCache this$0, Class $aggregateRootType, String $aggregateRootId, Throwable ex) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Object[] objectArray = new Object[]{this$0.typeNameProvider.getTypeName($aggregateRootType), $aggregateRootId, ex};
        logger.error("Refresh aggregate from event store has unknown exception, aggregateRootTypeName:{}, aggregateRootId:{}", objectArray);
        return null;
    }

    private static final void start$lambda-5(DefaultMemoryCache this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cleanInactiveAggregateRoot();
    }

    private static final AggregateCacheInfo resetAggregateRootCache$lambda-7$lambda-6(AggregateRoot $aggregateRoot, AtomicBoolean $cacheReset, String it) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRoot, (String)"$aggregateRoot");
        Intrinsics.checkNotNullParameter((Object)$cacheReset, (String)"$cacheReset");
        if (logger.isDebugEnabled()) {
            Object[] objectArray = new Object[]{$aggregateRoot.getClass().getName(), $aggregateRoot.getUniqueId(), $aggregateRoot.getVersion()};
            logger.debug("Aggregate root in-memory cache reset, aggregateRootType: {}, aggregateRootId: {}, aggregateRootVersion: {}", objectArray);
        }
        $cacheReset.set(true);
        return new AggregateCacheInfo($aggregateRoot);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/domain/impl/DefaultMemoryCache$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

