/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.concurrent.CompletableFuture;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.MemoryCache;
import org.enodeframework.domain.Repository;

public class DefaultRepository
implements Repository {
    private final MemoryCache memoryCache;

    public DefaultRepository(MemoryCache memoryCache) {
        this.memoryCache = memoryCache;
    }

    @Override
    public <T extends AggregateRoot> CompletableFuture<T> getAsync(Class<T> aggregateRootType, Object aggregateRootId) {
        Assert.nonNull(aggregateRootType, "aggregateRootType");
        Assert.nonNull(aggregateRootId, "aggregateRootId");
        CompletableFuture<T> future = this.memoryCache.getAsync(aggregateRootId, aggregateRootType);
        return future.thenCompose(aggregateRoot -> {
            if (aggregateRoot == null) {
                return this.memoryCache.refreshAggregateFromEventStoreAsync(aggregateRootType, aggregateRootId.toString());
            }
            return CompletableFuture.completedFuture(aggregateRoot);
        });
    }

    @Override
    public CompletableFuture<AggregateRoot> getAsync(Object aggregateRootId) {
        return this.getAsync(AggregateRoot.class, aggregateRootId);
    }

    @Override
    public <T extends AggregateRoot> void refreshAggregate(T aggregateRoot) {
        this.memoryCache.refreshAggregate(aggregateRoot);
    }
}

