/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.domain.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.exception.AggregateRootInvalidException;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.utils.Assert;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.AggregateRootFactory;
import org.enodeframework.domain.AggregateSnapshotter;
import org.enodeframework.domain.AggregateStorage;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventStore;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ0\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J7\u0010\u0013\u001a\u0004\u0018\u0001H\r\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015H\u0002\u00a2\u0006\u0002\u0010\u0017J0\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u0010H\u0002JH\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u00150\f2\n\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0002J8\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\n\b\u0000\u0010\r*\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\r0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001cH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/enodeframework/domain/impl/EventSourcingAggregateStorage;", "Lorg/enodeframework/domain/AggregateStorage;", "eventStore", "Lorg/enodeframework/eventing/EventStore;", "aggregateRootFactory", "Lorg/enodeframework/domain/AggregateRootFactory;", "aggregateSnapshotter", "Lorg/enodeframework/domain/AggregateSnapshotter;", "typeNameProvider", "Lorg/enodeframework/infrastructure/TypeNameProvider;", "(Lorg/enodeframework/eventing/EventStore;Lorg/enodeframework/domain/AggregateRootFactory;Lorg/enodeframework/domain/AggregateSnapshotter;Lorg/enodeframework/infrastructure/TypeNameProvider;)V", "getAsync", "Ljava/util/concurrent/CompletableFuture;", "T", "Lorg/enodeframework/domain/AggregateRoot;", "aggregateRootType", "Ljava/lang/Class;", "aggregateRootId", "", "rebuildAggregateRoot", "eventStreams", "", "Lorg/enodeframework/eventing/DomainEventStream;", "(Ljava/lang/Class;Ljava/util/List;)Lorg/enodeframework/domain/AggregateRoot;", "tryGetFromSnapshot", "tryQueryAggregateEventsAsync", "aggregateRootTypeName", "minVersion", "", "maxVersion", "retryTimes", "tryRestoreFromSnapshotAsync", "Companion", "enode"})
public final class EventSourcingAggregateStorage
implements AggregateStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final AggregateRootFactory aggregateRootFactory;
    @NotNull
    private final AggregateSnapshotter aggregateSnapshotter;
    @NotNull
    private final TypeNameProvider typeNameProvider;
    private static final int MIN_VERSION = 1;
    private static final int MAX_VERSION = Integer.MAX_VALUE;

    public EventSourcingAggregateStorage(@NotNull EventStore eventStore, @NotNull AggregateRootFactory aggregateRootFactory, @NotNull AggregateSnapshotter aggregateSnapshotter, @NotNull TypeNameProvider typeNameProvider) {
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)aggregateRootFactory, (String)"aggregateRootFactory");
        Intrinsics.checkNotNullParameter((Object)aggregateSnapshotter, (String)"aggregateSnapshotter");
        Intrinsics.checkNotNullParameter((Object)typeNameProvider, (String)"typeNameProvider");
        this.eventStore = eventStore;
        this.aggregateRootFactory = aggregateRootFactory;
        this.aggregateSnapshotter = aggregateSnapshotter;
        this.typeNameProvider = typeNameProvider;
    }

    @Override
    @NotNull
    public <T extends AggregateRoot> CompletableFuture<T> getAsync(@NotNull Class<T> aggregateRootType, @NotNull String aggregateRootId) {
        Intrinsics.checkNotNullParameter(aggregateRootType, (String)"aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)aggregateRootId, (String)"aggregateRootId");
        Assert.nonNull(aggregateRootId, "aggregateRootId");
        Assert.nonNull(aggregateRootType, "aggregateRootType");
        CompletionStage completionStage = this.tryGetFromSnapshot(aggregateRootId, aggregateRootType).thenCompose(arg_0 -> EventSourcingAggregateStorage.getAsync$lambda-1(this, aggregateRootType, aggregateRootId, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"tryGetFromSnapshot(aggre\u2026)\n            }\n        }");
        return completionStage;
    }

    private final <T extends AggregateRoot> CompletableFuture<T> tryRestoreFromSnapshotAsync(Class<T> aggregateRootType, String aggregateRootId, int retryTimes) {
        CompletableFuture taskSource = new CompletableFuture();
        IOHelper.tryAsyncActionRecursively("TryRestoreFromSnapshotAsync", () -> EventSourcingAggregateStorage.tryRestoreFromSnapshotAsync$lambda-2(this, aggregateRootType, aggregateRootId), arg_0 -> EventSourcingAggregateStorage.tryRestoreFromSnapshotAsync$lambda-3(taskSource, arg_0), () -> EventSourcingAggregateStorage.tryRestoreFromSnapshotAsync$lambda-4(aggregateRootType, aggregateRootId), null, retryTimes, true);
        return taskSource;
    }

    private final CompletableFuture<List<DomainEventStream>> tryQueryAggregateEventsAsync(Class<?> aggregateRootType, String aggregateRootTypeName, String aggregateRootId, int minVersion, int maxVersion, int retryTimes) {
        CompletableFuture<List<DomainEventStream>> taskSource = new CompletableFuture<List<DomainEventStream>>();
        IOHelper.tryAsyncActionRecursively("TryQueryAggregateEventsAsync", () -> EventSourcingAggregateStorage.tryQueryAggregateEventsAsync$lambda-5(this, aggregateRootId, aggregateRootTypeName, minVersion, maxVersion), arg_0 -> EventSourcingAggregateStorage.tryQueryAggregateEventsAsync$lambda-6(taskSource, arg_0), () -> EventSourcingAggregateStorage.tryQueryAggregateEventsAsync$lambda-7(aggregateRootTypeName, aggregateRootId), null, retryTimes, true);
        return taskSource;
    }

    private final <T extends AggregateRoot> CompletableFuture<T> tryGetFromSnapshot(String aggregateRootId, Class<T> aggregateRootType) {
        CompletableFuture<T> aggregateRootFuture = this.tryRestoreFromSnapshotAsync(aggregateRootType, aggregateRootId, 0);
        CompletionStage completionStage = aggregateRootFuture.thenCompose(arg_0 -> EventSourcingAggregateStorage.tryGetFromSnapshot$lambda-9(aggregateRootType, aggregateRootId, this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"aggregateRootFuture.then\u2026t\n            }\n        }");
        return completionStage;
    }

    private final <T extends AggregateRoot> T rebuildAggregateRoot(Class<T> aggregateRootType, List<? extends DomainEventStream> eventStreams) {
        T aggregateRoot;
        boolean it = !((Collection)eventStreams).isEmpty();
        boolean bl = false;
        T t = aggregateRoot = this.aggregateRootFactory.createAggregateRoot(aggregateRootType);
        if (t != null) {
            t.replayEvents(eventStreams);
        }
        return aggregateRoot;
    }

    private static final AggregateRoot getAsync$lambda-1$lambda-0(EventSourcingAggregateStorage this$0, Class $aggregateRootType, List eventStreams) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)eventStreams, (String)"eventStreams");
        return this$0.rebuildAggregateRoot($aggregateRootType, eventStreams);
    }

    private static final CompletionStage getAsync$lambda-1(EventSourcingAggregateStorage this$0, Class $aggregateRootType, String $aggregateRootId, AggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        if (aggregateRoot != null) {
            return CompletableFuture.completedFuture(aggregateRoot);
        }
        String aggregateRootTypeName = this$0.typeNameProvider.getTypeName($aggregateRootType);
        return this$0.tryQueryAggregateEventsAsync($aggregateRootType, aggregateRootTypeName, $aggregateRootId, 1, Integer.MAX_VALUE, 0).thenApply(arg_0 -> EventSourcingAggregateStorage.getAsync$lambda-1$lambda-0(this$0, $aggregateRootType, arg_0));
    }

    private static final CompletableFuture tryRestoreFromSnapshotAsync$lambda-2(EventSourcingAggregateStorage this$0, Class $aggregateRootType, String $aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        return this$0.aggregateSnapshotter.restoreFromSnapshotAsync($aggregateRootType, $aggregateRootId);
    }

    private static final void tryRestoreFromSnapshotAsync$lambda-3(CompletableFuture $taskSource, AggregateRoot value) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        $taskSource.complete(value);
    }

    private static final String tryRestoreFromSnapshotAsync$lambda-4(Class $aggregateRootType, String $aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        String string = "tryRestoreFromSnapshotAsync has unknown exception, aggregateRootType: %s, aggregateRootId: %s";
        Object[] objectArray = new Object[]{$aggregateRootType.getName(), $aggregateRootId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final CompletableFuture tryQueryAggregateEventsAsync$lambda-5(EventSourcingAggregateStorage this$0, String $aggregateRootId, String $aggregateRootTypeName, int $minVersion, int $maxVersion) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootTypeName, (String)"$aggregateRootTypeName");
        return this$0.eventStore.queryAggregateEventsAsync($aggregateRootId, $aggregateRootTypeName, $minVersion, $maxVersion);
    }

    private static final void tryQueryAggregateEventsAsync$lambda-6(CompletableFuture $taskSource, List value) {
        Intrinsics.checkNotNullParameter((Object)$taskSource, (String)"$taskSource");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        $taskSource.complete(value);
    }

    private static final String tryQueryAggregateEventsAsync$lambda-7(String $aggregateRootTypeName, String $aggregateRootId) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRootTypeName, (String)"$aggregateRootTypeName");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        String string = "eventStore.queryAggregateEventsAsync has unknown exception, aggregateRootTypeName: %s, aggregateRootId: %s";
        Object[] objectArray = new Object[]{$aggregateRootTypeName, $aggregateRootId};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final AggregateRoot tryGetFromSnapshot$lambda-9$lambda-8(AggregateRoot $aggregateRoot, List eventStreams) {
        $aggregateRoot.replayEvents(eventStreams);
        return $aggregateRoot;
    }

    private static final CompletionStage tryGetFromSnapshot$lambda-9(Class $aggregateRootType, String $aggregateRootId, EventSourcingAggregateStorage this$0, AggregateRoot aggregateRoot) {
        Intrinsics.checkNotNullParameter((Object)$aggregateRootType, (String)"$aggregateRootType");
        Intrinsics.checkNotNullParameter((Object)$aggregateRootId, (String)"$aggregateRootId");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if (aggregateRoot == null) {
            return CompletableFuture.completedFuture(aggregateRoot);
        }
        if (!Intrinsics.areEqual(aggregateRoot.getClass(), (Object)$aggregateRootType) || !Intrinsics.areEqual((Object)aggregateRoot.getUniqueId(), (Object)$aggregateRootId)) {
            String string = "AggregateRoot recovery from snapshot is invalid as the aggregateRootType or aggregateRootId is not matched. Snapshot: [aggregateRootType: %s, aggregateRootId: %s], expected: [aggregateRootType: %s, aggregateRootId: %s]";
            Object[] objectArray = new Object[]{aggregateRoot.getClass(), aggregateRoot.getUniqueId(), $aggregateRootType, $aggregateRootId};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            throw new AggregateRootInvalidException(string2);
        }
        String aggregateRootTypeName = this$0.typeNameProvider.getTypeName($aggregateRootType);
        CompletableFuture<List<DomainEventStream>> eventStreamsFuture = this$0.tryQueryAggregateEventsAsync($aggregateRootType, aggregateRootTypeName, $aggregateRootId, aggregateRoot.getVersion() + 1, Integer.MAX_VALUE, 0);
        return eventStreamsFuture.thenApply(arg_0 -> EventSourcingAggregateStorage.tryGetFromSnapshot$lambda-9$lambda-8(aggregateRoot, arg_0));
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/domain/impl/EventSourcingAggregateStorage$Companion;", "", "()V", "MAX_VERSION", "", "MIN_VERSION", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

