/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.enodeframework.common.exception.DomainEventInvalidException;
import org.enodeframework.eventing.DomainEventMessage;
import org.enodeframework.messaging.AbstractMessage;

public class DomainEventStream
extends AbstractMessage {
    private String commandId;
    private String aggregateRootTypeName;
    private String aggregateRootId;
    private int version;
    private List<DomainEventMessage<?>> events;

    public DomainEventStream() {
    }

    public DomainEventStream(String commandId, String aggregateRootId, int version, String aggregateRootTypeName, List<DomainEventMessage<?>> events, Map<String, Object> items) {
        this.commandId = commandId;
        this.aggregateRootId = aggregateRootId;
        this.aggregateRootTypeName = aggregateRootTypeName;
        this.version = version;
        this.events = events;
        this.items = items;
    }

    public DomainEventStream(String commandId, String aggregateRootId, String aggregateRootTypeName, Date timestamp, List<DomainEventMessage<?>> events, Map<String, Object> items) {
        if (events == null || events.isEmpty()) {
            throw new IllegalArgumentException(String.format("events cannot be empty. aggregateRootId: %s", aggregateRootId));
        }
        this.commandId = commandId;
        this.aggregateRootId = aggregateRootId;
        this.aggregateRootTypeName = aggregateRootTypeName;
        this.version = events.stream().findFirst().map(DomainEventMessage::getVersion).orElse(0);
        this.timestamp = timestamp;
        this.events = events;
        this.items = items == null ? new HashMap<String, Object>() : items;
        this.id = aggregateRootId + "_" + this.version;
        int sequence = 1;
        for (DomainEventMessage<?> event : events) {
            if (event.getVersion() != this.getVersion()) {
                throw new DomainEventInvalidException(String.format("Invalid domain event version, aggregateRootTypeName: %s aggregateRootId: %s expected version: %d, but was: %d", aggregateRootTypeName, aggregateRootId, this.version, event.getVersion()));
            }
            event.setCommandId(commandId);
            event.setAggregateRootTypeName(aggregateRootTypeName);
            event.setSequence(sequence++);
            event.setTimestamp(timestamp);
            event.mergeItems(items);
        }
    }

    public List<DomainEventMessage<?>> getEvents() {
        return this.events;
    }

    public void setEvents(List<DomainEventMessage<?>> events) {
        this.events = events;
    }

    public String getCommandId() {
        return this.commandId;
    }

    public void setCommandId(String commandId) {
        this.commandId = commandId;
    }

    public String getAggregateRootTypeName() {
        return this.aggregateRootTypeName;
    }

    public void setAggregateRootTypeName(String aggregateRootTypeName) {
        this.aggregateRootTypeName = aggregateRootTypeName;
    }

    public String getAggregateRootId() {
        return this.aggregateRootId;
    }

    public void setAggregateRootId(String aggregateRootId) {
        this.aggregateRootId = aggregateRootId;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

