/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.commanding.CommandResult;
import org.enodeframework.commanding.CommandStatus;
import org.enodeframework.commanding.ProcessingCommand;
import org.enodeframework.commanding.ProcessingCommandMailbox;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.domain.AggregateRoot;
import org.enodeframework.domain.MemoryCache;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EventAppendResult;
import org.enodeframework.eventing.EventCommittingContext;
import org.enodeframework.eventing.EventCommittingContextMailBox;
import org.enodeframework.eventing.EventCommittingService;
import org.enodeframework.eventing.EventStore;
import org.enodeframework.messaging.Message;
import org.enodeframework.messaging.MessagePublisher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u000212B-\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u001e\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\rH\u0002J\u0010\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J\u001e\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0002J\u001e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\rH\u0002J&\u0010&\u001a\u00020\u00132\u0006\u0010'\u001a\u00020\r2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0\u00152\u0006\u0010*\u001a\u00020\u0011H\u0002J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\nH\u0016J&\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010,\u001a\u00020\n2\u0006\u0010\u0017\u001a\u00020\rH\u0002J.\u0010-\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010%\u001a\u00020\u00162\u0006\u0010.\u001a\u00020/2\u000e\u00100\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u0015H\u0002R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/enodeframework/eventing/impl/DefaultEventCommittingService;", "Lorg/enodeframework/eventing/EventCommittingService;", "memoryCache", "Lorg/enodeframework/domain/MemoryCache;", "eventStore", "Lorg/enodeframework/eventing/EventStore;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "domainEventPublisher", "Lorg/enodeframework/messaging/MessagePublisher;", "Lorg/enodeframework/eventing/DomainEventStream;", "(Lorg/enodeframework/domain/MemoryCache;Lorg/enodeframework/eventing/EventStore;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/messaging/MessagePublisher;)V", "eventMailBoxCount", "", "(Lorg/enodeframework/domain/MemoryCache;Lorg/enodeframework/eventing/EventStore;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/messaging/MessagePublisher;I)V", "eventCommittingContextMailBoxList", "", "Lorg/enodeframework/eventing/EventCommittingContextMailBox;", "batchPersistEventAsync", "", "committingContexts", "", "Lorg/enodeframework/eventing/EventCommittingContext;", "retryTimes", "commitDomainEventAsync", "eventCommittingContext", "completeCommand", "Ljava/util/concurrent/CompletableFuture;", "", "processingCommand", "Lorg/enodeframework/commanding/ProcessingCommand;", "commandResult", "Lorg/enodeframework/commanding/CommandResult;", "getEventMailBoxIndex", "aggregateRootId", "", "handleFirstEventDuplicationAsync", "context", "processDuplicateAggregateRootRecursively", "index", "contexts", "Lorg/enodeframework/eventing/impl/DefaultEventCommittingService$EventAppendContext;", "eventMailBox", "publishDomainEventAsync", "eventStream", "resetCommandMailBoxConsumingSequence", "consumingSequence", "", "duplicateCommandIdList", "Companion", "EventAppendContext", "enode"})
public final class DefaultEventCommittingService
implements EventCommittingService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MemoryCache memoryCache;
    @NotNull
    private final EventStore eventStore;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private final MessagePublisher<DomainEventStream> domainEventPublisher;
    private final int eventMailBoxCount;
    @NotNull
    private final List<EventCommittingContextMailBox> eventCommittingContextMailBoxList;
    private static final Logger logger = LoggerFactory.getLogger(DefaultEventCommittingService.class);

    public DefaultEventCommittingService(@NotNull MemoryCache memoryCache, @NotNull EventStore eventStore, @NotNull SerializeService serializeService, @NotNull MessagePublisher<DomainEventStream> domainEventPublisher, int eventMailBoxCount) {
        Intrinsics.checkNotNullParameter((Object)memoryCache, (String)"memoryCache");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter(domainEventPublisher, (String)"domainEventPublisher");
        this.memoryCache = memoryCache;
        this.eventStore = eventStore;
        this.serializeService = serializeService;
        this.domainEventPublisher = domainEventPublisher;
        this.eventMailBoxCount = eventMailBoxCount;
        this.eventCommittingContextMailBoxList = new ArrayList();
        int n = 0;
        int n2 = this.eventMailBoxCount;
        while (n < n2) {
            int i = n++;
            EventCommittingContextMailBox mailBox = new EventCommittingContextMailBox(i, 1000, arg_0 -> DefaultEventCommittingService._init_$lambda-27(this, arg_0));
            this.eventCommittingContextMailBoxList.add(mailBox);
        }
    }

    public DefaultEventCommittingService(@NotNull MemoryCache memoryCache, @NotNull EventStore eventStore, @NotNull SerializeService serializeService, @NotNull MessagePublisher<DomainEventStream> domainEventPublisher) {
        Intrinsics.checkNotNullParameter((Object)memoryCache, (String)"memoryCache");
        Intrinsics.checkNotNullParameter((Object)eventStore, (String)"eventStore");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter(domainEventPublisher, (String)"domainEventPublisher");
        this(memoryCache, eventStore, serializeService, domainEventPublisher, 4);
    }

    @Override
    public void commitDomainEventAsync(@NotNull EventCommittingContext eventCommittingContext) {
        Intrinsics.checkNotNullParameter((Object)eventCommittingContext, (String)"eventCommittingContext");
        String string = eventCommittingContext.getEventStream().getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eventCommittingContext.eventStream.aggregateRootId");
        int eventMailboxIndex = this.getEventMailBoxIndex(string);
        EventCommittingContextMailBox eventMailbox = this.eventCommittingContextMailBoxList.get(eventMailboxIndex);
        eventMailbox.enqueueMessage(eventCommittingContext);
    }

    @Override
    @NotNull
    public CompletableFuture<Boolean> publishDomainEventAsync(@NotNull ProcessingCommand processingCommand, @NotNull DomainEventStream eventStream) {
        Intrinsics.checkNotNullParameter((Object)processingCommand, (String)"processingCommand");
        Intrinsics.checkNotNullParameter((Object)eventStream, (String)"eventStream");
        eventStream.mergeItems(processingCommand.getItems());
        DomainEventStream eventStreamMessage = new DomainEventStream(processingCommand.getMessage().getId(), eventStream.getAggregateRootId(), eventStream.getVersion(), eventStream.getAggregateRootTypeName(), eventStream.getEvents(), eventStream.getItems());
        return this.publishDomainEventAsync(processingCommand, eventStreamMessage, 0);
    }

    private final int getEventMailBoxIndex(String aggregateRootId) {
        int hash = 23;
        char[] cArray = aggregateRootId.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
        for (char c : cArray) {
            hash = (hash << 5) - hash + c;
        }
        if (hash < 0) {
            hash = Math.abs(hash);
        }
        return hash % this.eventMailBoxCount;
    }

    private final void batchPersistEventAsync(List<EventCommittingContext> committingContexts, int retryTimes) {
        if (committingContexts.isEmpty()) {
            return;
        }
        IOHelper.tryAsyncActionRecursively("BatchPersistEventAsync", () -> DefaultEventCommittingService.batchPersistEventAsync$lambda-1(this, committingContexts), arg_0 -> DefaultEventCommittingService.batchPersistEventAsync$lambda-8(committingContexts, this, arg_0), () -> DefaultEventCommittingService.batchPersistEventAsync$lambda-9(committingContexts), null, retryTimes, true);
    }

    private final void processDuplicateAggregateRootRecursively(int index, List<EventAppendContext> contexts, EventCommittingContextMailBox eventMailBox) {
        if (contexts.isEmpty()) {
            return;
        }
        if (index == contexts.size()) {
            eventMailBox.completeRun();
            return;
        }
        EventAppendContext context = contexts.get(index);
        EventCommittingContext eventCommittingContext = context.getCommittingContext();
        List<String> duplicateCommandIdList = context.getDuplicateCommandIdList();
        if (context.getSuccess()) {
            this.publishDomainEventAsync(eventCommittingContext.getProcessingCommand(), eventCommittingContext.getEventStream()).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.processDuplicateAggregateRootRecursively$lambda-10(this, index, contexts, eventMailBox, arg_0, arg_1));
            return;
        }
        if (eventCommittingContext.getEventStream().getVersion() == 1) {
            this.handleFirstEventDuplicationAsync(eventCommittingContext, 0).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.processDuplicateAggregateRootRecursively$lambda-11(this, index, contexts, eventMailBox, arg_0, arg_1));
        } else {
            this.resetCommandMailBoxConsumingSequence(eventCommittingContext, eventCommittingContext.getProcessingCommand().getSequence(), duplicateCommandIdList).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.processDuplicateAggregateRootRecursively$lambda-12(this, index, contexts, eventMailBox, arg_0, arg_1));
        }
    }

    private final CompletableFuture<Boolean> resetCommandMailBoxConsumingSequence(EventCommittingContext context, long consumingSequence, List<String> duplicateCommandIdList) {
        ProcessingCommandMailbox commandMailBox = context.getProcessingCommand().getMailBox();
        EventCommittingContextMailBox eventMailBox = context.getMailBox();
        String aggregateRootId = context.getEventStream().getAggregateRootId();
        commandMailBox.pause();
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        Intrinsics.checkNotNullExpressionValue((Object)aggregateRootId, (String)"aggregateRootId");
        eventMailBox.removeAggregateAllEventCommittingContexts(aggregateRootId);
        String string = context.getEventStream().getAggregateRootTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.eventStream.aggregateRootTypeName");
        this.memoryCache.refreshAggregateFromEventStoreAsync(string, aggregateRootId).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.resetCommandMailBoxConsumingSequence$lambda-13(duplicateCommandIdList, commandMailBox, consumingSequence, future, arg_0, arg_1));
        return future;
    }

    private final CompletableFuture<Boolean> handleFirstEventDuplicationAsync(EventCommittingContext context, int retryTimes) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursively("FindFirstEventByVersion", () -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-14(this, context), arg_0 -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-21(context, this, future, arg_0), () -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-22(this, context), null, retryTimes, true);
        return future;
    }

    private final CompletableFuture<Boolean> publishDomainEventAsync(ProcessingCommand processingCommand, DomainEventStream eventStream, int retryTimes) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("PublishDomainEventAsync", () -> DefaultEventCommittingService.publishDomainEventAsync$lambda-23(this, eventStream), arg_0 -> DefaultEventCommittingService.publishDomainEventAsync$lambda-25(this, eventStream, processingCommand, future, arg_0), () -> DefaultEventCommittingService.publishDomainEventAsync$lambda-26(this, eventStream), null, retryTimes, true);
        return future;
    }

    private final CompletableFuture<Boolean> completeCommand(ProcessingCommand processingCommand, CommandResult commandResult) {
        return processingCommand.getMailBox().completeMessage(processingCommand, commandResult);
    }

    /*
     * WARNING - void declaration
     */
    private static final CompletableFuture batchPersistEventAsync$lambda-1(DefaultEventCommittingService this$0, List $committingContexts) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$committingContexts, (String)"$committingContexts");
        Iterable iterable = $committingContexts;
        EventStore eventStore = this$0.eventStore;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void obj;
            EventCommittingContext eventCommittingContext = (EventCommittingContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(obj.getEventStream());
        }
        return eventStore.batchAppendAsync((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private static final void batchPersistEventAsync$lambda-8(List $committingContexts, DefaultEventCommittingService this$0, EventAppendResult result) {
        void $this$firstOrNull$iv;
        Object key;
        Map<String, List<String>> map;
        Object $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)$committingContexts, (String)"$committingContexts");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        EventCommittingContextMailBox eventMailBox = ((EventCommittingContext)CollectionsKt.first((List)$committingContexts)).getMailBox();
        if (result == null) {
            logger.error("Batch persist events success, but the persist result is null, the current event committing mailbox should be pending, mailboxNumber: {}", (Object)eventMailBox.getNumber());
            return;
        }
        ArrayList<EventAppendContext> appendContextList = new ArrayList<EventAppendContext>();
        if (result.getSuccessAggregateRootIdList().size() > 0) {
            for (String string : result.getSuccessAggregateRootIdList()) {
                void $this$forEach$iv;
                Iterable iterable = $committingContexts;
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator iterator2 = $this$filterTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv$iv = iterator2.next();
                    EventCommittingContext x = (EventCommittingContext)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)x.getEventStream().getAggregateRootId(), (Object)string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                $this$filterTo$iv$iv = $this$forEach$iv.iterator();
                while ($this$filterTo$iv$iv.hasNext()) {
                    Object element$iv = $this$filterTo$iv$iv.next();
                    EventCommittingContext eventCommittingContext = (EventCommittingContext)element$iv;
                    boolean bl = false;
                    EventAppendContext context = new EventAppendContext();
                    context.setSuccess(true);
                    context.setDuplicateCommandIdList(new ArrayList());
                    context.setCommittingContext(eventCommittingContext);
                    appendContextList.add(context);
                }
            }
            if (logger.isDebugEnabled()) {
                Integer n = eventMailBox.getNumber();
                SerializeService serializeService = this$0.serializeService;
                map = result.getSuccessAggregateRootIdList();
                Intrinsics.checkNotNullExpressionValue(map, (String)"result.successAggregateRootIdList");
                logger.debug("Batch persist events success, mailboxNumber: {}, result: {}", (Object)n, (Object)serializeService.serialize(map));
            }
        }
        map = result.getDuplicateCommandAggregateRootIdList();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"result.duplicateCommandAggregateRootIdList");
        if (!map.isEmpty()) {
            Map<String, List<String>> map2 = result.getDuplicateCommandAggregateRootIdList();
            Intrinsics.checkNotNullExpressionValue(map2, (String)"result.duplicateCommandAggregateRootIdList");
            block3: for (Map.Entry<String, List<String>> entry : map2.entrySet()) {
                Iterator $this$filterTo$iv$iv2;
                Iterable $this$filter$iv2;
                key = entry.getKey();
                List<String> value = entry.getValue();
                $this$filterTo$iv$iv = $committingContexts;
                boolean $i$f$filter = false;
                void eventCommittingContext = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator x = $this$filterTo$iv$iv2.iterator();
                while (x.hasNext()) {
                    Object element$iv$iv = x.next();
                    EventCommittingContext x2 = (EventCommittingContext)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)key, (Object)x2.getEventStream().getAggregateRootId())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv2 = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                $this$filterTo$iv$iv2 = $this$firstOrNull$iv.iterator();
                while ($this$filterTo$iv$iv2.hasNext()) {
                    Object element$iv = $this$filterTo$iv$iv2.next();
                    EventCommittingContext eventCommittingContext2 = (EventCommittingContext)element$iv;
                    boolean bl = false;
                    EventAppendContext context = new EventAppendContext();
                    Intrinsics.checkNotNullExpressionValue(value, (String)"value");
                    context.setDuplicateCommandIdList(value);
                    context.setCommittingContext(eventCommittingContext2);
                    if (!appendContextList.add(context)) continue;
                    continue block3;
                }
            }
            Integer n = eventMailBox.getNumber();
            SerializeService serializeService = this$0.serializeService;
            map = result.getDuplicateCommandAggregateRootIdList();
            Intrinsics.checkNotNullExpressionValue(map, (String)"result.duplicateCommandAggregateRootIdList");
            logger.warn("Batch persist events has duplicate commandIds, mailboxNumber: {}, result: {}", (Object)n, (Object)serializeService.serialize(map));
        }
        if (result.getDuplicateEventAggregateRootIdList().size() > 0) {
            block6: for (String string : result.getDuplicateEventAggregateRootIdList()) {
                void $this$firstOrNull$iv2;
                key = $committingContexts;
                boolean $i$f$filter = false;
                $this$firstOrNull$iv = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                Iterator element$iv = $this$filterTo$iv$iv.iterator();
                while (element$iv.hasNext()) {
                    Object element$iv$iv = element$iv.next();
                    EventCommittingContext x = (EventCommittingContext)element$iv$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)x.getEventStream().getAggregateRootId(), (Object)string)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv2 : $this$firstOrNull$iv2) {
                    EventCommittingContext eventCommittingContext = (EventCommittingContext)element$iv2;
                    boolean bl = false;
                    EventAppendContext context = new EventAppendContext();
                    context.setDuplicateCommandIdList(new ArrayList());
                    context.setCommittingContext(eventCommittingContext);
                    if (!appendContextList.add(context)) continue;
                    continue block6;
                }
            }
            Integer n = eventMailBox.getNumber();
            SerializeService serializeService = this$0.serializeService;
            map = result.getDuplicateEventAggregateRootIdList();
            Intrinsics.checkNotNullExpressionValue(map, (String)"result.duplicateEventAggregateRootIdList");
            logger.warn("Batch persist events duplicated, mailboxNumber: {}, result: {}", (Object)n, (Object)serializeService.serialize(map));
        }
        this$0.processDuplicateAggregateRootRecursively(0, (List<EventAppendContext>)appendContextList, eventMailBox);
    }

    private static final String batchPersistEventAsync$lambda-9(List $committingContexts) {
        Intrinsics.checkNotNullParameter((Object)$committingContexts, (String)"$committingContexts");
        String string = "[contextListCount:%d]";
        Object[] objectArray = new Object[]{$committingContexts.size()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final void processDuplicateAggregateRootRecursively$lambda-10(DefaultEventCommittingService this$0, int $index, List $contexts, EventCommittingContextMailBox $eventMailBox, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$contexts, (String)"$contexts");
        Intrinsics.checkNotNullParameter((Object)$eventMailBox, (String)"$eventMailBox");
        this$0.processDuplicateAggregateRootRecursively($index + 1, $contexts, $eventMailBox);
    }

    private static final void processDuplicateAggregateRootRecursively$lambda-11(DefaultEventCommittingService this$0, int $index, List $contexts, EventCommittingContextMailBox $eventMailBox, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$contexts, (String)"$contexts");
        Intrinsics.checkNotNullParameter((Object)$eventMailBox, (String)"$eventMailBox");
        this$0.processDuplicateAggregateRootRecursively($index + 1, $contexts, $eventMailBox);
    }

    private static final void processDuplicateAggregateRootRecursively$lambda-12(DefaultEventCommittingService this$0, int $index, List $contexts, EventCommittingContextMailBox $eventMailBox, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$contexts, (String)"$contexts");
        Intrinsics.checkNotNullParameter((Object)$eventMailBox, (String)"$eventMailBox");
        this$0.processDuplicateAggregateRootRecursively($index + 1, $contexts, $eventMailBox);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void resetCommandMailBoxConsumingSequence$lambda-13(List $duplicateCommandIdList, ProcessingCommandMailbox $commandMailBox, long $consumingSequence, CompletableFuture $future, AggregateRoot $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$commandMailBox, (String)"$commandMailBox");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        try {
            if ($duplicateCommandIdList != null) {
                for (String commandId : $duplicateCommandIdList) {
                    $commandMailBox.addDuplicateCommandId(commandId);
                }
            }
            $commandMailBox.resetConsumingSequence($consumingSequence);
        }
        finally {
            $commandMailBox.resume();
            $commandMailBox.tryRun();
        }
        $future.complete(true);
    }

    private static final CompletableFuture handleFirstEventDuplicationAsync$lambda-14(DefaultEventCommittingService this$0, EventCommittingContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        EventStore eventStore = this$0.eventStore;
        String string = $context.getEventStream().getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.eventStream.aggregateRootId");
        return eventStore.findAsync(string, 1);
    }

    private static final void handleFirstEventDuplicationAsync$lambda-21$lambda-16$lambda-15(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void handleFirstEventDuplicationAsync$lambda-21$lambda-16(DefaultEventCommittingService this$0, EventCommittingContext $context, DomainEventStream $result, CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        this$0.publishDomainEventAsync($context.getProcessingCommand(), $result).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-21$lambda-16$lambda-15($future, arg_0, arg_1));
    }

    private static final void handleFirstEventDuplicationAsync$lambda-21$lambda-18$lambda-17(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void handleFirstEventDuplicationAsync$lambda-21$lambda-18(EventCommittingContext $context, DefaultEventCommittingService this$0, CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        String string = $context.getProcessingCommand().getMessage().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.processingCommand.message.id");
        String string2 = string;
        string = $context.getEventStream().getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.eventStream.aggregateRootId");
        String string3 = string;
        string = String.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
        CommandResult commandResult = new CommandResult(CommandStatus.Failed, string2, string3, "Duplicate aggregate creation.", string);
        this$0.completeCommand($context.getProcessingCommand(), commandResult).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-21$lambda-18$lambda-17($future, arg_0, arg_1));
    }

    private static final void handleFirstEventDuplicationAsync$lambda-21$lambda-20$lambda-19(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void handleFirstEventDuplicationAsync$lambda-21$lambda-20(EventCommittingContext $context, DefaultEventCommittingService this$0, CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        String string = $context.getProcessingCommand().getMessage().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.processingCommand.message.id");
        String string2 = string;
        string = $context.getEventStream().getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.eventStream.aggregateRootId");
        String string3 = string;
        string = String.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
        CommandResult commandResult = new CommandResult(CommandStatus.Failed, string2, string3, "Duplicate aggregate creation, but we cannot find the existing eventstream from eventstore.", string);
        this$0.completeCommand($context.getProcessingCommand(), commandResult).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-21$lambda-20$lambda-19($future, arg_0, arg_1));
    }

    private static final void handleFirstEventDuplicationAsync$lambda-21(EventCommittingContext $context, DefaultEventCommittingService this$0, CompletableFuture $future, DomainEventStream result) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (result != null) {
            if (Intrinsics.areEqual((Object)$context.getProcessingCommand().getMessage().getId(), (Object)result.getCommandId())) {
                this$0.resetCommandMailBoxConsumingSequence($context, $context.getProcessingCommand().getSequence() + 1L, null).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-21$lambda-16(this$0, $context, result, $future, arg_0, arg_1));
            } else {
                String string = "Duplicate aggregate creation. current commandId:%s, existing commandId:%s, aggregateRootId:%s, aggregateRootTypeName:%s";
                Object[] objectArray = new Object[]{$context.getProcessingCommand().getMessage().getId(), result.getCommandId(), result.getAggregateRootId(), result.getAggregateRootTypeName()};
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
                String errorMessage = string2;
                logger.error(errorMessage);
                this$0.resetCommandMailBoxConsumingSequence($context, $context.getProcessingCommand().getSequence() + 1L, null).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-21$lambda-18($context, this$0, $future, arg_0, arg_1));
            }
        } else {
            String string = "Duplicate aggregate creation, but we cannot find the existing eventstream from eventstore. commandId:%s, aggregateRootId:%s, aggregateRootTypeName:%s";
            Object[] objectArray = new Object[]{$context.getEventStream().getCommandId(), $context.getEventStream().getAggregateRootId(), $context.getEventStream().getAggregateRootTypeName()};
            String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(format, *args)");
            String errorMessage = string3;
            logger.error(errorMessage);
            this$0.resetCommandMailBoxConsumingSequence($context, $context.getProcessingCommand().getSequence() + 1L, null).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.handleFirstEventDuplicationAsync$lambda-21$lambda-20($context, this$0, $future, arg_0, arg_1));
        }
    }

    private static final String handleFirstEventDuplicationAsync$lambda-22(DefaultEventCommittingService this$0, EventCommittingContext $context) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        String string = "[eventStream:%s]";
        Object[] objectArray = new Object[]{this$0.serializeService.serialize($context.getEventStream())};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final CompletableFuture publishDomainEventAsync$lambda-23(DefaultEventCommittingService this$0, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        return this$0.domainEventPublisher.publishAsync((DomainEventStream)((Message)$eventStream));
    }

    private static final void publishDomainEventAsync$lambda-25$lambda-24(CompletableFuture $future, Boolean $noName_0, Throwable $noName_1) {
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        $future.complete(true);
    }

    private static final void publishDomainEventAsync$lambda-25(DefaultEventCommittingService this$0, DomainEventStream $eventStream, ProcessingCommand $processingCommand, CompletableFuture $future, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        Intrinsics.checkNotNullParameter((Object)$processingCommand, (String)"$processingCommand");
        Intrinsics.checkNotNullParameter((Object)$future, (String)"$future");
        if (logger.isDebugEnabled()) {
            logger.debug("Publish domain events success, {}", (Object)this$0.serializeService.serialize($eventStream));
        }
        String commandHandleResult = $processingCommand.getCommandExecuteContext().getResult();
        String string = $processingCommand.getMessage().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processingCommand.message.id");
        String string2 = string;
        string = $eventStream.getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"eventStream.aggregateRootId");
        String string3 = string;
        string = String.class.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"String::class.java.name");
        CommandResult commandResult = new CommandResult(CommandStatus.Success, string2, string3, commandHandleResult, string);
        this$0.completeCommand($processingCommand, commandResult).whenComplete((arg_0, arg_1) -> DefaultEventCommittingService.publishDomainEventAsync$lambda-25$lambda-24($future, arg_0, arg_1));
    }

    private static final String publishDomainEventAsync$lambda-26(DefaultEventCommittingService this$0, DomainEventStream $eventStream) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$eventStream, (String)"$eventStream");
        String string = "[eventStream:%s]";
        Object[] objectArray = new Object[]{this$0.serializeService.serialize($eventStream)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final void _init_$lambda-27(DefaultEventCommittingService this$0, List x) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)x, (String)"x");
        this$0.batchPersistEventAsync(x, 0);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR \u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0016"}, d2={"Lorg/enodeframework/eventing/impl/DefaultEventCommittingService$EventAppendContext;", "", "()V", "committingContext", "Lorg/enodeframework/eventing/EventCommittingContext;", "getCommittingContext", "()Lorg/enodeframework/eventing/EventCommittingContext;", "setCommittingContext", "(Lorg/enodeframework/eventing/EventCommittingContext;)V", "duplicateCommandIdList", "", "", "getDuplicateCommandIdList", "()Ljava/util/List;", "setDuplicateCommandIdList", "(Ljava/util/List;)V", "success", "", "getSuccess", "()Z", "setSuccess", "(Z)V", "enode"})
    public static final class EventAppendContext {
        public EventCommittingContext committingContext;
        @NotNull
        private List<String> duplicateCommandIdList = new ArrayList();
        private boolean success;

        @NotNull
        public final EventCommittingContext getCommittingContext() {
            EventCommittingContext eventCommittingContext = this.committingContext;
            if (eventCommittingContext != null) {
                return eventCommittingContext;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"committingContext");
            return null;
        }

        public final void setCommittingContext(@NotNull EventCommittingContext eventCommittingContext) {
            Intrinsics.checkNotNullParameter((Object)eventCommittingContext, (String)"<set-?>");
            this.committingContext = eventCommittingContext;
        }

        @NotNull
        public final List<String> getDuplicateCommandIdList() {
            return this.duplicateCommandIdList;
        }

        public final void setDuplicateCommandIdList(@NotNull List<String> list) {
            Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
            this.duplicateCommandIdList = list;
        }

        public final boolean getSuccess() {
            return this.success;
        }

        public final void setSuccess(boolean bl) {
            this.success = bl;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/eventing/impl/DefaultEventCommittingService$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

