/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.eventing.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.enodeframework.common.extensions.SystemClock;
import org.enodeframework.common.io.IOHelper;
import org.enodeframework.common.io.Task;
import org.enodeframework.common.scheduling.ScheduleService;
import org.enodeframework.common.serializing.SerializeService;
import org.enodeframework.eventing.DomainEventMessage;
import org.enodeframework.eventing.DomainEventStream;
import org.enodeframework.eventing.EnqueueMessageResult;
import org.enodeframework.eventing.ProcessingEvent;
import org.enodeframework.eventing.ProcessingEventMailBox;
import org.enodeframework.eventing.ProcessingEventProcessor;
import org.enodeframework.eventing.PublishedVersionStore;
import org.enodeframework.messaging.MessageDispatcher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000 .2\u00020\u0001:\u0001.B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u001cH\u0002J\u0018\u0010\"\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0013H\u0002J\u0018\u0010%\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020\u0013H\u0002J\u0010\u0010'\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u000eH\u0002J\u0010\u0010(\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020\u001cH\u0002J\b\u0010*\u001a\u00020\u001cH\u0016J\b\u0010+\u001a\u00020\u001cH\u0016J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010&\u001a\u00020\u000eH\u0002J\u0018\u0010-\u001a\u00020\u001c2\u0006\u0010#\u001a\u00020 2\u0006\u0010$\u001a\u00020\u0013H\u0002R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00160\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/enodeframework/eventing/impl/DefaultProcessingEventProcessor;", "Lorg/enodeframework/eventing/ProcessingEventProcessor;", "scheduleService", "Lorg/enodeframework/common/scheduling/ScheduleService;", "serializeService", "Lorg/enodeframework/common/serializing/SerializeService;", "messageDispatcher", "Lorg/enodeframework/messaging/MessageDispatcher;", "publishedVersionStore", "Lorg/enodeframework/eventing/PublishedVersionStore;", "(Lorg/enodeframework/common/scheduling/ScheduleService;Lorg/enodeframework/common/serializing/SerializeService;Lorg/enodeframework/messaging/MessageDispatcher;Lorg/enodeframework/eventing/PublishedVersionStore;)V", "mailboxDict", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/enodeframework/eventing/ProcessingEventMailBox;", "name", "getName", "()Ljava/lang/String;", "processTryToRefreshAggregateIntervalMilliseconds", "", "processTryToRefreshAggregateTaskName", "refreshingAggregateRootDict", "", "scanExpiredAggregateIntervalMilliseconds", "scanInactiveMailBoxTaskName", "timeoutSeconds", "toRefreshAggregateRootMailBoxDict", "addToRefreshAggregateMailBoxToDict", "", "mailbox", "buildProcessingEventMailBox", "processingMessage", "Lorg/enodeframework/eventing/ProcessingEvent;", "cleanInactiveMailbox", "dispatchProcessingMessageAsync", "processingEvent", "retryTimes", "getAggregateRootLatestPublishedEventVersion", "processingEventMailBox", "isMailBoxAllowRemove", "process", "processToRefreshAggregateRootMailBoxs", "start", "stop", "tryToRefreshAggregateMailBoxNextExpectingEventVersion", "updatePublishedVersionAsync", "Companion", "enode"})
public final class DefaultProcessingEventProcessor
implements ProcessingEventProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScheduleService scheduleService;
    @NotNull
    private final SerializeService serializeService;
    @NotNull
    private final MessageDispatcher messageDispatcher;
    @NotNull
    private final PublishedVersionStore publishedVersionStore;
    @NotNull
    private final String scanInactiveMailBoxTaskName;
    @NotNull
    private final String processTryToRefreshAggregateTaskName;
    @NotNull
    private final String name;
    @NotNull
    private final ConcurrentHashMap<String, ProcessingEventMailBox> toRefreshAggregateRootMailBoxDict;
    @NotNull
    private final ConcurrentHashMap<String, ProcessingEventMailBox> mailboxDict;
    @NotNull
    private final ConcurrentHashMap<String, Boolean> refreshingAggregateRootDict;
    private int timeoutSeconds;
    private int scanExpiredAggregateIntervalMilliseconds;
    private int processTryToRefreshAggregateIntervalMilliseconds;
    private static final Logger logger = LoggerFactory.getLogger(DefaultProcessingEventProcessor.class);

    public DefaultProcessingEventProcessor(@NotNull ScheduleService scheduleService, @NotNull SerializeService serializeService, @NotNull MessageDispatcher messageDispatcher, @NotNull PublishedVersionStore publishedVersionStore) {
        Intrinsics.checkNotNullParameter((Object)scheduleService, (String)"scheduleService");
        Intrinsics.checkNotNullParameter((Object)serializeService, (String)"serializeService");
        Intrinsics.checkNotNullParameter((Object)messageDispatcher, (String)"messageDispatcher");
        Intrinsics.checkNotNullParameter((Object)publishedVersionStore, (String)"publishedVersionStore");
        this.scheduleService = scheduleService;
        this.serializeService = serializeService;
        this.messageDispatcher = messageDispatcher;
        this.publishedVersionStore = publishedVersionStore;
        this.scanInactiveMailBoxTaskName = "CleanInactiveProcessingEventMailBoxes_" + SystemClock.now() + new Random().nextInt(10000);
        this.processTryToRefreshAggregateTaskName = "ProcessTryToRefreshAggregate_" + SystemClock.now() + new Random().nextInt(10000);
        this.name = "DefaultEventProcessor";
        this.toRefreshAggregateRootMailBoxDict = new ConcurrentHashMap();
        this.mailboxDict = new ConcurrentHashMap();
        this.refreshingAggregateRootDict = new ConcurrentHashMap();
        this.timeoutSeconds = 259200;
        this.scanExpiredAggregateIntervalMilliseconds = 5000;
        this.processTryToRefreshAggregateIntervalMilliseconds = 1000;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    public void process(@NotNull ProcessingEvent processingEvent) {
        EnqueueMessageResult enqueueResult;
        Intrinsics.checkNotNullParameter((Object)processingEvent, (String)"processingEvent");
        String aggregateRootId = processingEvent.getMessage().getAggregateRootId();
        if (!(!Strings.isNullOrEmpty((String)aggregateRootId))) {
            boolean $i$a$-require-DefaultProcessingEventProcessor$process$22 = false;
            String $i$a$-require-DefaultProcessingEventProcessor$process$22 = Intrinsics.stringPlus((String)"aggregateRootId of domain event stream cannot be null or empty, domainEventStreamId:", (Object)processingEvent.getMessage().getId());
            throw new IllegalArgumentException($i$a$-require-DefaultProcessingEventProcessor$process$22.toString());
        }
        ProcessingEventMailBox $i$a$-require-DefaultProcessingEventProcessor$process$22 = this.mailboxDict.computeIfAbsent(aggregateRootId, arg_0 -> DefaultProcessingEventProcessor.process$lambda-1(this, processingEvent, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)$i$a$-require-DefaultProcessingEventProcessor$process$22, (String)"mailboxDict.computeIfAbs\u2026ailBox(processingEvent) }");
        ProcessingEventMailBox mailbox = $i$a$-require-DefaultProcessingEventProcessor$process$22;
        long mailboxTryUsingCount = 0L;
        while (!mailbox.tryUsing()) {
            Task.sleep(1L);
            long l = mailboxTryUsingCount;
            if ((mailboxTryUsingCount = l + 1L) % (long)10000 != 0L) continue;
            Object[] objectArray = new Object[]{mailboxTryUsingCount, mailbox.getAggregateRootId(), mailbox.getAggregateRootTypeName()};
            logger.warn("Event mailbox try using count: {}, aggregateRootId: {}, aggregateRootTypeName: {}", objectArray);
        }
        if (mailbox.isRemoved()) {
            ProcessingEventMailBox processingEventMailBox = this.mailboxDict.computeIfAbsent(aggregateRootId, arg_0 -> DefaultProcessingEventProcessor.process$lambda-2(this, processingEvent, arg_0));
            Intrinsics.checkNotNullExpressionValue((Object)processingEventMailBox, (String)"mailboxDict.computeIfAbs\u2026ssingEvent)\n            }");
            mailbox = processingEventMailBox;
        }
        if ((enqueueResult = mailbox.enqueueMessage(processingEvent)) == EnqueueMessageResult.Ignored) {
            processingEvent.getProcessContext().notifyEventProcessed();
        } else if (enqueueResult == EnqueueMessageResult.AddToWaitingList) {
            this.addToRefreshAggregateMailBoxToDict(mailbox);
        }
        mailbox.exitUsing();
    }

    private final void addToRefreshAggregateMailBoxToDict(ProcessingEventMailBox mailbox) {
        if (this.toRefreshAggregateRootMailBoxDict.putIfAbsent(mailbox.getAggregateRootId(), mailbox) == null) {
            logger.info("Added toRefreshPublishedVersion aggregate mailbox, aggregateRootTypeName: {}, aggregateRootId: {}", (Object)mailbox.getAggregateRootTypeName(), (Object)mailbox.getAggregateRootId());
            this.tryToRefreshAggregateMailBoxNextExpectingEventVersion(mailbox);
        }
    }

    private final ProcessingEventMailBox buildProcessingEventMailBox(ProcessingEvent processingMessage) {
        String string = processingMessage.getMessage().getAggregateRootTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processingMessage.messag\u2026etAggregateRootTypeName()");
        String string2 = string;
        string = processingMessage.getMessage().getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"processingMessage.message.getAggregateRootId()");
        return new ProcessingEventMailBox(string2, string, arg_0 -> DefaultProcessingEventProcessor.buildProcessingEventMailBox$lambda-3(this, arg_0));
    }

    private final void tryToRefreshAggregateMailBoxNextExpectingEventVersion(ProcessingEventMailBox processingEventMailBox) {
        if (this.refreshingAggregateRootDict.putIfAbsent(processingEventMailBox.getAggregateRootId(), true) == null) {
            this.getAggregateRootLatestPublishedEventVersion(processingEventMailBox, 0);
        }
    }

    private final void getAggregateRootLatestPublishedEventVersion(ProcessingEventMailBox processingEventMailBox, int retryTimes) {
        IOHelper.tryAsyncActionRecursively("GetAggregateRootLatestPublishedEventVersion", () -> DefaultProcessingEventProcessor.getAggregateRootLatestPublishedEventVersion$lambda-4(this, processingEventMailBox), arg_0 -> DefaultProcessingEventProcessor.getAggregateRootLatestPublishedEventVersion$lambda-5(processingEventMailBox, this, arg_0), () -> DefaultProcessingEventProcessor.getAggregateRootLatestPublishedEventVersion$lambda-6(processingEventMailBox), null, retryTimes, true);
    }

    @Override
    public void start() {
        this.scheduleService.startTask(this.scanInactiveMailBoxTaskName, () -> DefaultProcessingEventProcessor.start$lambda-7(this), this.scanExpiredAggregateIntervalMilliseconds, this.scanExpiredAggregateIntervalMilliseconds);
        this.scheduleService.startTask(this.processTryToRefreshAggregateTaskName, () -> DefaultProcessingEventProcessor.start$lambda-8(this), this.processTryToRefreshAggregateIntervalMilliseconds, this.processTryToRefreshAggregateIntervalMilliseconds);
    }

    @Override
    public void stop() {
        this.scheduleService.stopTask(this.scanInactiveMailBoxTaskName);
        this.scheduleService.stopTask(this.processTryToRefreshAggregateTaskName);
    }

    private final void dispatchProcessingMessageAsync(ProcessingEvent processingEvent, int retryTimes) {
        IOHelper.tryAsyncActionRecursivelyWithoutResult("DispatchProcessingMessageAsync", () -> DefaultProcessingEventProcessor.dispatchProcessingMessageAsync$lambda-9(this, processingEvent), arg_0 -> DefaultProcessingEventProcessor.dispatchProcessingMessageAsync$lambda-10(this, processingEvent, arg_0), () -> DefaultProcessingEventProcessor.dispatchProcessingMessageAsync$lambda-11(processingEvent), null, retryTimes, true);
    }

    private final void updatePublishedVersionAsync(ProcessingEvent processingEvent, int retryTimes) {
        DomainEventStream message = processingEvent.getMessage();
        IOHelper.tryAsyncActionRecursivelyWithoutResult("UpdatePublishedVersionAsync", () -> DefaultProcessingEventProcessor.updatePublishedVersionAsync$lambda-12(this, message), arg_0 -> DefaultProcessingEventProcessor.updatePublishedVersionAsync$lambda-13(this, message, processingEvent, arg_0), () -> DefaultProcessingEventProcessor.updatePublishedVersionAsync$lambda-14(message), null, retryTimes, true);
    }

    private final void processToRefreshAggregateRootMailBoxs() {
        ArrayList arrayList = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)arrayList, (String)"newArrayList()");
        List remainingMailboxList = arrayList;
        Iterator iterator = Lists.newArrayList();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"newArrayList()");
        List recoveredMailboxList = (List)((Object)iterator);
        iterator = this.toRefreshAggregateRootMailBoxDict.values();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"toRefreshAggregateRootMailBoxDict.values");
        Iterable $this$forEach$iv = (Iterable)((Object)iterator);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessingEventMailBox aggregateRootMailBox = (ProcessingEventMailBox)element$iv;
            boolean bl = false;
            if (aggregateRootMailBox.getWaitingMessageCount() > 0) {
                remainingMailboxList.add(aggregateRootMailBox);
                continue;
            }
            recoveredMailboxList.add(aggregateRootMailBox);
        }
        for (ProcessingEventMailBox mailBox : remainingMailboxList) {
            this.tryToRefreshAggregateMailBoxNextExpectingEventVersion(mailBox);
        }
        for (ProcessingEventMailBox mailBox : recoveredMailboxList) {
            ProcessingEventMailBox removed = this.toRefreshAggregateRootMailBoxDict.remove(mailBox.getAggregateRootId());
            if (removed == null) continue;
            logger.info("Removed healthy aggregate mailbox, aggregateRootTypeName: {}, aggregateRootId: {}", (Object)removed.getAggregateRootTypeName(), (Object)removed.getAggregateRootId());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void cleanInactiveMailbox() {
        void $this$filterTo$iv$iv;
        Set<Map.Entry<String, ProcessingEventMailBox>> set = this.mailboxDict.entrySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"mailboxDict.entries");
        Iterable $this$filter$iv = set;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            boolean bl = false;
            Object v = entry.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"entry.value");
            if (!this.isMailBoxAllowRemove((ProcessingEventMailBox)v)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List inactiveList = (List)destination$iv$iv;
        Iterable $this$forEach$iv = inactiveList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ProcessingEventMailBox removed;
            Map.Entry $dstr$key$value = (Map.Entry)element$iv;
            boolean bl = false;
            String key = (String)$dstr$key$value.getKey();
            ProcessingEventMailBox value = (ProcessingEventMailBox)$dstr$key$value.getValue();
            if (!value.tryUsing() || !this.isMailBoxAllowRemove(value) || (removed = this.mailboxDict.remove(key)) == null) continue;
            removed.markAsRemoved();
            logger.info("Removed inactive domain event stream mailbox, aggregateRootTypeName: {}, aggregateRootId: {}", (Object)removed.getAggregateRootTypeName(), (Object)removed.getAggregateRootId());
        }
    }

    private final boolean isMailBoxAllowRemove(ProcessingEventMailBox mailbox) {
        return mailbox.isInactive(this.timeoutSeconds) && !mailbox.isRunning() && mailbox.getTotalUnHandledMessageCount() == 0 && mailbox.getWaitingMessageCount() == 0;
    }

    private static final ProcessingEventMailBox process$lambda-1(DefaultProcessingEventProcessor this$0, ProcessingEvent $processingEvent, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.buildProcessingEventMailBox($processingEvent);
    }

    private static final ProcessingEventMailBox process$lambda-2(DefaultProcessingEventProcessor this$0, ProcessingEvent $processingEvent, String it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.buildProcessingEventMailBox($processingEvent);
    }

    private static final void buildProcessingEventMailBox$lambda-3(DefaultProcessingEventProcessor this$0, ProcessingEvent y) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)y, (String)"y");
        this$0.dispatchProcessingMessageAsync(y, 0);
    }

    private static final CompletableFuture getAggregateRootLatestPublishedEventVersion$lambda-4(DefaultProcessingEventProcessor this$0, ProcessingEventMailBox $processingEventMailBox) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEventMailBox, (String)"$processingEventMailBox");
        return this$0.publishedVersionStore.getPublishedVersionAsync(this$0.getName(), $processingEventMailBox.getAggregateRootTypeName(), $processingEventMailBox.getAggregateRootId());
    }

    private static final void getAggregateRootLatestPublishedEventVersion$lambda-5(ProcessingEventMailBox $processingEventMailBox, DefaultProcessingEventProcessor this$0, int result) {
        Intrinsics.checkNotNullParameter((Object)$processingEventMailBox, (String)"$processingEventMailBox");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        $processingEventMailBox.setNextExpectingEventVersion(result + 1);
        this$0.refreshingAggregateRootDict.remove($processingEventMailBox.getAggregateRootId());
    }

    private static final String getAggregateRootLatestPublishedEventVersion$lambda-6(ProcessingEventMailBox $processingEventMailBox) {
        Intrinsics.checkNotNullParameter((Object)$processingEventMailBox, (String)"$processingEventMailBox");
        String string = "publishedVersionStore.GetPublishedVersionAsync has unknown exception, aggregateRootTypeName: %s, aggregateRootId: %s";
        Object[] objectArray = new Object[]{$processingEventMailBox.getAggregateRootTypeName(), $processingEventMailBox.getAggregateRootId()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final void start$lambda-7(DefaultProcessingEventProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.cleanInactiveMailbox();
    }

    private static final void start$lambda-8(DefaultProcessingEventProcessor this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.processToRefreshAggregateRootMailBoxs();
    }

    private static final CompletableFuture dispatchProcessingMessageAsync$lambda-9(DefaultProcessingEventProcessor this$0, ProcessingEvent $processingEvent) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        MessageDispatcher messageDispatcher = this$0.messageDispatcher;
        List<DomainEventMessage<?>> list = $processingEvent.getMessage().getEvents();
        Intrinsics.checkNotNullExpressionValue(list, (String)"processingEvent.message.events");
        return messageDispatcher.dispatchMessagesAsync(list);
    }

    private static final void dispatchProcessingMessageAsync$lambda-10(DefaultProcessingEventProcessor this$0, ProcessingEvent $processingEvent, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        if (logger.isDebugEnabled()) {
            SerializeService serializeService = this$0.serializeService;
            DomainEventStream domainEventStream = $processingEvent.getMessage();
            Intrinsics.checkNotNullExpressionValue((Object)domainEventStream, (String)"processingEvent.message");
            logger.debug("dispatch messages success, msg: {}", (Object)serializeService.serialize(domainEventStream));
        }
        this$0.updatePublishedVersionAsync($processingEvent, 0);
    }

    private static final String dispatchProcessingMessageAsync$lambda-11(ProcessingEvent $processingEvent) {
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        String string = "sequence message [messageId:%s, messageType:%s, aggregateRootId:%s, aggregateRootVersion:%s]";
        Object[] objectArray = new Object[]{$processingEvent.getMessage().getId(), $processingEvent.getMessage().getClass().getName(), $processingEvent.getMessage().getAggregateRootId(), $processingEvent.getMessage().getVersion()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    private static final CompletableFuture updatePublishedVersionAsync$lambda-12(DefaultProcessingEventProcessor this$0, DomainEventStream $message) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        PublishedVersionStore publishedVersionStore = this$0.publishedVersionStore;
        String string = this$0.getName();
        String string2 = $message.getAggregateRootTypeName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.getAggregateRootTypeName()");
        String string3 = string2;
        string2 = $message.getAggregateRootId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message.getAggregateRootId()");
        return publishedVersionStore.updatePublishedVersionAsync(string, string3, string2, $message.getVersion());
    }

    private static final void updatePublishedVersionAsync$lambda-13(DefaultProcessingEventProcessor this$0, DomainEventStream $message, ProcessingEvent $processingEvent, Integer it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$processingEvent, (String)"$processingEvent");
        if (logger.isDebugEnabled()) {
            SerializeService serializeService = this$0.serializeService;
            Intrinsics.checkNotNullExpressionValue((Object)$message, (String)"message");
            logger.debug("update published version success, message ack: {}", (Object)serializeService.serialize($message));
        }
        $processingEvent.complete();
    }

    private static final String updatePublishedVersionAsync$lambda-14(DomainEventStream $message) {
        String string = "DomainEventStreamMessage [messageId:%s, messageType:%s, aggregateRootId:%s, aggregateRootVersion:%s]";
        Object[] objectArray = new Object[]{$message.getId(), $message.getClass().getName(), $message.getAggregateRootId(), $message.getVersion()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
        return string2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/enodeframework/eventing/impl/DefaultProcessingEventProcessor$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "enode"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

