/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging.impl;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.enodeframework.infrastructure.ObjectProxy;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.messaging.Message;
import org.enodeframework.messaging.impl.RootDispatching;

public class MultiMessageDispatching {
    private final Message[] messages;
    private final ConcurrentMap<String, ObjectProxy> handlerDict;
    private final RootDispatching rootDispatching;

    public MultiMessageDispatching(List<? extends Message> messages, List<? extends ObjectProxy> handlers, RootDispatching rootDispatching, TypeNameProvider typeNameProvider) {
        this.messages = messages.toArray(new Message[0]);
        this.handlerDict = new ConcurrentHashMap<String, ObjectProxy>();
        handlers.forEach(x -> this.handlerDict.putIfAbsent(typeNameProvider.getTypeName(x.getInnerObject().getClass()), (ObjectProxy)x));
        this.rootDispatching = rootDispatching;
        this.rootDispatching.addChildDispatching(this);
    }

    public Message[] getMessages() {
        return this.messages;
    }

    public void removeHandledHandler(String handlerTypeName) {
        if (this.handlerDict.remove(handlerTypeName) != null && this.handlerDict.isEmpty()) {
            this.rootDispatching.onChildDispatchingFinished(this);
        }
    }
}

