/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging.impl;

import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.enodeframework.messaging.Message;
import org.enodeframework.messaging.impl.DefaultMessageDispatcher;
import org.enodeframework.messaging.impl.RootDispatching;

public class QueueMessageDispatching {
    private final DefaultMessageDispatcher dispatcher;
    private final RootDispatching rootDispatching;
    private final ConcurrentLinkedQueue<Message> messageQueue;

    public QueueMessageDispatching(DefaultMessageDispatcher dispatcher, RootDispatching rootDispatching, List<? extends Message> messages) {
        this.dispatcher = dispatcher;
        this.messageQueue = new ConcurrentLinkedQueue();
        this.messageQueue.addAll(messages);
        this.rootDispatching = rootDispatching;
        this.rootDispatching.addChildDispatching(this);
    }

    public Message dequeueMessage() {
        return this.messageQueue.poll();
    }

    public void onMessageHandled(Message message) {
        Message nextMessage = this.dequeueMessage();
        if (nextMessage == null) {
            this.rootDispatching.onChildDispatchingFinished(this);
            return;
        }
        this.dispatcher.dispatchSingleMessage(nextMessage, this);
    }
}

