/*
 * Decompiled with CFR 0.152.
 */
package org.enodeframework.messaging.impl;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.enodeframework.infrastructure.ObjectProxy;
import org.enodeframework.infrastructure.TypeNameProvider;
import org.enodeframework.messaging.Message;
import org.enodeframework.messaging.impl.QueueMessageDispatching;

public class SingleMessageDispatching {
    private final ConcurrentHashMap<String, ObjectProxy> handlerDict;
    private final QueueMessageDispatching queueMessageDispatching;
    private final Message message;

    public SingleMessageDispatching(Message message, QueueMessageDispatching queueMessageDispatching, List<? extends ObjectProxy> handlers, TypeNameProvider typeNameProvider) {
        this.message = message;
        this.queueMessageDispatching = queueMessageDispatching;
        this.handlerDict = new ConcurrentHashMap();
        handlers.forEach(x -> this.handlerDict.putIfAbsent(typeNameProvider.getTypeName(x.getInnerObject().getClass()), (ObjectProxy)x));
    }

    public void removeHandledHandler(String handlerTypeName) {
        if (this.handlerDict.remove(handlerTypeName) != null && this.handlerDict.isEmpty()) {
            this.queueMessageDispatching.onMessageHandled(this.message);
        }
    }

    public Message getMessage() {
        return this.message;
    }
}

